@include('layouts.header')
			<!-- /Header -->
			@include('layouts.sidebar')

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Purchase Orders</h4>
								<h6>Manage your Purchase orders</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="{{ route('add_purchase_order')}}" class="btn btn-added" ><i data-feather="plus-circle" class="me-2"></i>Add New Purchase</a>
						</div>
					</div>
					@if(session()->has('success'))
					<div class="alert alert-success">{{ session()->get('success') }}</div>
				@endif
				@if(session()->has('error'))
					<div class="alert alert-danger">{{ session()->get('error') }}</div>
				@endif
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								{{--<div class="search-path">
									<a class="btn btn-filter" id="filter_search">
										<i data-feather="filter" class="filter-icon"></i>
										<span><img src="assets/img/icons/closes.svg" alt="img"></span>
									</a>
								</div>
								 <div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div> --}}
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select">
													<option>Choose Category</option>
													<option>Laptop</option>
													<option>Electronics</option>
													<option>Shoe</option>
												</select>
											</div>
										</div>
										{{-- <div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="calendar" class="info-img"></i>
												<div class="input-groupicon">
													<input type="text" class="datetimepicker" placeholder="Choose Date" >
												</div>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select">
													<option>Choose Status</option>
													<option>Active</option>
													<option>Inactive</option>
												</select>
											</div>
										</div> --}}
										<div class="col-lg-3 col-sm-6 col-12 ms-auto">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>	
							<!-- /Filter -->
							<div class="table-responsive product-list">
							

								<table class="table  datanew">
									<thead>
										<tr>
									        <th class="no-sort">Action</th>
										    <th>PO Number</th>
										    <th>Company</th>
										    <th>Supplier</th>
										    <th>Grand Total</th>
											<th>Inward Status</th>
											<th>View Inwards</th>
										</tr>
									</thead>
									<tbody>
										@foreach($purchase_orders as $row) 
										
										<tr>
										<td class="action-table-data">
												<div class="edit-delete-action">
													 <a class="me-2 p-2" href="{{ url('view-purchase-orders/'.$row->id)}}">
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye action-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
													</a>
										
													<style>
										
													a.mail-sent svg {
														stroke: red !important;
													}</style>

												<a class="me-2 p-2 preview-mail-btn {{ $row->preview == 1 ? 'mail-sent' : '' }}" 
													href="{{ url('preview-purchase-order/'.$row->id) }}" 
													data-preview="{{ $row->preview }}" 
												title="{{ $row->preview == 1 ? 'Mail already sent to party' : 'Send Mail To Party' }}">
													<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"
															fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
															stroke-linejoin="round" class="feather feather-mail action-mail">
															<path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
															<polyline points="22,6 12,13 2,6"/>
														</svg>
													</a>

																
													  
													<!-- <a class="me-2 p-2" href="{{ url('edit-purchase-order/'.$row->id)}}" >
														<i data-feather="edit" class="feather-edit"></i>
													</a> -->
														<a class="me-2 p-2 edit-link" 
													href="{{ $row->inward_status == 0 ? url('edit-purchase-order/'.$row->id) : '#' }}" 
													data-status="{{ $row->inward_status }}">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
                                                    
													 <a class="confirm-text p-2 delete-action" data-id="{{ $row->id}}" data-inward-status="{{ $row->inward_status }}"  href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a> 
													

												</div>
												
										</td>
                                           <td>{{ $row->po_number}}</td>
											<td>{{ $row->company_name}}</td>
											<td>{{ $row->supplier_name}}</td>
											<td>₹ {{ $row->grand_total}}</td>
											@if($row->inward_status == 1)
											<td><button type="button" class="btn btn-md btn-outline-success my-1 me-2">
												Full Inward
											</button></td>
											@elseif($row->inward_status == 2)
                                            <td><button type="button" class="btn btn-md btn-outline-danger my-1 me-2">
												Partial Inward
											</button></td>
											@else
											<td><button type="button" class="btn btn-md btn-outline-warning my-1 me-2">
											   Pending Inward
											</button></td>
											@endif

											@if($row->inward_status != 0)
												<td><a href="{{ url('view-all-inwards/'.$row->id)}}" class="btn btn-info">View</a></td>
											@else
												<td></td> {{-- Empty cell if inward_status is 0 --}}
											@endif
										</tr>
											@endforeach				
									</tbody>
								</table>
								
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->

	

	

		
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		
        <script>
           function editCategory(id, name, status) {
    // Set the values in the modal form
    document.getElementById('edit-id').value = id;
    document.getElementById('edit-name').value = name;
    
     // Convert status to a string and set the selected status
	 var statusSelect = document.getElementById('edit-status');
    status = String(status);  // Ensure status is a string

    // Set the value of the select box
    statusSelect.value = status;

    // Handle showing which option is selected
    if (status === "0") {
        // Show selected "Inactive" option
        statusSelect.value = "0";  // Ensure the inactive option is selected
        console.log("Inactive status selected");
    } else if (status === "1") {
        // Show selected "Active" option
        statusSelect.value = "1";  // Ensure the active option is selected
        console.log("Active status selected");
    }
    
    
}

function viewCategory(id, name){
	document.getElementById('id').value = id;
    document.getElementById('name').value = name;
}

        

			$('#edit-category').on('hidden.bs.modal', function () {
    $(this).find('form')[0].reset();  // Clear the form
});


	$(document).ready(function () {

		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
        });

		// $(document).on('click', '.delete-action', function (e) {
			
        //     e.preventDefault();
        //     var userId = $(this).data('id');
			
        //     var deleteUrl = "{{ url('delete-purchase-order') }}/" + userId;

        //     Swal.fire({
        //         title: 'Are you sure?',
        //         text: "Delete Purchase Order!",
        //         icon: 'warning',
        //         showCancelButton: true,
        //         confirmButtonColor: '#3085d6',
        //         cancelButtonColor: '#d33',
        //         confirmButtonText: 'Yes, delete it!'
        //     }).then((result) => {
        //         if (result.isConfirmed) {
        //             $.ajax({

						
        //                 url: deleteUrl,
        //                 method: 'DELETE',
        //                 success: function (response) {
        //                     Swal.fire(
        //                         'Deleted!',
        //                         'Purchase Order has been deleted.',
        //                         'success'
        //                     ).then(() => {
        //                         location.reload();
        //                     });
        //                 },
        //                 error: function (xhr, status, error) {
        //                     Swal.fire(
        //                         'Error!',
        //                         'There was a problem deleting the user.',
        //                         'error'
        //                     );
        //                 }
        //             });
        //         }
        //     });
        // });

    });
    
    
        // Function to fetch filtered data
				    function fetchFilteredData() {
                      var supplierId = $('.select[name="supplier_id"]').val();
                      var startDate = $('input[name="start_date"]').val();
                      var endDate = $('input[name="end_date"]').val();

						$.ajax({
							url: "{{ route('purchase_orders') }}",
							method: "GET",
							data: {
								supplier_id: supplierId,
								start_date: startDate,
								end_date: endDate
							},
							success: function (response) {
								var tbody = $(".product-list tbody");
								tbody.empty(); // Clear existing data

								if (response.inwards.length > 0) {
									$.each(response.purchase_orders, function (index, purchase_order) {
										

										var row = `<tr>
											<td class="action-table-data">
												<div class="edit-delete-action">
													
													<a class="me-2 p-2" href="view-purchase-orders/${purchase_order.id}" title="View">
														<i data-feather="eye" class="feather-eye"></i>
													</a>
													<a class="me-2 p-2" href="edit-purchase-order/${purchase_order.id}">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" href="javascript:void(0);" data-id="${purchase_order.id}">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
											</td>
											<td>${purchase_order.po_number}</td>
											<td>${purchase_order.company_name}</td>
											<td>${purchase_order.supplier_name}</td>
											<td>${purchase_order.grand_total}</td>
											
										</tr>`;

										tbody.append(row);
									});

									// Reinitialize Feather icons after AJAX
									feather.replace();
								} else {
									tbody.append('<tr><td colspan="7" class="text-center">No records found.</td></tr>');
								}
							}
						});
                    }

					$('.select[name="supplier_id"], input[name="start_date"], input[name="end_date"]').on('change', function () {
						fetchFilteredData();
					});
			
			
			$(document).on('click', '.preview-mail-btn', function (e) {
				e.preventDefault(); // prevent default link behavior
				let preview = $(this).data('preview');
				let url = $(this).attr('href');

				if (preview == 0) {
					// Allow redirection
					window.location.href = url;
				} else {
					// Show SweetAlert
					Swal.fire({
						icon: 'warning',
						title: 'Unable to preview',
						text: 'Mail already sent to party!',
						confirmButtonColor: '#3085d6',
						confirmButtonText: 'OK'
					});
				}
			});


			$(document).ready(function () {
    $(document).on('click', '.delete-action', function (e) {
        e.preventDefault();

        var userId = $(this).data('id');
        var inwardStatus = $(this).data('inward-status'); // fetch inward status
        var deleteUrl = "{{ url('delete-purchase-order') }}/" + userId;

        if (inwardStatus == 0) {
            Swal.fire({
                title: 'Are you sure?',
                text: "Delete Purchase Order!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: deleteUrl,
                        method: 'DELETE',
                        success: function (response) {
                            Swal.fire(
                                'Deleted!',
                                'Purchase Order has been deleted.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr, status, error) {
                            Swal.fire(
                                'Error!',
                                'There was a problem deleting the purchase order.',
                                'error'
                            );
                        }
                    });
                }
            });
        } else {
            Swal.fire({
                icon: 'info',
                title: 'Action Not Allowed',
                text: 'This purchase order cannot be deleted because the inward is already processed.',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'OK'
            });
        }
    });
});

$(document).on('click', '.edit-link', function (e) {
    var status = $(this).data('status');

    if (status != 0) {
        e.preventDefault(); // stop navigation

        Swal.fire({
            icon: 'warning',
            title: 'Not Allowed',
            text: 'You are not able to edit PO is inwarderd.',
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'OK'
        });
    }
});


</script>
		
@include('layouts.footer')
