@include('layouts.header')
			<!-- /Header -->
			
			@include('layouts.sidebar')

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Staff List</h4>
								<h6>Manage your staff</h6>
							</div>
						</div>
						<!--<ul class="table-top-head">
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i data-feather="printer" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh"><i data-feather="rotate-ccw" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
							</li>
						</ul>-->
						<div class="page-btn">
							<a href="{{ route('add_staff')}}" class="btn btn-added" ><i data-feather="plus-circle" class="me-2"></i>Add New Staff</a>
						</div>
					</div>
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="assets/img/icons/closes.svg" alt="img"></span>
										</a>
										
									</div>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div>-->
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="user" class="info-img"></i>
												<select class="select">
													<option>Choose Staff Name</option>
													<option>Benjamin</option>
													<option>Ellen</option>
													<option>Freda</option>
													<option>Kaitlin</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="globe" class="info-img"></i>
												<select class="select">
													<option>Choose Country</option>
													<option>India</option>
													<option>USA</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12 ms-auto">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table  datanew">
									<thead>
										<tr>
										<th class="no-sort">Action</th>
										<th>Staff ID</th>
											<th>Staff  Name</th>
											
											<th>Payment</th>
											<th>Payment Date</th>
											<th>Phone</th>
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
										@foreach($staff as $row)
										<?php $user=DB::table('users')->where('id',$row->user_id)->first();?>
										<tr>									
											<td class="action-table-data">
												<div class="edit-delete-action">
													
													<a class="me-2 p-2" href="{{ url('edit-staff/'.$row->id)}}" >
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" data-id="{{ $row->id}}" href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
												
											</td>
											<td>{{ $row->staff_id}}</td>
											<td>{{ $user->full_name}}</td>
											<td>{{ $row->payment}}</td>
											<td>{{ date('d-m-Y', strtotime($row->payment_date))}}</td>
											<td>{{ $row->phone1}} </td>
											<td>@if($row->status==1)<a href="{{ url('inactive_staff/'.$row->id)}}"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="{{ url('active_staff/'.$row->id)}}"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
											
										</tr>	
                                        @endforeach
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
			$(document).ready(function () {

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

				$(document).on('click', '.delete-action', function (e) {
					
					e.preventDefault();
					var userId = $(this).data('id');
					
					var deleteUrl = "{{ url('delete-staff') }}/" + userId;

					Swal.fire({
						title: 'Are you sure?',
						text: "You won't be able to revert this!",
						icon: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Yes, delete it!'
					}).then((result) => {
						if (result.isConfirmed) {
							$.ajax({

								
								url: deleteUrl,
								method: 'DELETE',
								success: function (response) {
									Swal.fire(
										'Deleted!',
										'Stadd has been deleted.',
										'success'
									).then(() => {
										location.reload(); 
									});
								},
								error: function (xhr, status, error) {
									Swal.fire(
										'Error!',
										'There was a problem deleting the user.',
										'error'
									);
								}
							});
						}
					});
				});

			});
		</script>	
		
		@include('layouts.footer')
