@include('layouts.header')			
		@include('layouts.sidebar')
			
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Stock Report</h4>
								<h6>Manage your stock</h6>
							</div>
						</div>
						
						
						{{-- <div class="page-btn import">
							<a href="#" class="btn btn-added color" data-bs-toggle="modal" data-bs-target="#view-notes"><i
								data-feather="download" class="me-2"></i>Import Product</a>
						</div> --}}
					</div>
					
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">

							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="javascript:void(0);" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
							</div>

							@if(session()->has('success'))
							<div class="alert alert-success">
								{{ session()->get('success') }}
							</div>
							@endif
							@if(session()->has('error'))
							<div class="alert alert-danger">
								{{ session()->get('error') }}
							</div>
						    @endif
						
							<!-- /Filter -->
							<div class="table-responsive product-list">
								<table class="table datanew">
									<thead>
										<tr>
											
											<th>Varient</th>
											<th>No of rolls</th>
											<th>Quantity/Sqft</th>
											<th>Rate</th>
											<th>Unit</th>
                                            <th>Available Rolls</th>
											
										</tr>
									</thead>
									<tbody>
										
										@foreach($inventory as $row)
										<tr>
											<td><a href="javascript:void(0);" class="expand-row" data-id="{{ $row->id }}">{{ $row->varient_code}}-{{ $row->varient_name}}</a></td>
											<td>{{ $row->no_of_rolls}}</td>
											<td>{{ $row->no_of_rolls}}</td>
											<td>{{ $row->basic_cost}}</td>
											<td>{{ $row->unit_name}}</td>
                                            <td>{{ $row->available_rolls}}</td>
										</tr>
                                        @endforeach
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
            $(document).on('click', '.expand-row', function () {
    const parentRow = $(this).closest('tr'); 
    const itemId = $(this).data('id'); 
    
    const isExpanded = parentRow.next().hasClass('expanded-row');

    // Remove existing expanded row if already present
    $('.expanded-row').remove();

    // If not expanded, add the expanded row
    if (!isExpanded) {
        const loadingContent = `
            <tr class="expanded-row">
                <td colspan="8">
                    <div class="nested-table">
                        <table class="table datanew table-bordered" id="roll_table">
                            <thead>
                                <tr>
                                    <th>Company</th>
                                    <th>Roll No</th>
                                    <th>Quantity</th>
                                    <th>Availability</th>
                                    <th>Inward On</th>
                                    <th>Status</th>
									
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="7" class="text-center">Loading data...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </td>
            </tr>
        `;

        // Insert loading row
        parentRow.after(loadingContent);

        
        $.ajax({
            url: `/get-rolls-data/${itemId}`, 
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                if (Array.isArray(data) && data.length > 0) {
                    const rows = data.map(item => `
                        <tr>
                            <td>${item.company_name || 'N/A'}</td>
                            <td>${item.id || 'N/A'}</td>
                            <td>${item.quantity || 'N/A'}</td>
                            <td>${item.availability || 'N/A'}</td>
                            <td>${item.inward_on || 'N/A'}</td>
                            <td>${item.remark || 'N/A'}</td>
							
                        </tr>
                    `).join('');

                    // Update the table body with fetched rows
                    parentRow.next().find('tbody').html(rows);
                } else {
                    // Display message if no data found
                    parentRow.next().find('tbody').html(`
                        <tr>
                            <td colspan="7" class="text-center">No data available</td>
                        </tr>
                    `);
                }
            },
            error: function () {
                // Display error message
                parentRow.next().find('tbody').html(`
                    <tr>
                        <td colspan="7" class="text-center">Error fetching data</td>
                    </tr>
                `);
            }
        });
    }
});
        </script>
		@include('layouts.footer')
