@include('layouts.header')
			<!-- /Header -->
			
			@include('layouts.sidebar')
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>User List</h4>
								<h6>Manage Your Users</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-units"><i data-feather="plus-circle" class="me-2"></i>Add New User</a>
						</div>
					</div>

					@if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('error'))
                <div class="alert alert-danger">
                    {{ session()->get('error') }}
                </div>
                @endif
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="assets/img/icons/closes.svg" alt="img"></span>
										</a>
									</div>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div>-->
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="user" class="info-img"></i>
												<select class="select">
													<option>Choose Name</option>
													<option>Lilly</option>
													<option>Benjamin</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select">
													<option>Choose Status</option>
													<option>Active</option>
													<option>Inactive</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select">
													<option>Choose Role</option>
													<option>Store Keeper</option>
													<option>Salesman</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table datanew">
									<thead>
										<tr>
											<th class="no-sort">Action</th>
											<th>Name</th>
											<th>Email</th>
											<th>Role</th>
											<th>Last Login</th>
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
									@foreach($users as $row)
										<tr>
										<td class="action-table-data">
												<div class="edit-delete-action">
													
													<a class="me-2 p-2 mb-0 action-edit" data-bs-toggle="modal" data-bs-target="#edit-units" data-id="{{$row->userid}}">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													@if($row->email != 'admin@gmail.com')
													<a class="me-2 confirm-text p-2 mb-0 delete-action" data-id="{{ $row->userid }}"  href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
													@endif
													
												</div>
											</td>
											
											<td>
												<div class="userimgname">
													
													<div>
														<a href="javascript:void(0);">{{ $row->full_name}}</a>
													</div>
													
												</div>
											</td>
											
											<td>{{ $row->email}}</td>
											<td>{{ $row->type_name}}</td>
											<td>{{ $row->last_login}}</td>
											@if($row->email == 'admin@gmail.com')
											<td>@if($row->status==1)<a href="#"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="#"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
											@else
											<td>@if($row->status==1)<a href="{{ url('inactive_user/'.$row->userid)}}"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="{{ url('active_user/'.$row->userid)}}"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
                                            @endif
											
										</tr>
									@endforeach	
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			
        </div>
		<!-- /Main Wrapper -->

		<!-- Add User -->
		<div class="modal fade" id="add-units">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add User</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="{{ route('add_user')}}" id="myForm" method="post" enctype="multipart/form-data">
									@csrf
									  <!-- Password Mismatch Message -->
									  <div id="add-user-password-message" style="color: red; display: none;">
										Passwords do not match!
									</div>
									<div class="row">
										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Full Name</label>
												<input type="text" name="name" class="form-control" required>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>User Name</label>
												<input type="text" name="username" class="form-control" required>
											</div>
										</div>
									
										
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Email</label>
												<input type="email" id="email" name="email" class="form-control"  required>
												  <small id="email-error" style="color: red; display: none;">This email is already registered!</small>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Role</label>
												<select class="select" name="role">
													<option value="">Choose</option>
													@foreach($usertype as $row)
													<option value="{{ $row->id}}">{{ $row->type_name}}</option>
													@endforeach
												</select>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Password</label>
												<div class="pass-group">
													<input type="password"  id="add-password" name="password" required>
													<span class="fa-solid fa-eye-slash toggle-password" data-target="add-password" style="cursor: pointer;position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Confirm Passworrd</label>
												<div class="pass-group">
													<input type="password" id="add-cpassword" name="cpassword"  required>
													<span class="fa-solid fa-eye-slash toggle-password" data-target="add-cpassword" style="cursor: pointer;position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></span>
												</div>
											</div>
										</div>
										<div style="display: none;">
										  <i class="fa-solid fa-eye"></i>
										  <i class="fa-solid fa-eye-slash"></i>
										</div>

										
										
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" id="submitBtn" class="btn btn-submit">Submit</button><p id="message" style="color: red;">
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add User -->

		<!-- Edit User -->
		<div class="modal fade" id="edit-units">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit User</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="{{ route('update_user')}}" method="post" enctype="multipart/form-data">
									@csrf
									  <!-- Password Mismatch Message 
									  <div id="edit-user-password-message" style="color: red; display: none;">
										Passwords do not match!
									</div>-->
									<input type="hidden" name="user_id" id="user_id">
									<div class="row">
										
										<div class="col-lg-12">
											<div class="input-blocks">
												<label>Name</label>
												<input type="text" name="name" id="name">
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>User Name</label>
												<input type="text" name="username" id="username">
											</div>
										</div>
										
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Email</label>
												<input type="email" id="edit-email" name="email">
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Role</label>
												<select class="select" name="role" id="role">
													<option value="">Choose</option>
													@foreach($usertype as $row)
													<option value="{{ $row->id}}">{{ $row->type_name}}</option>
													@endforeach
												</select>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Password</label>
												<div class="pass-group"> 
													<input type="password" name="password" id="edit-password" required>
													 <span class="fa-solid fa-eye-slash toggle-password" data-target="edit-password" style="cursor: pointer;position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></span>
												</div>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="input-blocks">
												<label>Confirm Passworrd</label>
												<div class="pass-group">
													<input type="password" name="cpassword"  id="edit-cpassword" required>
													 <span class="fa-solid fa-eye-slash toggle-password" data-target="edit-cpassword" style="cursor: pointer;position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></span>
												</div>
											</div>
										</div>
										
									</div>
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Submit</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
			$(document).ready(function () {

				$.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
				$('.action-edit').click(function (e) {
					e.preventDefault();
				 var inId = $(this).data('id'); 
				   
				 $.ajax({
						url: 'edit-user/' + inId, 
						method: 'GET',
						success: function (response) {
							console.log(response);
							if (response.avatar) {
								$('#current-avatar').attr('src', response.avatar).show(); // Show the existing image
							} else {
								$('#current-avatar').hide(); // Hide if no image
							}

							$('#user_id').val(response.user_id);
							$('#avatar').html(response.avatar);
							$('#name').val(response.name);
							$('#username').val(response.username);
							$('#role').val(response.role).change();
							$('#edit-email').val(response.email);
							$('#edit-password').val(response.password);
							$('#edit-cpassword').val(response.password);
							
							$('#edit-units').modal('show');
						},
						error: function (xhr, status, error) {
							console.error(xhr.responseText);
							
						}
					});
				});
	
	 
				    const addPassword = $('#add-password');
					const addConfirmPassword = $('#add-cpassword');
					const addPasswordMessage = $('#add-user-password-message');
					const addUserForm = $('#add-units form');

					function validateAddPasswords() {
						if (addPassword.val() !== addConfirmPassword.val()) {
							addPasswordMessage.show();
							return false;
						} else {
							addPasswordMessage.hide();
							return true;
						}
					}

					addPassword.add(addConfirmPassword).on('input', validateAddPasswords);

					addUserForm.on('submit', function (event) {
						if (!validateAddPasswords()) {
							event.preventDefault(); // Prevent form submission if passwords don't match
						}
					});

					// Edit User Form Validation
					const editPassword = $('#edit-password');
					const editConfirmPassword = $('#edit-cpassword');
					const editPasswordMessage = $('#edit-user-password-message');
					const editUserForm = $('#edit-units form');

					function validateEditPasswords() {
						if (editPassword.val() !== editConfirmPassword.val()) {
							editPasswordMessage.show();
							return false;
						} else {
							editPasswordMessage.hide();
							return true;
						}
					}

					editPassword.add(editConfirmPassword).on('input', validateEditPasswords);

					editUserForm.on('submit', function (event) {
						if (!validateEditPasswords()) {
							event.preventDefault(); // Prevent form submission if passwords don't match
						}
					});

			$(document).on('click', '.delete-action', function (e) {
				e.preventDefault();
				var userId = $(this).data('id');
				var deleteUrl = "{{ url('delete-user') }}/" + userId;

				Swal.fire({
					title: 'Are you sure?',
					text: "You won't be able to revert this!",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: 'Yes, delete it!'
				}).then((result) => {
					if (result.isConfirmed) {
						$.ajax({

							
							url: deleteUrl,
							method: 'DELETE',
							success: function (response) {
								Swal.fire(
									'Deleted!',
									'User has been deleted.',
									'success'
								).then(() => {
									location.reload(); // Refresh the page to reflect the changes
								});
							},
							error: function (xhr, status, error) {
								Swal.fire(
									'Error!',
									'There was a problem deleting the user.',
									'error'
								);
							}
						});
					}
				});
			});
			
			
					$('.toggle-password').on('click', function () {
        const inputSelector = $(this).data('toggle');
        const input = $(inputSelector);
        const isPassword = input.attr('type') === 'password';

        input.attr('type', isPassword ? 'text' : 'password');
        $(this)
            .toggleClass('fa-eye')
            .toggleClass('fa-eye-slash');
    });

				$("#email").on("keyup blur", function (e) { 
        let email = $(this).val();
      
            $.ajax({
                url: "{{ route('check_email_exists') }}",
                type: "POST",
                data: {
                    email: email,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#email-error").show(); 
                        $("#email").addClass("error-field"); 
                        $("#email").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This user is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#email-error").hide(); 
                        $("#email").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });

    
     $("#email").on("keydown", function (e) {
        if (e.key === "Tab" && $("#email-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
	
		});

			document.addEventListener('DOMContentLoaded', function() {

				const password = document.querySelector('input[name="password"]');
        const confirmPassword = document.querySelector('input[name="cpassword"]');
        const form = document.querySelector('form');
        
        const passwordMismatchMessage = document.createElement('div');
        passwordMismatchMessage.style.color = 'red';
        passwordMismatchMessage.style.display = 'none';
        passwordMismatchMessage.textContent = 'Passwords do not match!';
        
        form.appendChild(passwordMismatchMessage);
        
        function validatePasswords() {
            if (password.value !== confirmPassword.value) {
                passwordMismatchMessage.style.display = 'block';
                return false;
            } else {
                passwordMismatchMessage.style.display = 'none';
                return true;
            }
        }
        
        password.addEventListener('input', validatePasswords);
        confirmPassword.addEventListener('input', validatePasswords);


		
				const avatarUpload = document.getElementById('avatar-upload');
				const profilePicPreview = document.getElementById('profile-pic-preview');
				const profilePic = document.getElementById('profile-pic');

				/*avatarUpload.addEventListener('change', function() {
					const file = this.files[0];
					if (file) {
						const reader = new FileReader();

						reader.onload = function(e) {
							profilePicPreview.src = e.target.result;
							profilePicPreview.style.display = 'block';
							profilePic.querySelector('span').style.display = 'none'; // Hide the placeholder
						};

						reader.readAsDataURL(file);
					}
				});*/
			});
			
			document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });

	</script>

	<!-- Added code by sachin darkunde for hide and show password -->
	<script>
	  document.addEventListener('DOMContentLoaded', function () {
	    document.querySelectorAll('.toggle-password').forEach(function (toggle) {
	      toggle.addEventListener('click', function () {
	        const targetId = this.getAttribute('data-target');
	        const input = document.getElementById(targetId);

	        if (input) {
	          const isPassword = input.type === 'password';
	          input.type = isPassword ? 'text' : 'password';

	          // Fix class toggle logic
	          this.classList.remove(isPassword ? 'fa-eye-slash' : 'fa-eye');
	          this.classList.add(isPassword ? 'fa-eye' : 'fa-eye-slash');
	        }
	      });
	    });
	  });
	</script>









		@include('layouts.footer')
