@include('layouts.header')
<meta name="csrf-token" content="{{ csrf_token() }}">

<style>
.select2-container--default .select2-selection--single {
    
    border: 1px solid #e9edf6 !important;
    height:40px !important; 
   
}
.select2-container .select2-selection--single .select2-selection__arrow {
    height: 100% !important;
    position: absolute !important;
    top: 0 !important;
    right: 0 !important;
    width: 20px !important; 
    background-color: transparent !important;
    border-left: 1px solid #aaa !important; 
}

.select2-container .select2-selection__arrow b {
  
    border-width: 5px 5px 0 5px !important; 
    border-style: solid !important;
    display: inline-block !important;
    margin-top: 5px !important;
    vertical-align: middle !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow 
{
	display: none !important;
}
.select2-selection__clear{
    display: none !important;
    /* color:#aaa; */
}

</style>


		<!-- /Header -->
		@include('layouts.sidebar')

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>View Inward</h4>
						
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="{{ route('inwards')}}" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back To Inwards</a>
							</div>
						</li>
						<!-- <li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li> -->
					</ul>
					
				</div>
				<!-- /add -->
				@if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
				@endif
				@if(session()->has('error'))
					<div class="alert alert-danger">
						{{ session()->get('error') }}
					</div>
				@endif



				<div class="card table-list-card">
				    <div class="card-body">

				        <!-- Header Section -->
				        <header style="border-bottom: 3px solid black; padding: 5px;" class="p-4">
				            <div>
				                <h6 style="font-weight: bold; float:right;">Ph nos: 9665065522 /25 /34</h6>
				            </div>
				            <br><br>
				            <div>
				                <h1 style="font-weight: bold;text-align: center;">{{ $inward->company_name }}</h1>
				                <h6 style="text-align: center;">Inward Inventory Report</h6>
				            </div>
				        </header>

				        <!-- Inward Metadata Section -->
						<div class="p-4" style="border-bottom: 3px solid black;">
						    <!-- <h5 style="font-weight: bold; margin-bottom: 15px;">Inward Inventory Summary</h5> -->
						    
						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Inward No:</strong> {{ $inward->inward_no }}</div>
						        <div class="col-md-6 text-end"><strong>Date:</strong> {{ \Carbon\Carbon::parse($inward->created_at)->format('d-m-Y') }}</div>
						    </div>

                            
						    
						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Warehouse:</strong> {{ $inward->warehouse_name }}</div>
						        <div class="col-md-6 text-end">
                                        <strong>Effective Date:</strong>
                                        @if (!empty($inward->effective_date) && strtotime($inward->effective_date))
                                            {{ \Carbon\Carbon::parse($inward->effective_date)->format('d-m-Y') }}
                                        @else
                                            N/A
                                        @endif
                                    </div>

						    </div>
						    
						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Sub Category : </strong>{{ $inward->sub_category_name ?? '-' }}</div>
						        <div class="col-md-6 text-end"><strong>Brand :</strong> {{ $inward->brand_name ?? '-' }}</div>
						    </div>
						    
						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Category:</strong> {{ $inward->category_name }}</div>
						        <div class="col-md-6 text-end"><strong>Unit:</strong> {{ $inward->unit_name }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>HSN Code:</strong> {{ $inward->hsn_code }}</div>
						        <div class="col-md-6 text-end"><strong>PO Number:</strong> {{ $inward->po_number }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Total Quantity:</strong> {{ $inward->quantity }} {{ $inward->unit_name }}</div>
						        <div class="col-md-6 text-end"><strong>Available Rolls:</strong> {{ $inward_available }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Quantity on Hand:</strong> {{ $inward->qunatity_on_hand }}</div>
						        <div class="col-md-6 text-end"><strong>Total Stock:</strong> {{ $inward_stock }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Basic Cost:</strong> ₹{{ number_format($inward->basic_cost, 2) }}</div>
						        <div class="col-md-6 text-end"><strong>Purchase Cost:</strong> ₹{{ number_format($inward->purchase_cost, 2) }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Retail Margin:</strong> {{ $inward->retail_profit_margin }}%</div>
						        <div class="col-md-6 text-end"><strong>Retail Price:</strong> ₹{{ number_format($inward->retail_price, 2) }}</div>
						    </div>

						    <div class="row mb-2">
						        <div class="col-md-6"><strong>Storage Place(Warehouse):</strong> {{ $inward->warehouse_name }}</div>
						        
						    </div>
						</div>


				        <!-- Product Summary Table -->
				        <div style="margin-top: 40px;">
				            <h5 style="font-weight: bold;">Product Summary</h5>
				            <table class="table table-bordered" style="width:100%; border-collapse: collapse;">
				                <thead>
				                    <tr>
				                        <th>No</th>
				                        <th>Product name</th>
				                        <th>Design/Variant No</th>
				                        <th>No Of Rolls</th>
				                        <th>Quantity Per Roll</th>
				                        <th>Rate per Unit</th>
				                        <th>UOM</th>
				                        <th>%GST</th>
				                        <th>Amount (₹)</th>
				                    </tr>
				                </thead>
				                <tbody>
				                    <tr>
				                        <td>1</td>
				                        <td>{{ $inward->product_name }}</td>
				                        <td>{{ $inward->varient_name }}</td>
				                        <td>{{ $inward->no_of_rolls }}</td>
				                        <td>
				                            @php
				                                $perRollQty = ($inward->no_of_rolls > 0) ? number_format($inward->quantity / $inward->no_of_rolls, 2) : '0.00';
				                            @endphp
				                            {{ $perRollQty }}
				                        </td>
				                        <td>{{ number_format($inward->purchase_cost, 2) }}</td>
				                        <td>{{ $inward->unit_name }}</td>
				                        <td>{{ $inward->gst_rate }}%</td>
				                        <td>
				                            @php
				                                $amount = $inward->quantity * $inward->purchase_cost;
				                            @endphp
				                            ₹{{ number_format($amount, 2) }}
				                        </td>
				                    </tr>
				                </tbody>
				            </table>
				        </div>

				        <!-- GST Calculations -->
				        @php
				            $gstRate = $inward->gst_rate;
				            $amount = $inward->quantity * $inward->purchase_cost;
				            $gstAmount = ($amount * $gstRate) / 100;
				            $cgst = $sgst = $igst = 0;
				            if ($gstRate > 0) {
				                $cgst = $sgst = $gstAmount / 2; // Assuming intra-state
				                // If IGST scenario, use below instead:
				                // $igst = $gstAmount;
				            }
				            $totalAmount = $amount + $cgst + $sgst + $igst;
				        @endphp

				        <div style="margin-top: 30px; width: 100%; display: flex; justify-content: flex-end;">
				            <!-- <h5 style="font-weight: bold;">GST & Total Summary</h5> -->
				            <table class="table table-bordered" style="width: 50%; border-collapse: collapse;">
				                <tbody>
				                    <tr><td><strong>Sub Total</strong></td><td>₹{{ number_format($amount, 2) }}</td></tr>
				                    @if($cgst > 0)
				                        <tr><td><strong>CGST ({{ $gstRate / 2 }}%)</strong></td><td>₹{{ number_format($cgst, 2) }}</td></tr>
				                        <tr><td><strong>SGST ({{ $gstRate / 2 }}%)</strong></td><td>₹{{ number_format($sgst, 2) }}</td></tr>
				                    @elseif($igst > 0)
				                        <tr><td><strong>IGST ({{ $gstRate }}%)</strong></td><td>₹{{ number_format($igst, 2) }}</td></tr>
				                    @endif
				                    <tr><td><strong>Grand Total</strong></td><td>₹{{ number_format($totalAmount, 2) }}</td></tr>
				                </tbody>
				            </table>
				        </div>


				        <!-- Footer -->
				        <div style="margin-top: 30px;">
				            <h6 style="font-weight: bold; float:right; padding: 10px;">For {{ $inward->company_name }}</h6>
				        </div>
				        <br><br>
				        <div>
				            <h6 style="float:right; padding: 10px;">Authorized Signature</h6>
				        </div>

				    </div>
				</div>

			</div>

			<!-- /add -->
	    </div>



	<!-- /Main Wrapper -->


   




	

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {


        function calculateGST() {
        var cutRate = parseFloat($('#cut_rate').val()) || 0;
        var gstRate = parseFloat($('#gst_rate').val()) || 0;
        var gst = cutRate * gstRate;
        $('#gst').val(gst.toFixed(2)); 
        }

       
        $('#cut_rate, #gst_rate').on('input', function() {
            calculateGST();
        });

        function calculateValue() {
        var roleRate = parseFloat($('#role_rate').val()) || 0;
        var qty = parseFloat($('#qty').val()) || 0;
        var value = roleRate * qty;
        $('#value').val(value.toFixed(2)); 
        }

       
        $('#role_rate, #qty').on('input', function() {
            calculateValue();
        });


        $('#add-product').on('show.bs.modal', function (e) {
            var selectedProductType = $('#categorySelect').val();
            $('#category').val(selectedProductType);
        });

        $('#category').on('change', function() {
            var categoryId = $(this).val();
            $('#categorySelect').val(categoryId);
        });


        $('#add-product-varient').on('show.bs.modal', function (e) {
            var selectedProductvarType = $('#productSelect').val();
            $('#pro_var_id').val(selectedProductvarType);
        });
        
        $('#pro_var_id').on('change', function() {
            var productId = $(this).val();
            $('#productSelect').val(productId);
        });

        


        

        $('#addCategoryForm').submit(function(e) {
            e.preventDefault(); 
            var formData = new FormData(this);

            $.ajax({
            url: "{{ route('store_category_ajax') }}", 
            method: 'POST',
            data: formData,
            processData: false, 
            contentType: false, 
            success: function(response) {
                if (response.success) {
                   
                    $('#add-category').modal('hide');

                   
                    $('#addCategoryForm')[0].reset();

                    
                    $('select[name="category_id"]').append('<option value="' + response.category_id + '" selected>' + response.category_name + '</option>');

                    
                } else {
                    alert('Failed to add the category!');
                }
            },
            error: function(xhr) {
                
                var errors = xhr.responseJSON.errors;
                var errorMsg = '';
                $.each(errors, function(key, value) {
                    errorMsg += value + '\n';
                });
                alert('Error: \n' + errorMsg);
            }
        });


        });

        $('#addProductForm').submit(function(e) {
        e.preventDefault(); 
        var categoryId = $('#category').val();
       
        var formData = new FormData(this);

        formData.append('category_id', categoryId);


        $.ajax({
            url: "{{ route('store_product_ajax') }}", 
            method: 'POST',
            data: formData,
            processData: false, 
            contentType: false, 
            success: function(response) {
                if (response.success) {
                   
                    $('#add-product').modal('hide');

                   
                    $('#addProductForm')[0].reset();

                    
                    $('select[name="product_id"]').append('<option value="' + response.product_id + '" selected>' + response.product_name + '</option>');

                    //alert('Product added successfully!');
                } else {
                    alert('Failed to add the product!');
                }
            },
            error: function(xhr) {
                
                var errors = xhr.responseJSON.errors;
                var errorMsg = '';
                $.each(errors, function(key, value) {
                    errorMsg += value + '\n';
                });
                alert('Error: \n' + errorMsg);
            }
        });
     });


     $('#addProductvarientForm').submit(function(e) {
        e.preventDefault(); 
       // var categoryId = $('#category').val();
       
        var formData = new FormData(this);

     //  formData.append('category_id', categoryId);


        $.ajax({
            url: "{{ route('store_product_varient_ajax') }}", 
            method: 'POST',
            data: formData,
            processData: false, 
            contentType: false, 
            success: function(response) {
                if (response.success) {
                   
                    $('#add-product-varient').modal('hide');

                   
                    $('#addProductvarientForm')[0].reset();

                    
                    $('select[name="product_varient"]').append('<option value="' + response.product_id + '" selected>' + response.product_name + '</option>');

                    alert('Product varient added successfully!');
                } else {
                    alert('Failed to add the product!');
                }
            },
            error: function(xhr) {
                
                var errors = xhr.responseJSON.errors;
                var errorMsg = '';
                $.each(errors, function(key, value) {
                    errorMsg += value + '\n';
                });
                alert('Error: \n' + errorMsg);
            }
        });
     });




    });
</script>
	

<!-- JS for vanillaSelectBox -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> 
<script>




    $(document).ready(function() {
      
        $('#po_no').on('change', function () {
    var selectedUrl = $(this).val();
    if (selectedUrl) {
        // Retrieve the values from the input fields
        var rollNo = $('#roll_no').val();
        var inwardNo = $('#inward_no').val();
        var inwardDate = $('#inward_date').val();

        // Append the parameters to the URL
        var urlWithParams = selectedUrl + 
            '?roll_no=' + encodeURIComponent(rollNo) +
            '&inward_no=' + encodeURIComponent(inwardNo) +
            '&inward_date=' + encodeURIComponent(inwardDate);

        // Redirect to the new URL
        window.location.href = urlWithParams;
    }
});


  

        $('#categorySelect').on('change', function() {
            var categoryId = $(this).val();

            if(categoryId) {
                $.ajax({
                    url: '/get-products/' + categoryId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        // $('#productSelect').empty();
                        $('#productSelect').append('<option>Select</option>');
                        $.each(data, function(key, value) {
                            $('#productSelect').append('<option value="'+ value.id +'">'+ value.product_name +'</option>');
                        });
                    }
                });
            } else {
                $('#productSelect').empty();
                $('#productSelect').append('<option>Select</option>');
            }
        });

        $('#productSelect').on('change', function() {
            var productid = $(this).val();
           
            if(productid) {
                $.ajax({
                    url: '/get-product-varient/' + productid,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#productVarient').empty();
                        // $('#productVarient').append('<option>Select</option>');
                        $.each(data, function(key, value) {
                            $('#productVarient').append('<option value="'+ value.id +'">'+ value.varient_name +'</option>');
                        });
                    }
                });
            } else {
                 $('#productVarient').empty();
                 $('#productVarient').append('<option>Select</option>');
            }
        });

        $('#company_id').on('change', function() {
            var companyId = $(this).val();
           alert(companyId);
            if(companyId) {
                $.ajax({
                    url: '/get-warehouse/' + companyId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#warehouse_id').empty();
                        $('#warehouse_id').append('<option>Select</option>');
                        $.each(data, function(key, value) {
                            $('#warehouse_id').append('<option value="'+ value.id +'">'+ value.warehouse_name +'</option>');
                        });
                    }
                });
            } else {
                $('#warehouse_id').empty();
                $('#warehouse_id').append('<option>Select</option>');
            }
        });


        $('#category').on('change', function() {
            var category_id = $(this).val();
			
            if (category_id) {
                $.ajax({
                    url: '/get-subcategories/' + category_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#subcategory').empty();
                        $('#subcategory').append('<option value="">Select Subcategory</option>');
                        $.each(data, function(key, value) {
                            $('#subcategory').append('<option value="' + value.id + '">' + value.sub_category_name + '</option>');
                        });
                    }
                });
            } else {
                $('#subcategory').empty();
                $('#subcategory').append('<option value="">Select Subcategory</option>');
            }
        });
       
        $('#company_id').select2({
        placeholder: "Select Company",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });
	 $('#categorySelect').select2({
        placeholder: "Select Product Type",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });

    $('#productSelect').select2({
        placeholder: "Select Collection",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });

    $('#unit-select').select2({
        placeholder: "Select Unit",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });

    $('#productVarient').select2({
        placeholder: "Select Design",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });

    $('#po_no').select2({
        placeholder: "Select PO ",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });
    

    $('#supplier').select2({
        placeholder: "Select Supplier",   
        allowClear: true,
		search:true,
		width:'100%',
		height:'500px'                
    });
    
    $('#categorySelect').on('change', function() {
            var category_id = $(this).val();
			
            if (category_id) {
                $.ajax({
                    url: '/get-subcategories/' + category_id,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#subcategory').empty();
                        // $('#subcategory').append('<option value="">Select Subcategory</option>');
                        $.each(data, function(key, value) {
                            $('#subcategory').append('<option value="' + value.id + '">' + value.sub_category_name + '</option>');
                        });
                    }
                });
            } else {
                $('#subcategory').empty();
                $('#subcategory').append('<option value="">Select Subcategory</option>');
            }
        });

       

        $('#qty, #no_of_rolls').on('input', function() {
            var quantity = parseFloat($('#qty').val()) || 0;  // Default to 0 if invalid input
            var noOfRolls = parseFloat($('#no_of_rolls').val()) || 0;  // Default to 0 if invalid input

            var quantityOnHand = quantity * noOfRolls;  // Multiply the values

            // Update the Quantity On Hand field
            $('#quantity_on_hand').val(quantityOnHand);
        });


        $('#quantity_on_hand, #display').on('input', function() {
            var quantityOnHand = parseFloat($('#quantity_on_hand').val()) || 0;  // Default to 0 if invalid input
            var display = parseFloat($('#display').val()) || 0;  // Default to 0 if invalid input

            var stock = quantityOnHand - display;  // Subtract display from quantity_on_hand

            // Update the Stock field
            $('#stock').val(stock);
        });


    });


   


    


</script>

@include('layouts.footer')
