@include('layouts.header')			
@include('layouts.sidebar')
    <style>
        .invoice-box {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 1000px;
            margin: auto;
            width: 100%;
        }
        .invoice-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .invoice-section-title {
            font-weight: 600;
            margin-top: 30px;
            margin-bottom: 10px;
            color: #343a40;
        }
        table th, table td {
            vertical-align: middle !important;
            line-height: 5px !important;
        }
        .text-right {
            text-align: right;
        }
        .btn-download {
            margin-top: 10px;
            text-align: right;
            background: white;
        }
        .btn-download:hover{
        	background: white;
        }

        ul.terms {
	        font-size: 12px;
	        color: #666;
	        padding-left: 0px;
	        margin-top: 10px;
	    }
    </style>
<div class="page-wrapper">
	<div class="content">
		<div class="page-header">
		    <div class="invoice-box">
		        <div class="row mb-0 align-items-center">
				    <!-- Logo on the Left -->
				    <div class="col-md-2 text-left">
				        <img src="{{ url('assets/img/logo.png')}}" alt="Company Logo" style="max-height: 35px;">
				    </div>

				    <!-- Invoice Title Centered -->
				    <div class="col-md-8 text-center">
				        <h2 class="invoice-title mb-2">INVOICE</h2>
				    </div>

				    <!-- Empty column to balance layout (optional) -->
				    <div class="col-md-2"></div>

				    @php
				        $result = $groupedData->first();
				        if ($result && $result->count()) {
				            $result = $result->first();
				        }
				    @endphp
				</div>
				<hr>


		        <div class="row mb-0">
		        	<div class="col-md-6 ">
		                <p class="mb-2"><strong>Date:</strong> {{ \Carbon\Carbon::parse($result->order_date)->format('d M, Y') }}</p>
		            </div>

		            <div class="col-md-6 text-end">
		                <p><strong>INVOICE NO :</strong> INV-{{ $result->order_id ?? '0001' }}</p>
		            </div>
		        </div>
		        <hr class="mb-0">

		        <div class="row mb-4">
		            <div class="col-md-8">
		                <h5 class="invoice-section-title">From</h5>
		                <p>
						    <strong>Kukreja Interiors</strong><br>
						    A-45, R Quarters,
						    Near Sai Chowk, Pimpri,<br>
						    Pune - 411017
						    Maharashtra, India<br>
						    Phone : <a href="tel:+919665065522">+91 96650 65522</a><br>
						    Email : <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a><br>
						    <!-- <b>GSTIN :</b> 1234567<br>
						    <b>PAN :</b> 12355655 -->
						</p>

		            </div>
		            <div class="col-md-4">
		                <h5 class="invoice-section-title">To</h5>
		                @php
						    $result = $groupedData->first();
						    if ($result && $result->count()) {
						        $result = $result->first();
						    }
						@endphp

						@if ($result)
						<p>
						    <strong>Customer Name :</strong> {{ $result->customer_name ?? 'N/A' }}<br>
						    <strong>Address :</strong> {{ $result->address ?? 'N/A' }}<br>
						    <strong>City :</strong> {{ $result->city ?? 'N/A' }}<br>
						    <strong>State :</strong> {{ $result->state ?? 'N/A' }}<br>
						    <strong>Mobile :</strong>
						    @if(!empty($result->mobile))
						        <a href="tel:{{ $result->mobile }}">{{ $result->mobile }}</a>
						    @else
						        N/A
						    @endif<br>
						    <strong>Email : </strong> {{ $result->email ?? 'N/A' }}<br> 
						</p>

						@else
						<p>No customer data available.</p>
						@endif

		            </div>
		        </div><hr class="mb-0">	

		        <h5 class="invoice-section-title">Items</h5>
				    <table class="table table-bordered">
				        <thead>
				            <tr>
				                <th>#</th>
				                <th>Item Name</th>
				                <th>HSN code</th>
				                <th>Item Variants</th>
				                <th>Quantity</th>
				                <th>Unit Price</th>
				                <th>Total</th>
				            </tr>
				        </thead>
				        <tbody>
				            @php
				                $subtotal = 0;
				                $sr_no = 0;
				            @endphp
				            @foreach($groupedData as $orderId => $orderItems)
					            @foreach($orderItems as $index => $item)
					                @php
					                	$sr_no++;
					                    $lineTotal = $item->quantity * $item->price;
					                    $subtotal += $lineTotal;
					                @endphp
					                <tr>
					                    <td>{{ $sr_no }}</td>
					                    <td>{{ $item->product_name }}</td>
					                    <td>{{ $item->hsn_code }}</td>
					                    <td>
					                        @if($item->varient_name)
					                            {{ $item->varient_name }} - {{ $item->varient_code }}
					                        @else
					                            No variants
					                        @endif
					                    </td>
					                    <td>{{ $item->quantity }}</td>
					                    <td>₹{{ number_format($item->price, 2) }}</td>
					                    <td>₹{{ number_format($lineTotal, 2) }}</td>
					                </tr>
					            @endforeach
					        @endforeach
				        </tbody>
				    </table>

				    {{-- Calculate GST and Grand Total --}}
				@php
					$gstRate = 18; // Example GST rate

					// Assuming intra-state supply: GST = CGST + SGST (each 9%)
					$cgstRate = $gstRate / 2;
					$sgstRate = $gstRate / 2;

					$cgstAmount = ($subtotal * $cgstRate) / 100;
					$sgstAmount = ($subtotal * $sgstRate) / 100;

					// Assuming IGST is not applicable (or if applicable, you can replace CGST+SGST with IGST)
					$igstRate = 0;
					$igstAmount = 0;

					$grandTotal = $subtotal + $cgstAmount + $sgstAmount + $igstAmount;
				@endphp

				{{-- Totals Section --}}
				<div class="row justify-content-end mt-3 mb-0">
					<div class="col-md-6">
						<table class="table table-bordered">
							<tr>
								<th class="fw-bold">Subtotal</th>
								<td class="text-end">₹{{ number_format($subtotal, 2) }}</td>
							</tr>

							@if($cgstAmount > 0)
							<tr>
								<th class="fw-bold">CGST ({{ $cgstRate }}%)</th>
								<td class="text-end">₹{{ number_format($cgstAmount, 2) }}</td>
							</tr>
							@endif

							@if($sgstAmount > 0)
							<tr>
								<th class="fw-bold">SGST ({{ $sgstRate }}%)</th>
								<td class="text-end">₹{{ number_format($sgstAmount, 2) }}</td>
							</tr>
							@endif

							@if($igstAmount > 0)
							<tr>
								<th class="fw-bold">IGST ({{ $igstRate }}%)</th>
								<td class="text-end">₹{{ number_format($igstAmount, 2) }}</td>
							</tr>
							@endif

							<tr>
								<th style="font-size: 15px;"><strong>Grand Total</strong></th>
								<td class="text-end"><strong>₹{{ number_format($grandTotal, 2) }}</strong></td>
							</tr>
						</table>
					</div>
				</div>

				<br>
				<hr>

				<!-- Notes & Terms -->
				<div class="row">
				    <div class="col-md-6">
				        <!-- Notes Section -->
				        <div class="invoice-section-title">Notes</div>
				        <p style="font-size: 13px;">
				            Thank you for your purchase.<br>
				            For questions about this invoice, please reach out using the contact details provided below.
				        </p>
				    </div>
				    <div class="col-md-6">
				        <!-- Terms & Conditions -->
				        <div class="invoice-section-title">Terms & Conditions</div>
				        <ul class="terms" style="font-size: 13px; padding-left:0px; margin-bottom: 0;">
				            <li>Payment due within 15 days from invoice date.</li>
				            <li>Goods once sold will not be taken back or exchanged.</li>
				            <li>All disputes are subject to Pune jurisdiction only.</li>
				        </ul>
				    </div>
				</div>

				<hr style="margin: 20px 0;">

				<!-- Footer Info & Signature -->
				<div class="row" style="margin-top: 10px;">
				    <div class="col-md-6">
				        <!-- Footer Contact Info -->
				        <div class="footer" style="font-size: 12px; color: #666;">
				            <p style="margin-bottom: 4px;">Kukreja Interiors</p>
				            <p style="margin-bottom: 4px;">A-45, R Quarters, Near Sai Chowk, Pimpri, Pune - 411017</p>
				            <p style="margin-bottom: 4px;">Email: <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a></p>
				            <p style="margin-bottom: 4px;">Phone: <a href="tel:+919665065522">+91 96650 65522</a></p>
				            <p style="margin-bottom: 4px;">GSTIN: 27ABCPK1234A1ZB | PAN: ABCPK1234A</p>
				        </div>
				    </div>

				    <div class="col-md-6" style="text-align: right;">
				        <!-- Authorized Signatory -->
				        <div class="invoice-section-title mb-0">Authorized Signatory</div>
				        <p style="margin: 40px 0 5px;">_________________________</p>
				        <p style="font-size: 13px;">Name & Designation</p>
				        <p style="font-size: 11px; color: #888;">(This is a computer-generated invoice and does not require a physical signature)</p>
				    </div>
				</div>
				<hr>
		        <div class="btn-download text-end mt-3">
			        <a href="{{ route('download-invoice', ['productId' => $result->product_id]) }}" class="btn btn-primary btn-sm">
			            <i class="fas fa-file-pdf"></i> Download PDF
			        </a>
			    </div>
		    </div>
		</div>
	</div>
</div>
@include('layouts.footer')
