@include('layouts.header')
@include('layouts.sidebar')
<meta name="csrf-token" content="{{ csrf_token() }}">
<style>
#DataTables_Table_0_filter
{
  display: none;
}

#DataTables_Table_0_info{
    display:none;
}

</style>
<div class="page-wrapper">
    <div class="content">
        <!-- Page Header -->
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4> Order Details</h4>
                </div>
            </div>
            <div class="page-btn">
                <a href="{{ route('orders')}}" class="btn btn-added"><i data-feather="arrow-left" class="me-2"></i>Back To Orders</a>
            </div>
        </div>
        <div id="message-container"></div>
      
            <div class=" d-flex justify-content-end align-items-center">
                <label for="order-status" class="me-2 mb-0">Order Status:</label>
                <select id="order-status" class="form-select w-auto">
                    <option value="Ordered" {{ $response['order_details']->status == 'Ordered' ? 'selected' : '' }}>Ordered</option>
                     <option value="Measurement" {{ $response['order_details']->status == 'Measurement' ? 'selected' : '' }}>Measurement</option>
                    <option value="Cutting Done" {{ $response['order_details']->status == 'Cutting Done' ? 'selected' : '' }}>Cutting Done</option>
                    <option value="Payment Done" {{ $response['order_details']->status == 'Payment Done' ? 'selected' : '' }}>Payment Done</option>
                    <option value="Packed" {{ $response['order_details']->status == 'Packed' ? 'selected' : '' }}>Packed</option>
                    <option value="Shipped" {{ $response['order_details']->status == 'Shipped' ? 'selected' : '' }}>Shipped</option>
                    <option value="Delivered" {{ $response['order_details']->status == 'Delivered' ? 'selected' : '' }}>Delivered</option>
                </select>
            </div>
        <br>
        

        <!-- Flash Messages -->
        @if(session()->has('success'))
            <div class="alert alert-success">{{ session()->get('success') }}</div>
        @endif
        @if(session()->has('error'))
            <div class="alert alert-danger">{{ session()->get('error') }}</div>
        @endif
        

        <!-- Purchase Order Design -->
        {{-- <div class="card table-list-card">
            <div class="card-body">
               
                <header style="border-bottom: 3px solid black; padding: 5px;">
                    <div>
                        <h6 style="font-weight: bold; float:right;">Ph nos: 9665065522 /25 /34</h6>
                    </div>
                    <br><br>
                    <div>
                        <h1 style="font-weight: bold;text-align: center;">Kukreja Interiors</h1>
                        <h6 style="text-align: center;">A-45, R Quarters, Near Sai Chowk, Pimpri Pune 411017.</h6>
                    </div>
                    <div>
                        <span style="text-align: center;font-weight: bold;"><a href="">kukreja_interiors@yahoo.com</a></span>
                        <span style="font-weight: bold; float:right;">GSTIN:27AMSPK1108K1ZU</span>
                    </div>
                </header>

               
                <div style="border-bottom: 3px solid black; padding: 5px;">
                    <div>
                        <span>Name: {{ $response['order_details']->customer_name }}</span>
                        <span class="float-end" style="margin-right: 5%;">Order No:{{ $response['order_details']->order_code}}</span>
                    </div>
                  
                    <div>
                        <span>Address: {{ $response['order_details']->address}}</span>
                        <span class="float-end" style="margin-right: 5%;">Date:{{ date('d-m-Y', strtotime($response['order_details']->order_date))}}</span>

                    </div>
                    <br>
                    
                </div>

               
                <div>
                    <table class="table table-bordered" style="width:100%; border-collapse: collapse;">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Product Name</th>
                                <th>Variant Name</th>
                                <th>Quantity</th>
                                <th>Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $i=1; @endphp
                            @foreach($response['order_items'] as $row )
                            <tr>
                                <td>{{ $i++}}</td>
                                <td>{{ $row->product_name}}</td>
                                <td>{{ $row->varient_name}}</td>
                                <td>{{ $row->quantity}}</td>
                                <td>₹ {{ $row->price}}</td>
                            </tr>
                            @endforeach
                           
                            <tr>
                                <td colspan="3" rowspan="2"></td>
                                <td  style="font-weight: bold;">Gross Total</td>
                                <td>₹ {{ $response['order_details']->grandtotal}}</td>
                            </tr>
                    
                            <tr>
                                <td colspan="3" rowspan="2">
                                </td>
                                <td >GST Amount</td>
                                <td>₹ 0.00</td>
                            </tr>
                    
                           
                            <tr>
                                <td style="font-weight: bold;">Final Amount</td>
                                <td>₹ {{ $response['order_details']->grandtotal}}</td>
                            </tr>
                        </tbody>
                    </table>
                    
                    
                </div>

               
                <div>
                    <h6 style="font-weight: bold; float:right; padding: 10px; word-spacing: 10px;">For Kukreja Interiors</h6>
                </div>
                <br><br>
                <div>
                    <h6 style="float:right; padding: 10px;">Ritesh. S. Kukreja</h6>
                </div>
            </div>
        </div> --}}

        @php 
        
        @endphp

        <div class="page-wrapper details-blk">
            <div class="content p-0">
                
                <div class="card">
                    <div class="card-body">
                       
                            <div class="invoice-box table-height" style="max-width: 1600px;width:100%;overflow: auto;padding: 0;font-size: 14px;line-height: 24px;color: #555;">
                                <div class="sales-details-items d-flex">
                                    <div class="details-item">
                                        <h6>Shipping Info</h6>
                                        <p> <b>{{ $response['order_details']->customer_name }}</b><br>
                                            <b>{{ $response['order_details']->email }}</b><br>
                                            <b>{{ $response['order_details']->phone1 }}</b>
                                            @if(!empty($response['order_details']->phone2))
                                           |<b>{{ $response['order_details']->phone2 }}</b>
                                            @endif
                                            <br>
                                            <b>{{ $response['order_details']->address }}</b>
                                        </p>
                                    </div>
                                    <div class="details-item">
                                        <h6>Company Info</h6>
                                        <p><b>Kukreja Interiors</b><br>
                                            <b>kukreja_interiors@yahoo.com</b><br>
                                            <b>9665065522 /25 /34</b><br>
                                            <b>A-45, R Quarters, Near Sai Chowk, Pimpri Pune 411017</b>
                                        </p>
                                    </div>
                                    <div class="details-item">
                                        <h6>Invoice Info</h6>
                                        <p><b>Order No: {{ $response['order_details']->order_code}}</b><br>
                                            <b>Order Date:{{ date('d M Y', strtotime($response['order_details']->order_date))}}</b><br>
                                            <b>Payment Status: <span class="badge bg-soft-info">{{ $response['order_details']->payment_status}}</span></b><br>
                                            <b>Order Status:</b> <b><span class="badge bg-warning" id="status">{{ $response['order_details']->status}}</span></b><br>
                                                                                    @if(in_array($response['order_details']->status, ['Payment Done','Packed', 'Shipped', 'Delivered']) && $response['order_details']->payment_status  == 'Paid')
    <a href="{{ url('generate-order-receipt/'.$response['order_details']->order_id) }}" class="badge bg-info">Generate Receipt</a>
@endif

                                        </p>
                                       
                                    </div>
                                    {{-- <div class="details-item">
                                        <h5><span>SL0101</span>Paid<br> Completed</h5>
                                    </div> --}}
                                </div>
                                
                                <hr>

                                <div class="sales-details-items d-flex">
                                    <div class="details-item" id="transporterdata">
                                        <h6>Transporter Info</h6>
                                        <p><b id="name">{{ $response['transporter_data']->contact_person ?? ''}}</b><br>
                                        <b id="email">{{ $response['transporter_data']->email ?? ''}}</b><br>
                                        <b id="phone1">{{ $response['transporter_data']->phone1 ?? ''}}@if(!empty($response['transporter_data']->phone2))
            |{{ $response['transporter_data']->phone2 }}
        @endif</b><br>
                                         <b id="address">{{ $response['transporter_data']->address ?? ''}}</b><br>
                                        </p>
                                    </div>
                                    <div class="details-item" id="deliverydata">
                                        <h6>Delivery Info</h6>
                                        <p><b id="dates">Date & Time:{{ date('d M Y H:i:s', strtotime($response['order_details']->updated_at)) }}
                                        </b><br>
                                            <b id="paymode">Payment Method:Cash On Delivery</b><br>
                                           
                                        </p>
                                    </div>
                                    <div class="details-item">
                                        
                                    </div>
                                    <div class="details-item">
                                        
                                    </div>
                                </div>

                                
                                <hr>
                                <h5 class="order-text">Order Summary</h5>
                                <div class="table-bordered no-pagination">
                                    <table class="table  datanew">
                                        <thead>
                                            <tr>
                                                <th>Sr.No</th>
                                                <th>Product Name</th>
                                                <th>Variant Name</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i=1; @endphp
                                            @foreach($response['order_items'] as $row )
                                            <tr>
                                                <td>{{ $i++}}</td>
                                                <td>{{ $row->product_name}}</td>
                                                <td>{{ $row->varient_name}}</td>
                                                <td>{{ $row->quantity}}</td>
                                                <td>₹ {{ $row->price}}</td>
                                            </tr>
                                         @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="row">
                                
                                <div class="row">
                                    <div class="col-lg-6 ms-auto">
                                        <div class="total-order w-100 max-widthauto m-auto mb-4">
                                            <ul>
                                             <li>
                                                    <h4> Gross Total</h4>
                                                    <h5 class="text-center" style="margin-left: 95px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                                <li>
                                                    <h4> Tax</h4>
                                                    <h5 class="text-center" style="margin-left: 95px;">₹ 0.00</h5>
                                                </li>
                                                <li>
                                                    <h4>Discount</h4>
                                                    <h5 class="text-center" style="margin-left: 95px;">₹ 0.00</h5>
                                                </li>
                                                <li>
                                                    <h4>Grand Total</h4>
                                                    <h5  class="text-center" style="margin-left: 95px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                                
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="add-installer">
    <div class="modal-dialog modal-dialog-centered modal-sm custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add Installer</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form id="myForminstaller" enctype="multipart/form-data" >
                            @csrf

                           
                           <input type="hidden" name="order_ins_id" id="order_ins_id" value="{{ $response['order_details']->order_id }}">
                            <div class="col-md-12">
                                <label class="form-label">Installer</label>
                               
                                <select name="installer_id" class="form-control" id="installer_id" required>
                                    <option value="">Select</option>
                                    @foreach($response['installer'] as $row)
                                    <option value="{{ $row->id}}">{{ $row->full_name}}</option>
                                   @endforeach
                                 
                                </select>
                            </div>
                            
                       
                        
                                
                            </div>
                            
                            <div class="modal-footer-btn" style="padding:20px;">
                                <button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-submit">Save</button>
                            </div>
                        </form>
                        <br><br>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
<div class="modal fade" id="add-transporter">
    <div class="modal-dialog modal-dialog-centered modal-sm custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Assign Transporter</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form id="add-transporter-form" enctype="multipart/form-data" >
                            @csrf

                            <input type="hidden"  name="id" id="id">
							
                            <div class="mb-3">
                                <label class="form-label">Transporter</label>
                                <select name="transporter" class="form-control" id="transporter" required>
                                    <option value="">Select</option>
                                   @foreach($response['transporters'] as $row)
                                   <option value="{{ $row->id}}">{{ $row->transporter_name}}</option>
                                   @endforeach
                                </select>
                            </div>
                            <div class="modal-footer-btn">
                                <button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-submit" id="save-status-btn">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="add-order-reciept">
    <div class="modal-dialog modal-dialog-centered modal-xl custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add order reciept</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form id="myForm" enctype="multipart/form-data" >
                            @csrf

                            <input type="hidden"  name="order_id" id="order_id" value="{{ $response['order_details']->order_id }}">
                            <input type="hidden"  name="items_ordered" id="items_ordered" value="{{ $response['orderItemscount']}}">
                           <div style="display:flex;justify-content: space-between" class="gap-3">
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer name</label>
                                <input type="text" name="customer_name" id="customer_name" required class="form-control" value="{{ $response['order_details']->customer_name }}">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer email</label>
                                <input type="email" name="customer_email" id="customer_email" class="form-control" value="{{ $response['order_details']->email }}">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer phone</label>
                                <input type="text" name="customer_phone" value="{{ $response['order_details']->mobile }}" onkeypress="return event.charCode >= 48 && event.charCode <= 57" id="customer_phone" class="form-control">
                            </div>
                        </div>
                        <div style="display:flex;justify-content: space-between" class="gap-3">
                            
                            <div class="mb-3 w-50">
                                <label class="form-label">Order Date</label>
                                <input type="date" name="order_date" id="order_date"  required value="{{ $response['order_details']->order_date }}" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Total amount</label>
                                <input type="text" name="total_amount" id="total_amount"  required value="{{ $response['order_details']->grandtotal }}"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control">
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Shipping address</label>
                                <textarea name="shipping_address" id="shipping_address"  class="form-control">{{ $response['order_details']->address }}</textarea>
                            </div>
                        </div>
                           
                        <div style="display:flex;justify-content: space-between" class="gap-3">
                           
                          
                            <div class="mb-3 w-50">
                                <label class="form-label">Payment Method</label>
                                <select name="payment_method" class="form-control" id="payment_method" required>
                                    <option value="">Select</option>
                                    <option value="Cash">Cash</option>
                                   <option value="Online">Online</option>
                                   <option value="Cheque">Cheque</option>
                                 
                                </select>
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Transaction date</label>
                                <input type="date" name="transaction_date" id="transaction_date" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Payment Status</label>
                                <select name="payment_status" class="form-control" id="pay_status" required >
                                    <option value="">Select</option>
                                    <option value="Paid">Paid</option>
                                   <option value="Pending">Pending</option>
                                 
                                </select>
                            </div>
                        </div>

                        <div class="cheque" style="display: none">
                            <div style="display:flex;justify-content: space-between" class="gap-3">
                       
                        <div class="mb-3 w-50">
                            <label class="form-label">Cheque Number</label>
                            <input type="text" name="cheque_number" id="cheque_number" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                        </div>
                      
                        </div>
                        
                    </div>

                            <div class="online" style="display: none">
                                <div style="display:flex;justify-content: space-between" class="gap-3">
                            <div class="mb-3 w-50">
                                <label class="form-label">Bank Name</label>
                                <input type="text" name="bank_name" id="bank_name" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Bank Ac Number</label>
                                <input type="text" name="account_number" id="account_number" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                            </div>
                           <div class="mb-3 w-50">
                                <label class="form-label">Transaction Id</label>
                                <input type="text" name="reference_id" id="reference_id" class="form-control">
                            </div>
                            </div>
                           
                        </div>

                        <div style="display:flex;justify-content: space-between" class="gap-3">
                                   
                    
                            <div class="mb-3 w-50">
                                <label class="form-label">Receipt Type</label>
                                <select name="receipt_type" class="form-control" id="receipt_type" required>
                                    <option value="">Select</option>
                                    <option value="Order Bills">Order Bills</option>
                                   <option value="Refund">Refund</option>
                                  
                                 
                                </select>
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Remark</label>
                                <input type="text" name="remark" id="remark" class="form-control">
                            </div>
                         
                        </div>
                        <hr>
                        <h5 class="order-text">Order Summary</h5>
                                <div class="table-bordered no-pagination">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Sr.No</th>
                                                <th>Product Name</th>
                                                <th>Variant Name</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i=1; @endphp
                                            @foreach($response['order_items'] as $row )
                                            <tr>
                                                <td>{{ $i++}}</td>
                                                <td>{{ $row->product_name}}</td>
                                                <td>{{ $row->varient_name}}</td>
                                                <td>{{ $row->quantity}}</td>
                                                <td>₹ {{ $row->price}}</td>
                                            </tr>
                                         @endforeach
                                        </tbody>
                                    </table>
                                    
                                </div>
                            </div>
                            
                            
                                
                                <div class="row">
                                    <div class="col-lg-6 ms-auto">
                                        <div class="total-order w-100 max-widthauto m-auto mb-4">
                                            <ul>
                                             <li>
                                                    <h4> Gross Total</h4>
                                                    <h5 class="text-center" style="margin-left: -22px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                               
                                                <li>
                                                    <h4>Grand Total</h4>
                                                    <h5  class="text-center" style="margin-left: -22px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                                
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            

                          

                            <div class="modal-footer-btn" style="padding:20px;">
                                <button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-submit" id="save-reciept-btn">Save</button>
                            </div>
                        </form>
                        <br><br>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <div class="modal fade" id="update-order-reciept">
    <div class="modal-dialog modal-dialog-centered modal-xl custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Update order reciept</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form  enctype="multipart/form-data" >
                            @csrf

                            <input type="hidden"  name="order_id" id="up_order_id" >
                          
                           
                           <div style="display:flex;justify-content: space-between" class="gap-3">
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer name</label>
                                <input type="text" name="customer_name" id="up_customer_name" required class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer email</label>
                                <input type="email" name="customer_email" id="up_customer_email" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Customer phone</label>
                                <input type="text" name="customer_phone"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" id="up_customer_phone" class="form-control">
                            </div>
                        </div>
                        <div style="display:flex;justify-content: space-between" class="gap-3">
                            
                            <div class="mb-3 w-50">
                                <label class="form-label">Order Date</label>
                                <input type="date" name="order_date" id="up_order_date"  required  class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Total amount</label>
                                <input type="text" name="total_amount" id="up_total_amount"  required   onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control">
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Shipping address</label>
                                <textarea name="shipping_address" id="up_shipping_address"  class="form-control"></textarea>
                            </div>
                        </div>
                           
                        <div style="display:flex;justify-content: space-between" class="gap-3">
                           
                          
                            <div class="mb-3 w-50">
                                <label class="form-label">Payment Method</label>
                                <select name="payment_method" class="form-control" id="up_payment_method" required>
                                    <option value="">Select</option>
                                    <option value="Cash">Cash</option>
                                   <option value="Online">Online</option>
                                   <option value="Cheque">Cheque</option>
                                 
                                </select>
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Transaction date</label>
                                <input type="date" name="transaction_date" id="up_transaction_date" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Payment Status</label>
                                <select name="payment_status" class="form-control" id="up_pay_status" required >
                                    <option value="">Select</option>
                                    <option value="Paid">Paid</option>
                                   <option value="Pending">Pending</option>
                                 
                                </select>
                            </div>
                        </div>

                        <div class="cheque" style="display: none">
                            <div style="display:flex;justify-content: space-between" class="gap-3">
                       
                        <div class="mb-3 w-50">
                            <label class="form-label">Cheque Number</label>
                            <input type="text" name="cheque_number" id="up_cheque_number" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                        </div>
                      
                        </div>
                        
                    </div>

                            <div class="online" style="display: none">
                                <div style="display:flex;justify-content: space-between" class="gap-3">
                            <div class="mb-3 w-50">
                                <label class="form-label">Bank Name</label>
                                <input type="text" name="bank_name" id="up_bank_name" class="form-control">
                            </div>
                            <div class="mb-3 w-50">
                                <label class="form-label">Bank Ac Number</label>
                                <input type="text" name="account_number" id="up_account_number" class="form-control" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                            </div>
                           <div class="mb-3 w-50">
                                <label class="form-label">Transaction Id</label>
                                <input type="text" name="reference_id" id="up_reference_id" class="form-control">
                            </div>
                            </div>
                           
                        </div>

                        <div style="display:flex;justify-content: space-between" class="gap-3">
                                   
                    
                            <div class="mb-3 w-50">
                                <label class="form-label">Receipt Type</label>
                                <select name="receipt_type" class="form-control" id="up_receipt_type" required>
                                    <option value="">Select</option>
                                    <option value="Order Bills">Order Bills</option>
                                   <option value="Refund">Refund</option>
                                  
                                 
                                </select>
                            </div>
                             <div class="mb-3 w-50">
                                <label class="form-label">Remark</label>
                                <input type="text" name="remark" id="up_remark" class="form-control">
                            </div>
                         
                        </div>

                        <hr>
                        <h5 class="order-text">Order Summary</h5>
                                <div class="table-bordered no-pagination">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Sr.No</th>
                                                <th>Product Name</th>
                                                <th>Variant Name</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i=1; @endphp
                                            @foreach($response['order_items'] as $row )
                                            <tr>
                                                <td>{{ $i++}}</td>
                                                <td>{{ $row->product_name}}</td>
                                                <td>{{ $row->varient_name}}</td>
                                                <td>{{ $row->quantity}}</td>
                                                <td>₹ {{ $row->price}}</td>
                                            </tr>
                                         @endforeach
                                        </tbody>
                                    </table>
                                    
                                </div>
                            </div>
                            
                            
                                
                                <div class="row">
                                    <div class="col-lg-6 ms-auto">
                                        <div class="total-order w-100 max-widthauto m-auto mb-4">
                                            <ul>
                                             <li>
                                                    <h4> Gross Total</h4>
                                                    <h5 class="text-center" style="margin-left: -22px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                               
                                                <li>
                                                    <h4>Grand Total</h4>
                                                    <h5  class="text-center" style="margin-left: -22px;">₹ {{ $response['order_details']->grandtotal}}</h5>
                                                </li>
                                                
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            

                          

                            <div class="modal-footer-btn" style="padding:20px;">
                                <button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-submit">Update</button>
                            </div>
                        </form>
                        <br><br>
                    </div>
                </div>
            </div>
        </div>
    </div>
    


@include('layouts.footer')

<script>

var mystatus='<?php echo $response['order_details']->status;?>';
 
 if (mystatus === 'Shipped') {
    $('#transporterdata').show();
    $('#deliverydata').hide();
} else if (mystatus === 'Delivered') {
    $('#transporterdata').show();
    $('#deliverydata').show();
} else if (mystatus === 'Ordered' || mystatus === 'Packed' || mystatus === 'Measurement' || mystatus === 'Payment Done' || mystatus === 'Cutting Done' ) {
    $('#transporterdata').hide();
    $('#deliverydata').hide();
}  
    
    
   document.getElementById('order-status').addEventListener('change', function () {
    let status = this.value;
    
    if(status == 'Measurement'){
        $('#add-installer').modal('show');
        return;
    }
    
     if(status == 'Payment Done'){

        $('#add-order-reciept').modal('show');
       return;
      }
      
    
    //alert(status);
   
    
    /*if(status == 'Shipped'){
        $('#add-transporter').modal('show');
        const url = window.location.href;
        const id = url.split('/').pop();
        //alert(id);
        $('#id').val(id);
    }else{*/
       // $('#add-transporter').modal('hide');
       // alert(1);
    
    
     //exit();
    let orderId = "{{ $response['order_details']->order_id }}";

    // Make an AJAX request to update the status
    fetch("{{ route('order.changeStatus') }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ id: orderId, status: status })
    })
    .then(response => response.json())
    .then(data => {
        const messageContainer = document.getElementById('message-container');
        if (data.success) {
            messageContainer.innerHTML = `
                <div class="alert alert-success">${data.message}</div>
            `;
            updateDropdown(status); // Update the dropdown based on the new status
        } else {
            messageContainer.innerHTML = `
                <div class="alert alert-danger">${data.message}</div>
            `;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while updating the status.');
    });
   // }
});




// Function to update the dropdown options
function updateDropdown(currentStatus) {
    const statusDropdown = document.getElementById('order-status');
    const options = statusDropdown.options;

    for (let i = 0; i < options.length; i++) {
        options[i].disabled = false; 
    }

    // Disable options based on the current status
    if (currentStatus === 'Packed') {
        options[0].disabled = true; 
    } else if (currentStatus === 'Shipped') {
        options[0].disabled = true; 
        options[1].disabled = true; 
    } else if (currentStatus === 'Delivered') {
        options[0].disabled = true; 
        options[1].disabled = true; 
        options[2].disabled = true; 
    }
}

// Initialize the dropdown on page load
document.addEventListener('DOMContentLoaded', function () {
    updateDropdown("{{ $response['order_details']->status }}");
});


document.addEventListener("DOMContentLoaded", function () {
    let orderStatus = document.getElementById("order-status");
    let selectedValue = orderStatus.value;
    
    let options = Array.from(orderStatus.options);
    let disable = true;

    options.forEach((option) => {
        if (option.value === selectedValue) {
            disable = false; // Enable options from the selected value onward
        }
        option.disabled = disable;
    });
});

/*$('#add-transporter-form').on('submit', function (event) {
    event.preventDefault(); 
    const id = $('#id').val();
    const transporter = $('#transporter').val();
    $.ajax({
        url: '/assign-transporter',
        method: 'POST',
        data: {
            id: id,
            transporter: transporter,
            _token: $('meta[name="csrf-token"]').attr('content')

        },
        success: function (response) {
          
            // Check if response is successful
            if (response && response.success) {
                $('#add-transporter').modal('hide');
                $('#status').text(response.status);
                $('#name').text(response.transporter_data.name);
                $('#email').text(response.transporter_data.email);
                $('#phone1').text(response.transporter_data.phone1);
                $('#address').text(response.transporter_data.address);
                
                $('#transporterdata').show();
            } else {
                alert('Error updating the status');
            }
        },
        error: function (xhr, status, error) {
          
                alert('An error occurred while updating the status.');
            
        }
    });
});*/

$(document).on('submit', '#myForminstaller', function(e) {
    e.preventDefault(); // Prevent default form submission

    let formData = new FormData(this);

    $.ajax({
        url: "/update-order-installer", // Ensure the route is correct
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") // CSRF Token
        },
        success: function(response) {
            if (response.success) {
                alert(response.message);
                location.reload(); // Reload page after success
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function(xhr, status, error) {
            console.log(xhr.responseText); // Log error response in console

            let errorMessage = "Something went wrong!";

            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }

            alert("Error: " + errorMessage);
        }
    });
});


$('#add-order-reciept').on('submit', function (event) {
    event.preventDefault(); 

    const order_id         = $('#order_id').val();
    const items_ordered    = $('#items_ordered').val();
    const customer_name    = $('#customer_name').val();
    const customer_email   = $('#customer_email').val();
    const customer_phone   = $('#customer_phone').val();
    const order_date       = $('#order_date').val();
    const total_amount     = $('#total_amount').val();
    const shipping_address = $('#shipping_address').val();
    const payment_method   = $('#payment_method').val();
    const pay_status       = $('#pay_status').val();
    const transaction_date = $('#transaction_date').val();
    const receipt_type    = $('#receipt_type').val();
    const remark          = $('#remark').val();
    
    
    let bank_name = '';
    let account_number = '';
   
    let reference_id = '';
    
    let cheque_number = '';

    if (payment_method === 'Online') {
       
        $('#cheque_number').val('');

        bank_name = $('#bank_name').val();
        account_number = $('#account_number').val();
      
        reference_id = $('#reference_id').val();
    } else if (payment_method === 'Cheque') {
        $('#bank_name').val('');  
        $('#account_number').val('');
        
        $('#reference_id').val('');

       
        cheque_number = $('#cheque_number').val();
    } else {
       
        $('#bank_name').val('');
        $('#account_number').val('');
       
        $('#reference_id').val('');
     
        $('#cheque_number').val('');
    }
    
  

    $.ajax({
        url: '/store_order_reciept',
        method: 'POST',
        data: {
            order_id: order_id,
            items_ordered: items_ordered,
            customer_name: customer_name,
            customer_email: customer_email,
            customer_phone: customer_phone,
            order_date: order_date,
            total_amount: total_amount,
            shipping_address: shipping_address,
            payment_method: payment_method,
            pay_status: pay_status,
            bank_name: bank_name,
            account_number: account_number,
            transaction_date: transaction_date,
            reference_id: reference_id,
            cheque_number: cheque_number,
            receipt_type : receipt_type,
            remark : remark,
            _token: $('meta[name="csrf-token"]').attr('content')

        },
        success: function (response) {
          //  console.log(response.message);
            
             //alert(response.message);

             Swal.fire({
                title: 'Success!',
                text: response.message,
                icon: 'success',
                confirmButtonText: 'OK'
            }).then(() => {
                $('#add-order-reciept').modal('hide');
                $('#invdetail').load(window.location.href + ' #invdetail'); 
            });

           
           
        },
        error: function (xhr, status, error) {
            Swal.fire({
                title: 'Error!',
                text: 'An error occurred while updating the status.',
                icon: 'error',
                confirmButtonText: 'OK'
            });
               
            
        }
    });
});


document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("save-reciept-btn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
});

function updatePaymentStatus(orderId) {
    //alert(orderId);
    $.ajax({
        url: "/get-order-details", 
        type: "GET",
        data: { order_id: orderId },
        success: function(response) {
            if (response.success) {
                let data = response.data;
                console.log(data.order_receipt.receipt_type)
                // Populate modal fields
                $('#up_order_id').val(data.order_receipt.order_id);
                 $('#up_remark').val(data.order_receipt.remark);
                $('#up_customer_name').val(data.order_receipt.customer_name);
                $('#up_customer_email').val(data.order_receipt.customer_email);
                $('#up_customer_phone').val(data.order_receipt.customer_phone);
                $('#up_order_date').val(data.order_receipt.order_date);
                $('#up_total_amount').val(data.order_receipt.total_amount);
                $('#up_shipping_address').val(data.order_receipt.shipping_address);
                $('#up_payment_method').val(data.order_transaction.payment_mode);
                $('#up_pay_status').val(data.order_transaction.payment_status);
                $('#up_transaction_date').val(data.order_transaction.transaction_date);
                $('#up_receipt_type').val(data.order_receipt.receipt_type);
                
                // Handle additional fields for online & cheque payments
                if (data.order_transaction.payment_method === "Cheque") {
                    $('.cheque').show();
                    $('#up_cheque_number').val(data.order_transaction.cheque_number);
                } else {
                    $('.cheque').hide();
                }

                if (data.order_transaction.payment_method === "Online") {
                    $('.online').show();
                    $('#up_bank_name').val(data.order_transaction.bank_name);
                    $('#up_account_number').val(data.order_transaction.account_number);
                    $('#up_reference_id').val(data.order_transaction.reference_id);
                } else {
                    $('.online').hide();
                }

                // Show the modal
                $('#update-order-reciept').modal('show');
            } else {
                alert("Failed to fetch order details");
            }
        },
        error: function(xhr) {
            console.log(xhr.responseText);
            alert("Error fetching order details");
        }
    });
}


$('#update-order-reciept').on('submit', function (event) {
    event.preventDefault(); 

    const order_id         = $('#up_order_id').val();
   
    const customer_name    = $('#up_customer_name').val();
    const customer_email   = $('#up_customer_email').val();
    const customer_phone   = $('#up_customer_phone').val();
    const order_date       = $('#up_order_date').val();
    const total_amount     = $('#up_total_amount').val();
    const shipping_address = $('#up_shipping_address').val();
    const payment_method   = $('#up_payment_method').val();
    const pay_status       = $('#up_pay_status').val();
    const transaction_date = $('#up_transaction_date').val();
    const receipt_type    = $('#up_receipt_type').val();
    const remark          = $('#up_remark').val();
    
    
    
    let bank_name = '';
    let account_number = '';
   
    let reference_id = '';
    
    let cheque_number = '';

    if (payment_method === 'Online') {
       
        $('#up_cheque_number').val('');

        bank_name = $('#up_bank_name').val();
        account_number = $('#up_account_number').val();
      
        reference_id = $('#up_reference_id').val();
    } else if (payment_method === 'Cheque') {
        $('#up_bank_name').val('');  
        $('#up_account_number').val('');
        
        $('#up_reference_id').val('');

       
        cheque_number = $('#up_cheque_number').val();
    } else {
       
        $('#up_bank_name').val('');
        $('#up_account_number').val('');
       
        $('#up_reference_id').val('');
     
        $('#up_cheque_number').val('');
    }
    
  

    $.ajax({
        url: '/update_order_reciept',
        method: 'POST',
        data: {
             order_id : order_id,
            customer_name: customer_name,
            customer_email: customer_email,
            customer_phone: customer_phone,
            order_date: order_date,
            total_amount: total_amount,
            shipping_address: shipping_address,
            payment_method: payment_method,
            pay_status: pay_status,
            bank_name: bank_name,
            account_number: account_number,
            transaction_date: transaction_date,
            reference_id: reference_id,
            cheque_number: cheque_number,
            receipt_type : receipt_type,
            remak : remark,
            _token: $('meta[name="csrf-token"]').attr('content')

        },
        success: function (response) {
          //  console.log(response.message);
            
             //alert(response.message);

             Swal.fire({
                title: 'Success!',
                text: response.message,
                icon: 'success',
                confirmButtonText: 'OK'
            }).then(() => {
                $('#update-order-reciept').modal('hide');
                $('#invdetail').load(window.location.href + ' #invdetail'); 
            });

           
           
        },
        error: function (xhr, status, error) {
            Swal.fire({
                title: 'Error!',
                text: 'error in update order receipt.',
                icon: 'error',
                confirmButtonText: 'OK'
            });
               
            
        }
    });
});



</script>
