@include('layouts.header')
@include('layouts.sidebar')

<div class="page-wrapper">
    <div class="content">
        <!-- Page Header -->
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Purchase Order</h4>
                </div>
            </div>
            <div class="page-btn">
                <a href="{{ route('purchase_orders')}}" class="btn btn-added"><i data-feather="arrow-left" class="me-2"></i>Back To PO</a>
            </div>
        </div>

        <!-- Flash Messages -->
        @if(session()->has('success'))
            <div class="alert alert-success">{{ session()->get('success') }}</div>
        @endif
        @if(session()->has('error'))
            <div class="alert alert-danger">{{ session()->get('error') }}</div>
        @endif

        <!-- Purchase Order Design -->
        <div class="card table-list-card">
            <div class="card-body">
                <!-- Header Section -->
                <header style="border-bottom: 3px solid black; padding: 5px;">
                    <div>
                        <h6 style="font-weight: bold; float:right;">Ph nos: 9665065522 /25 /34</h6>
                    </div>
                    <br><br>
                    <div>
                        <h1 style="font-weight: bold;text-align: center;">{{ $po_details['company_name']}}</h1>
                        <h6 style="text-align: center;">{{ $po_details['company_address'] ?? ''}}</h6>
                    </div>
                    <div>
                        <!--<span style="text-align: center;font-weight: bold;"><a href="">kukreja_interiors@yahoo.com</a></span>
                        <span style="font-weight: bold; float:right;">GSTIN:27AMSPK1108K1ZU</span>-->
                    </div>
                </header>

                <!-- Address Section -->
                <div style="border-bottom: 3px solid black; padding: 5px;">
                    <div>
                        <span>To</span>
                        <span class="float-end" style="margin-right: 5%;">P.O No:{{ $po_details['po_number']}}</span>
                    </div>
                    <div>
                        <span>M/S:{{ $po_details['supplier_name'] ?? ''}}</span>
                        <span class="float-end" style="margin-right: 5%;">Date:{{ date('d-m-Y', strtotime($po_details['po_date'])) }}
                        </span>
                    </div>
                    <div>
                        <span>Address:{{ $po_details['supplier_address'] ?? ''}}</span>
                    </div>
                    <br>
                    <div>
                        <!--<span>Kind Attn:</span>
                        <span class="float-end" style="margin-right: 15%;">Ph No.:</span>-->
                    </div>
                </div>

                <!-- Subject Section -->
                <div style="border-bottom: 1px solid black;">
                    <h6 style="padding: 5px;">Subject: We are pleased to place the order for the following material to you.</h6>
                </div>

                <!-- Purchase Items Table -->
                <div>
                    <table class="table table-bordered" style="width:100%; border-collapse: collapse;">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Product Name</th>
                                <th>Design/Variant No</th>
                                <th>No Of Rolls</th>
                                <th>Quantity Per Roll</th>
                                <th>Rate per Unit</th>
                                <th>UOM</th>
                                <th>%GST</th>
                                <th>Amount</th>
                                {{-- <th>Net Amount</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                            @php $i = 1; @endphp
                            @foreach($po_details['items'] as $item)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $item->product_name }}</td>
                                <td>{{ $item->varient_name }} - {{ $item->varient_code }}</td>
                                <td>{{ $item->no_of_rolls }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ $item->rate }}</td>
                                <td>{{ $item->uom }}</td>
                                <td>{{ $item->gst_percent }}%</td>
                                <td>{{ $item->total }}</td>
                            </tr>
                            @endforeach

                            <!-- Note -->
                            <tr>
                                <td colspan="8" style="font-weight: bold;">Note: {{ $po_details['note'] }}</td>
                            </tr>

                            <!-- Gross Total -->
                            <tr>
                                <td rowspan="6"></td>
                                <td colspan="4" rowspan="2"></td>
                                <td colspan="2">Gross Total</td>
                                <td colspan="2">₹ {{ number_format($po_details['subtotal'], 2) }}</td>
                            </tr>

                            <!-- Forwarding Charges -->
                            @if(!empty($po_details['forwarding']))
                            <tr>
                                <td colspan="2">Forwarding</td>
                                <td colspan="2" class="text-dark">₹ {{ number_format($po_details['forwarding'], 2) }}</td>
                            </tr>
                            @endif

                            <!-- Message -->
                            <tr>
                                <td colspan="4" rowspan="2">Kindly send the material by above transport in best condition and mail us L.R. details ASAP</td>
                            </tr>

                            <!-- GST Calculation -->
                            @php
                                $gst_amount = $po_details['gst_amount'] ?? 0;
                                $gst_percent = $po_details['items'][0]->gst_percent ?? 0;

                                // Default: intra-state (SGST + CGST)
                                $sgst_percent = $cgst_percent = $gst_percent / 2;
                                $igst_percent = 0;

                                $sgst_amount = $cgst_amount = $gst_amount / 2;
                                $igst_amount = 0;

                                // Uncomment below if IGST applies instead:
                                /*
                                $sgst_percent = $cgst_percent = 0;
                                $sgst_amount = $cgst_amount = 0;
                                $igst_percent = $gst_percent;
                                $igst_amount = $gst_amount;
                                */
                            @endphp

                            <!-- SGST -->
                            @if($sgst_amount > 0)
                            <tr>
                                <!-- <td colspan="4"></td> -->
                                <td colspan="2">SGST ({{ $sgst_percent }}%)</td>
                                <td colspan="2">₹ {{ number_format($sgst_amount, 2) }}</td>
                            </tr>
                            @endif

                            <!-- CGST -->
                            @if($cgst_amount > 0)
                            <tr>
                                <td colspan="4"></td>
                                <td colspan="2">CGST ({{ $cgst_percent }}%)</td>
                                <td colspan="2">₹ {{ number_format($cgst_amount, 2) }}</td>
                            </tr>
                            @endif

                            <!-- IGST -->
                            @if($igst_amount > 0)
                            <tr>
                                <td colspan="4"></td>
                                <td colspan="2">IGST ({{ $igst_percent }}%)</td>
                                <td colspan="2">₹ {{ number_format($igst_amount, 2) }}</td>
                            </tr>
                            @endif

                            <!-- Final Total -->
                            <tr>
                                <td colspan="4"></td>
                                <td style="font-weight: bold;" colspan="2">Final Amount</td>
                                <td class="text-dark" colspan="2">₹ {{ number_format($po_details['grand_total'], 2) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <!-- Footer Section -->
                <div>
                    <h6 style="font-weight: bold; float:right; padding: 10px;">For {{$po_details['company_name']}}</h6>
                </div>
                <br><br>
                <div>
                    <h6 style="float:right; padding: 10px;"></h6>
                </div>
            </div>
        </div>
    </div>
</div>
 <!--
<div class="text-end" style="position: fixed; bottom: 20px; right: 20px;">
    <a href="{{ url('download-po/'.$po_details['id'] ?? '') }}" class="btn btn-primary">
        <i data-feather="download" class="me-2"></i>Download PDF
    </a>
</div>-->


@include('layouts.footer')
