@include('layouts.header')			
@include('layouts.sidebar')			

<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="page-title">
                <h4>{{ $category->category_name }}</h4>
                <h6>Add sub category</h6>
            </div>
        </div>
        <!-- /add -->
        <div class="row">
            <div class="col-lg-12 col-sm-12">
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                @endif
                @if(session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session()->get('error') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('add_subcategory')}}" method="POST" enctype="multipart/form-data" id="myForm">
                            @csrf
                            <input type="hidden" name="category_id" value="{{ $category->id }}" />
                          
                            <div class="productdetails">
                                <div class="input-group mb-3" id="subcategory-0">
                                    <input type="text" class="form-control" placeholder="Subcategory Name" name="subcategories[]" style="margin-right: 10px" required />
                                    <input type="file" class="form-control" name="images[]" style="margin-right: 10px" required />

                                    <select class="form-control" name="status[]" required style="margin-right: 10px">
                                        <option value="">Choose</option>
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>

                                    <div class="add-icon">
                                        <a href="#" title="Add" class="choose-add" id="add-subcategory" style="color:white;background:green;">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <line x1="12" y1="8" x2="12" y2="16"></line>
                                                <line x1="8" y1="12" x2="16" y2="12"></line>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div id="additional-subcategories"></div>
                            <button type="submit" class="btn btn-primary mt-3" id="submitBtn">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- /add -->
        <div class="row">
            <div class="col-lg-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="page-title">
                            <h4>Subcategory List</h4>
                        </div>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Image</th>
                                        <th>Status</th>
                                        <th class="no-sort">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($subcategory as $row)
                                   
                                    <tr>
                                        <td>{{ $row->sub_category_name }}</td>
                                        <td><img src="{{ url('uploads/subcategories/'.$row->image)}}" alt="Product Image" style="height:50px;width:100px;" onerror="this.onerror=null;this.src='{{ url('uploads/images.jpeg') }}';"></td>
                                        
                                        <td>@if($row->status == 1)<a href="{{ url('inactive_subcategory/'.$row->id) }}"><span class="badge badge-linesuccess">Active</span></a>@else
                                            <a href="{{ url('active_subcategory/'.$row->id) }}"><span class="badge badge-linedanger">Inactive</span></a>
                                        @endif</td>
                                        <td class="action-table-data">
                                            <div class="edit-delete-action">
                                                <a class="me-2 p-2" href="#" data-bs-toggle="modal" data-bs-target="#edit-subcategory" onclick="editSubcategory({{ $row->id }}, '{{ $row->sub_category_name }}','{{ $row->image}}', '{{ $row->status }}')">
                                                    <i data-feather="edit" class="feather-edit"></i>
                                                </a>
                                                <a class="confirm-text p-2 delete-action" data-id="{{ $row->id }}" href="javascript:void(0);">
                                                    <i data-feather="trash-2" class="feather-trash-2"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>   
            </div>       
        </div>
    </div>
</div>

<div class="modal fade" id="edit-subcategory">
    <div class="modal-dialog modal-dialog-centered custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Edit Subcategory</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body new-employee-field">
                        <form action="{{ route('edit_subcategory')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="edit-id" name="id">
                            <div class="mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" id="edit-name" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Image </label>
                                <input type="file" name="image" id="edit-image" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-control" id="edit-status" name="status" required>
                                    <option value="">Choose</option>
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                            <div class="modal-footer-btn">
                                <button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-submit">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function editSubcategory(id, name, image,status) {
        // Set the values in the modal form
        document.getElementById('edit-id').value = id;
        document.getElementById('edit-name').value = name;
        document.getElementById('edit-image').value = image;

        // Set the selected status
        var statusSelect = document.getElementById('edit-status');
        statusSelect.value = status; 
    }

    $(document).ready(function() {
        $('.table').DataTable({
            "pageLength": 5,
            "ordering": true,
            "searching": true,
            "info": true,
            "lengthChange": true,
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false,
            }]
        });
        
        let subcategoryCount = 0; // Counter for subcategory input fields

     
    // Function to add a new row
    function addSubcategoryRow() {

         // Check the last row's inputs before adding a new row
         const lastSubcategoryName = $('input[name="subcategories[]"]').last().val();
        const lastSubcategoryStatus = $('select[name="status[]"]').last().val();
        const lastSubcategoryImage = $('input[name="images[]"]').last().val(); 


        if (!lastSubcategoryName || !lastSubcategoryStatus || !lastSubcategoryImage) {
            Swal.fire({
                title: 'Validation Error',
                text: 'Please fill in the current subcategory and status before adding another.',
                icon: 'warning',
                confirmButtonText: 'Okay'
            });
            return; // Stop the function if validation fails
        }

        subcategoryCount++;

        // Append the new subcategory input
        $('#additional-subcategories').append(`
            <div class="input-group mb-3" id="subcategory-${subcategoryCount}">
                <input type="text" class="form-control" placeholder="Subcategory Name" name="subcategories[]" style="margin-right: 10px;" required />
                <input type="file" class="form-control" name="images[]" style="margin-right: 10px;" required />

                <select class="form-control" name="status[]" required style="margin-right: 10px">
                    <option value="">Choose</option>
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                </select>
               
                <div class="add-icon">
                    <a href="#" title="Add" class="choose-add" style="color:white;background:green;">
                         <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <line x1="12" y1="8" x2="12" y2="16"></line>
                                                <line x1="8" y1="12" x2="16" y2="12"></line>
                        </svg>
                    </a>
                </div>
            </div>
        `);

        // Update the previous row's add icon to remove icon (minus)
        $('.add-icon a').not(':last').replaceWith(`
            <a href="#" class="remove-subcategory" title="Remove" style="color:white;background:red">
                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="8" y1="12" x2="16" y2="12"></line>
                        </svg>

            </a>
        `);
    }

    // Delegate event handling for adding a new row
    $(document).on('click', '#add-subcategory, .choose-add', function(e) {
        e.preventDefault();

        // Add new row
        addSubcategoryRow();
    });

    // Remove subcategory input field
    $(document).on('click', '.remove-subcategory', function(e) {
        e.preventDefault();
        $(this).closest('.input-group').remove();
    });
     $(document).on('click', '.delete-action', function (e) {
			
            e.preventDefault();
            var userId = $(this).data('id');
			
            var deleteUrl = "{{ url('delete-subcategory') }}/" + userId;

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({

						
                        url: deleteUrl,
                        method: 'DELETE',
                         data: {
                    _token: "{{ csrf_token() }}" // Add CSRF token to the request
                },
                        success: function (response) {
                            Swal.fire(
                                'Deleted!',
                                'Subcategory has been deleted.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr, status, error) {
                            Swal.fire(
                                'Error!',
                                'There was a problem deleting the user.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    });
     document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); 
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
</script>

@include('layouts.footer')

