@include('layouts.header')
			<!-- /Header -->
			
			@include('layouts.sidebar')

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Warehouse List</h4>
								<h6>Manage your warehouse</h6>
							</div>						
						</div>
						<!--<ul class="table-top-head">
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Print"><i data-feather="printer" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh"><i data-feather="rotate-ccw" class="feather-rotate-ccw"></i></a>
							</li>
							<li>
								<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
							</li>
						</ul>-->
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-warehouse"><i data-feather="plus-circle" class="me-2"></i>Add New Warehouse</a>
						</div>
					</div>
					@if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
					@endif
					@if(session()->has('error'))
					<div class="alert alert-danger">
						{{ session()->get('error') }}
					</div>
				    @endif
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<div class="d-flex align-items-center">
										<a class="btn btn-filter" id="filter_search">
											<i data-feather="filter" class="filter-icon"></i>
											<span><img src="assets/img/icons/closes.svg" alt="img"></span>
										</a>
										<div class="layout-hide-box">
											<a href="javascript:void(0);" class="me-3 layout-box"><i data-feather="layout" class="feather-search"></i></a>
											<div class="layout-drop-item card">
												<div class="drop-item-head">
													<h5>Want to manage datatable?</h5>
													<p>Please drag and drop your column to reorder your table and enable see option as you want.</p>
												</div>
												<ul>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Shop</span>
															<input type="checkbox" id="option1" class="check" checked>
															<label for="option1" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Product</span>
															<input type="checkbox" id="option2" class="check" checked>
															<label for="option2" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Reference No</span>
															<input type="checkbox" id="option3" class="check" checked>
															<label for="option3" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Date</span>
															<input type="checkbox" id="option4" class="check" checked>
															<label for="option4" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Responsible Person</span>
															<input type="checkbox" id="option5" class="check" checked>
															<label for="option5" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Notes</span>
															<input type="checkbox" id="option6" class="check" checked>
															<label for="option6" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Quantity</span>
															<input type="checkbox" id="option7" class="check" checked>
															<label for="option7" class="checktoggle">	</label>
														</div>
													</li>
													<li>
														<div class="status-toggle modal-status d-flex justify-content-between align-items-center">
															<span class="status-label"><i data-feather="menu" class="feather-menu"></i>Actions</span>
															<input type="checkbox" id="option8" class="check" checked>
															<label for="option8" class="checktoggle">	</label>
														</div>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div>-->
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="archive" class="info-img"></i>
												<select class="select">
													<option>Choose Warehouse</option>
													<option>Legendary</option>
													<option>Determined</option>
													<option>Sincere</option>
													<option>Pretty</option>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="user" class="info-img"></i>
												<select class="select">
													<option>Choose Person</option>
													<option>Steven</option>
													<option>Gravely</option>
												</select>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="calendar" class="info-img"></i>
												<div class="input-groupicon">
													<input type="text" class="datetimepicker" placeholder="Created Date" >
												</div>
											</div>
										</div>
										<div class="col-lg-2 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="user" class="info-img"></i>
												<select class="select">
													<option>Choose Status</option>
													<option>Active</option>
													<option>Inactive</option>
												</select>
											</div>
										</div>
										<div class="col-lg-4 col-sm-6 col-12 ms-auto">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table  datanew">
									<thead>
										<tr>
											<th class="no-sort">Action</th>
											<th>Warehouse</th>
											<th>City</th>
											<th>Address</th>
											<th>Phone No</th>
											<th>Capacity</th>
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
										@foreach($warehouses as $row)
										<tr>
											
											<td class="action-table-data">
												<div class="edit-delete-action">
													<!--<a class="me-2 edit-icon p-2" href="#" data-bs-toggle="modal" data-bs-target="#edit-units">
														<i data-feather="eye" class="feather-eye"></i>
													</a>-->
													<a class="me-2 p-2" href="#" data-bs-toggle="modal" data-bs-target="#edit-warehouse" onclick="editWarehouse({{ $row->id }}, '{{ $row->warehouse_name }}', '{{ $row->status }}','{{ $row->city }}','{{ $row->capacity }}','{{ $row->address }}','{{ $row->phone_no }}')">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" href="javascript:void(0);" data-id="{{ $row->id}}">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
												
											</td>
											<td>
												{{ $row->warehouse_name}}									
											</td>
											<td>{{ $row->city}}</td>
											<td>{{ $row->address}}</td>
											<td>{{ $row->phone_no}}</td>
											<td>
												{{ $row->capacity}}
											</td>
											
											<td>@if($row->status==1)<a href="{{ url('inactive_warehouse/'.$row->id)}}"><span class="badge badge-linesuccess">Active</span></a>@else
                                                <a href="{{ url('active_warehouse/'.$row->id)}}"><span class="badge badge-linedanger">Inactive</span></a>
                                            @endif</td>
											
										</tr>									
									@endforeach
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->

		<!-- Add Warehouse -->
		<div class="modal fade" id="add-warehouse">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Add Warehouse</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="{{ route('add_warehouse')}}"  id="myForm" method="post">
									@csrf
									<!--<div class="modal-title-head">
										<h6><span><i data-feather="info" class="feather-edit"></i></span>Warehouse Info</h6>
									</div>-->
									<div class="row">
										<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Name</label>
												<input type="text" name="warehouse_name" class="form-control" id="warehouse" required><small id="warehouse-error" style="color: red; display: none;">This warehouse is already used!</small>
											</div>
										</div>
										<!--<div class="col-lg-6">
											<div class="input-blocks">
												<label>Contact Person</label>
												<select class="select">
													<option>Choose</option>
													<option>Steven</option>
													<option>Gravely</option>
												</select>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="mb-3 war-add">
												<label class="mb-2">Phone Number</label>
												<input class="form-control" id="phone" name="phone" type="text">
											</div>
										</div>
										
										<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Email</label>
												<input type="email" class="form-control">
											</div>
										</div>-->
										<!--<div class="modal-title-head">
											<h6><span><i data-feather="map-pin"></i></span>Location</h6>
										</div>-->
										<!--<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Address</label>
												<textarea class="form-control" name="address" ></textarea>
											</div>
										</div>
									
										<div class="col-lg-6">
											<div class="mb-3">
												<label class="form-label">State</label>
												<input type="text" class="form-control" name="state" >
											</div>
										</div>-->
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">City</label>
												<input type="text" class="form-control" name="city" required>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">Phone No</label>
												<input type="text" class="form-control" name="phone_no" onkeypress="return event.charCode >= 48 && event.charCode <= 57" >
											</div>
										</div>
										<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Address</label>
												<textarea class="form-control" name="address" ></textarea>
											</div>
											</div>
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">Capacity</label>
												<input type="text" class="form-control" name="capacity" required>
											</div>
										</div>
										<div class="col-lg-12">
											<div class="mb-3 mb-0">
												<label class="form-label">Status</label>
												<select class="select" name="status" required>
													<option value="">Select</option>
													<option value="1">Active</option>
													<option value="0">Inactive</option>
												</select>
											</div>
										</div>
									</div>
									
									
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" id="submitBtn" class="btn btn-submit">Create Warehouse</button></button><p id="message" style="color: red;"></p>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- /Add Warehouse -->

		<!-- Edit Warehouse -->
		<div class="modal fade" id="edit-warehouse">
			<div class="modal-dialog modal-dialog-centered custom-modal-two">
				<div class="modal-content">
					<div class="page-wrapper-new p-0">
						<div class="content">
							<div class="modal-header border-0 custom-modal-header">
								<div class="page-title">
									<h4>Edit Warehouse</h4>
								</div>
								<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								</button>
							</div>
							<div class="modal-body custom-modal-body">
								<form action="{{ route('edit_warehouse')}}" method="post">
									@csrf
									<input type="hidden" name="id" id="edit-id">
									
									<div class="row">
										<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Name</label>
												<input type="text" class="form-control" id="edit-name" name="warehouse_name" required>
											</div>
										</div>
										
										
										
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">City</label>
												<input type="text" class="form-control" id="edit-city" name="city" required>
											</div>
										</div>
										
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">Capacity</label>
												<input type="text" class="form-control" id="edit-capacity" name="capacity" required>
											</div>
										</div>
										<div class="col-lg-6">
											<div class="mb-3 mb-0">
												<label class="form-label">Phone No</label>
												<input type="text" class="form-control" name="phone_no" id="edit-phone" onkeypress="return event.charCode >= 48 && event.charCode <= 57" >
											</div>
										</div>
										<div class="col-lg-12">
											<div class="mb-3">
												<label class="form-label">Address</label>
												<textarea class="form-control" name="address" id="edit-address" ></textarea>
											</div>
											</div>

										<div class="col-lg-12">
											<div class="mb-3 mb-0">
												<label class="form-label">Status</label>
												<select class="form-control" id="edit-status" name="status" required>
													<option value="">Choose</option>
													<option value="1">Active</option>
													<option value="0">Inactive</option>
												</select>
											</div>
										</div>
										
									</div>
									
									<div class="modal-footer-btn">
										<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
										<button type="submit" class="btn btn-submit">Save Changes</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		
        <script>
            function editWarehouse(id, name, status,city,capacity,address,phone) {
                // Set the values in the modal form
                document.getElementById('edit-id').value = id;
                document.getElementById('edit-name').value = name;
				document.getElementById('edit-city').value = city;
				document.getElementById('edit-phone').value = phone;
				document.getElementById('edit-capacity').value = capacity;
				document.getElementById('edit-address').value = address;
		
                console.log("Editing User Type:", { id, name, address });  // Debugging line
        
                // Set the selected status
                var statusSelect = document.getElementById('edit-status');
                statusSelect.value = status; 
                
                // Debugging: Log selected value
                console.log("Status Select Value:", statusSelect.value);  // Debugging line
                
                // Ensure that the correct option is selected
                Array.from(statusSelect.options).forEach(function(option) {
                    console.log("Option Value:", option.value);  // Debugging line
                    if (option.value == status) {
                        option.selected = true;
                    }
                });
            }
        



	$(document).ready(function () {

		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
        });

		$(document).on('click', '.delete-action', function (e) {
			
            e.preventDefault();
            var userId = $(this).data('id');
			
            var deleteUrl = "{{ url('delete-warehouse') }}/" + userId;

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({

						
                        url: deleteUrl,
                        method: 'DELETE',
                        success: function (response) {
                            Swal.fire(
                                'Deleted!',
                                'Unit has been deleted.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr, status, error) {
                            Swal.fire(
                                'Error!',
                                'There was a problem deleting the user.',
                                'error'
                            );
                        }
                    });
                }
            });
        });

    });
    
    
     $("#warehouse").on("keyup blur", function (e) { 
        let warehouse = $(this).val();
       
            $.ajax({
                url: "{{ route('check_warehouse_exists') }}",
                type: "POST",
                data: {
                    warehouse: warehouse,
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#warehouse-error").show(); 
                        $("#warehouse").addClass("error-field"); 
                        $("#warehouse").focus(); 
                        $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This warehouse is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#warehouse-error").hide(); 
                        $("#warehouse").removeClass("error-field"); 
                    }
                }
            });
             $("#submitBtn").prop("disabled", false);
         $("#message").hide();
    });
    $("#warehouse").on("keydown", function (e) {
        if (e.key === "Tab" && $("#warehouse-error").is(":visible")) {
            e.preventDefault(); 
        }
    });

   
    
    document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
</script>
		@include('layouts.footer')
