
 <!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Purchase Order</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body style="font-family: Poppins; background: #fff; padding: 20px;">

	<!-- Inward Header -->
	<header style="border-bottom: 3px solid black; padding: 5px;" class="p-4">
		<div>
			<h6 style="font-weight: bold; float:right;">Ph nos: 9665065522 /25 /34</h6>
		</div><br><br>
		<div>
			<h1 style="font-weight: bold;text-align: center;">{{ $purchaseOrder->company_name }}</h1>
			<h6 style="text-align: center;">{{ $purchaseOrder->address }}</h6>
		</div>
	</header>

	<!-- Inward Info -->
	<div style="padding: 20px; border-bottom: 3px solid black;">
    <table style="width: 100%; border-collapse: collapse;">
        <tr>
            <td style="width: 50%; padding: 5px;">
                <strong>PO Number:</strong> {{ $purchaseOrder->po_number }}
            </td>
            <td style="width: 50%; padding: 5px; text-align: right;">
                <strong>Date:</strong> {{ \Carbon\Carbon::parse($purchaseOrder->po_date)->format('d-m-Y') }}
            </td>
        </tr>
        <tr>
            <td style="width: 50%; padding: 5px;">
                <strong>Supplier:</strong> {{ $purchaseOrder->supplier_name }}
            </td>
            <td style="width: 50%; padding: 5px; text-align: right;">
                <strong>Address:</strong> {{ $purchaseOrder->supplier_address }}
            </td>
        </tr>
    </table>
</div>


	<!-- Product Summary -->

   <div style="margin-top: 40px;">
    <h5 style="font-weight: bold;">Product Summary</h5><br>
    <table style="width: 100%; border-collapse: collapse; border: 1px solid #000; font-size: 12px;">
        <thead>
            <tr>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">No</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Product Name</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Design / Variant No</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">No of Rolls</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Quantity per Roll</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">UOM</th>
				  <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">GST</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Rate per Unit</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Amount</th>
            </tr>
        </thead>
        <tbody>

		
           @php $i=1 @endphp
		   @foreach($purchaseOrderItems as $item)

            <tr>
                <td style="border: 1px solid #000; padding: 6px;">{{ $i++}}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ $item->product_name }}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ $item->varient_name}} - {{ $item->varient_code}}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ $item->no_of_rolls }}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ $item->quantity }}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ $item->uom }}</td>
				 <td style="border: 1px solid #000; padding: 6px;">{{ $item->gst_percent }}%</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ number_format($item->rate, 2) }}</td>
                <td style="border: 1px solid #000; padding: 6px;">{{ number_format($item->total, 2) }}</td>
            </tr>
			 @endforeach

            <!-- Subtotal Row -->
            <tr>
                <td colspan="7" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>Sub Total</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;">{{ number_format($purchaseOrder->subtotal, 2) }}</td>
            </tr>
			 <tr>
                <td colspan="7" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>Forwarding</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;">{{ number_format($purchaseOrder->f_amount, 2) }}</td>
            </tr>

			<tr>
                <td colspan="7" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>GST</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;">{{ number_format($purchaseOrder->gst_amount, 2) }}</td>
            </tr>

            <!-- Grand Total Row -->
            <tr>
                <td colspan="7" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>Grand Total</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;">{{ number_format($purchaseOrder->grand_total, 2) }}</td>
            </tr>
        </tbody>
    </table>
</div>



	<!-- Footer -->
	<div style="margin-top: 30px;">
		<h6 style="font-weight: bold; float:right; padding: 10px;">For {{ $purchaseOrder->company_name ?? '' }}</h6>
	</div><br><br>
	<div>
		<h6 style="float:right; padding: 10px;">Authorized Signature</h6>
	</div>

</body>
</html>

