<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Credit Report</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 5px;
            font-size: 14px;
            border: 1px solid black; /* Add borders for better alignment */
        }

        th {
            /*background-color: #f2f2f2;*/
        }

        .text-right {
            text-align: right;
        }

            .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }


        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 20px;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px; 
        }
    </style>
     <style>
    .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }
 .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

.back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }
   

  </style>
  <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>

</head>
<body>
   <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('orders') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header>
    <!-- <a href="">Go Back</a> -->
    <hr>

    <section style="margin-top: 30px;">
        <div class="title">CREDIT REPORT</div>

 @if(!$is_pdf)
   <form method="GET" action="{{ route('credit_report') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
      <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">All</option>
        @foreach($customers as $row)
        <option value="{{ $row->id}}" {{ request('customer') == $row->id ? 'selected' : '' }}>{{ $row->customer_name}}</option>
       @endforeach
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('credit_report')}}" class="reset-button">Reset</a>
</form>
@endif
        <!-- <table>
            <tr>
                <th>OrdNo</th>
                <th>Date</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>Balance Amount</th>
            </tr>
            @php $totalBalance = 0; @endphp
            @if(isset($order_data) && count($order_data) > 0)
                @foreach($order_data as $key => $data)
                    <tr>
                        <td colspan="5"><b>{{ $key }}</b></td> <!-- Customer Name in Full Row --
                    </tr>
                    @foreach($data as $item)
                        <tr>
                            <td>{{ $item->order_code }}</td>
                            <td>
                                {{ $item->order_date ? \Carbon\Carbon::parse($item->order_date)->format('d-m-Y') : '-' }}</td>
                            <td>{{ $key }}</td>
                            <td>{{ $item->mobile }}</td>
                            <td class="text-right">{{ number_format($item->grandtotal, 2) }}</td>
                        </tr>
                        @php $totalBalance += $item->grandtotal; @endphp
                    @endforeach
                @endforeach
            @endif
            <tr>
                <td colspan="4" class="text-right"><b>Total Balance:</b></td>
                <td class="text-right"><b>{{ number_format($totalBalance, 2) }}</b></td>
            </tr>
        </table> -->

        <table class="table table-bordered" style="width: 100%; font-size: 14px; border-collapse: collapse;" border="1">
            <thead>
                <tr style="background-color: #f8f9fa;" class="text-center">
                    <th>Order No</th>
                    <th>Rec No</th>
                    <th>Order Date</th>
                    <th>Customer</th>
                     <th>Phone</th> 
                    <th>Transaction Date</th>
                    <th>Payment Details</th>
                    <th>Total</th>
                    <th>Paid</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                @php $grandBalance = 0; @endphp

                @foreach($grouped as $groupKey => $transactions)
                    @php
                        $first = $transactions->first();
                        $last = $transactions->last();
                        $rowCount = $transactions->count();
                        $dynamicTotal = $first->pay_amount + $first->remaining_amount;
                    @endphp

                    @foreach($transactions as $index => $txn)
                        <tr>
                            {{-- Show shared info only once using rowspan --}}
                            @if($index === 0)
                                <td rowspan="{{ $rowCount }}">{{ $txn->order_code }}</td>
                                <td rowspan="{{ $rowCount }}">{{ $txn->rec_no }}</td>
                                <td rowspan="{{ $rowCount }}">{{ \Carbon\Carbon::parse($txn->order_date)->format('d-m-Y') }}</td>
                                <td rowspan="{{ $rowCount }}">{{ $txn->customer_name }}</td>
                                <td rowspan="{{ $rowCount }}">{{ $txn->mobile }}</td> 
                            @endif

                            {{-- Transaction Date --}}
                            <td>
                                {{ $txn->transaction_date ? \Carbon\Carbon::parse($txn->transaction_date)->format('d-m-Y') : '-' }}
                            </td>

                            {{-- Payment Details --}}
                            <td>
                                @if($txn->payment_mode === 'Bank Transfer')
                                    Bank Transfer<br>
                                    <strong>Bank Name:</strong> {{ $txn->bank_name ?? '-' }}<br>
                                    <strong>Ac No:</strong> {{ $txn->account_number ?? '-' }}<br>
                                    <strong>IFSC Code:</strong> {{ $txn->ifsc_code ?? '-' }}
                                @elseif($txn->payment_mode === 'Cheque')
                                    Cheque<br>
                                    <strong>Cheque No:</strong> {{ $txn->cheque_number ?? '-' }}
                                @elseif($txn->payment_mode === 'Online')
                                    Online<br>
                                    <strong>Txn ID:</strong> {{ $txn->reference_id ?? '-' }}
                                @else
                                    {{ $txn->payment_mode ?? '-' }}
                                @endif
                            </td>

                            {{-- Total --}}
                            <td class="text-end">{{ number_format($dynamicTotal, 2) }}</td>

                            {{-- Paid --}}
                            <td class="text-end">{{ number_format($txn->pay_amount ?? 0, 2) }}</td>

                            {{-- Balance --}}
                            <td class="text-end">
                                @if($txn === $last)
                                    <strong>{{ number_format($txn->remaining_amount ?? 0, 2) }}</strong>
                                    @php $grandBalance += $txn->remaining_amount ?? 0; @endphp
                                @else
                                    -
                                @endif
                            </td>
                            
                            @php
                                $dynamicTotal = $txn->remaining_amount;
                            @endphp
                        </tr>
                    @endforeach
                @endforeach

                {{-- Grand Total --}}
                <tr style="background-color: #f1f1f1;">
                    <td  colspan="7" class="text-end"></td>
                    <td class="text-end"><strong>Total Balance:</strong></td>
                    <td colspan="2" class="text-end" style="font-weight: bold;">
                        {{ number_format($grandBalance, 2) }}
                    </td>
                </tr>
            </tbody>
        </table>



          <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('credit_report_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer')])}}">Download</a>
    <button type="button" class="custom-button" onclick="window.print()">Print</button>
         @endif
    </section>
</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

