<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customerwise Receipt Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 14px;
        }
        .header {
            display: flex;
               justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        .logo {
            width: 150px;    
            margin-right: 20px;
            margin-bottom: 10px;
        }
        .address {
            font-size: 14px;
            line-height: 1.5;
            text-align: right;
        }
        .title {
            text-align: center;
            margin: 20px 0;
            font-size: 18px;
            font-weight: bold;
        }
        .date-title {
            margin-top: -60px;
        }
        .customer-name {
            font-size: 14px;
            font-weight: bold;
            margin-top: 10px;
            text-decoration: underline; 
        }
        table {
            width: 100%;
            margin-bottom: 15px;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
        }
        th, td {
            padding: 5px;
            vertical-align: top;
            font-size: 14px;
            /*border: 1px solid #000;*/
        }
        th {
            text-align: left;
            text-decoration: underline;
        }
        .row-divider {
            height: 1px;
            background: #ccc;
            margin: 10px 0;
        }
        .footer {
            position: fixed;
            bottom: 15px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #777;
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

    </style>

    <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>


</head>
<body>

    <div class="header">
        <div class="logo">
            <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 100%;"><br><br><br>
            @if(!$is_pdf)
            <a href="{{route('orders')}}" class="back-button">Back</a>
           @endif
        </div>
        <div class="address" >
            <strong>Kukreja Interiors</strong><br>
            A-45, R Quarters, Near Sai Chowk, Pimpri,<br>
            Pune - 411017 Maharashtra, India<br>
            Phone : +91 96650 65522<br>
            Email : kukreja_interiors@yahoo.com
        </div>
    </div><hr style="color: whitesmoke;">

    <div class="title">Customerwise Receipt Details</div>
    <br>
    @if(!$is_pdf)
   <form method="GET" action="{{ route('customer_receipt') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="payment_mode" style="margin-bottom: 0; font-size:15px"><b>Payment Mode:</b></label>
<select name="payment_mode" id="payment_mode"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
    <option value="">Select</option>
    <option value="Bank Transfer" {{ request('payment_mode') == 'Bank Transfer' ? 'selected' : '' }}>Bank Transfer</option>
    <option value="Cash" {{ request('payment_mode') == 'Cash' ? 'selected' : '' }}>Cash</option>
    <option value="Online" {{ request('payment_mode') == 'Online' ? 'selected' : '' }}>Online</option>
    <option value="Cheque" {{ request('payment_mode') == 'Cheque' ? 'selected' : '' }}>Cheque</option>
</select>
<label for="bank" style="margin-bottom: 0; font-size:15px"><b>Order No:</b></label>
    <select name="order"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($orders as $row)
            <option value="{{ $row->id }}" {{ request('order') == $row->id ? 'selected' : '' }}>
                {{ $row->order_code }}
            </option>
        @endforeach
    </select>

      <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($customers as $row)
        <option value="{{ $row->id}}" {{ request('customer') == $row->id ? 'selected' : '' }}>{{ $row->customer_name}}</option>
       @endforeach
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('customer_receipt')}}" class="reset-button">Reset</a>
</form>
@endif
 <hr>
    <br>
    @php
        $today = \Carbon\Carbon::now()->setTimezone('Asia/Kolkata')->toDateString();
    @endphp<br>

    <!-- <div class="date-title">{{ \Carbon\Carbon::parse($today)->format('d-M-Y') }}</div> -->

    @php
        $grandTotal = 0;
        $headerShown = false;
    @endphp

    @foreach($groupedReceipts as $date => $customers)
        @foreach($customers as $customerName => $receipts)
            @php
                $customer = $receipts->first();
                $customerTotal = $receipts->sum('pay_amount');
                $grandTotal += $customerTotal;
            @endphp

            <table>
                @if(!$headerShown)
                <thead>
                    <tr>
                        <th>Receipt No</th>
                        <th>Order No</th>
                        <th>Invoice Date</th>
                        <th>Amount</th>
                        <th>Payment Mode</th>
                         <th>Details</th>
                        <th>Receipt Type</th>
                        <th>Order Status</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                @php $headerShown = true; @endphp
                @endif

                <tbody>
                    <tr>
                        <td colspan="10" style="text-decoration: underline;">{{ \Carbon\Carbon::parse($date)->format('d-M-Y') }}</td>
                    </tr>
                    <tr>
                        <td class="customer-name" colspan="10">{{ $customer->customer_display_name }}</td>
                    </tr>
                    @php
                        $totalAmountSum = 0;
                    @endphp

                    @foreach($receipts as $receipt)
                        @php
                            $totalAmountSum += $receipt->pay_amount;
                        @endphp
                        <tr>
                            <td>{{ $receipt->receipt_id }}</td>
                            <td>{{ $receipt->order_code }}</td>
                            <td>{{ date('d-m-Y',strtotime($receipt->order_date)) }}</td>
                            <td>{{ number_format($receipt->pay_amount, 2) }}</td>
                            <td>{{ $receipt->payment_mode }}</td>
                            <td>
                                    @if(!empty($receipt->bank_name))
                                        <b>Bank:</b> {{ $receipt->bank_name }}<br>
                                        @if(!empty($receipt->account_number))
                                            <b>Ac No:</b> {{ $receipt->account_number }}<br>
                                        @endif
                                        @if(!empty($receipt->ifsc_code))
                                            <b>IFSC:</b> {{ $receipt->ifsc_code }}<br>
                                        @endif
                                    @endif

                                    @if(!empty($receipt->reference_id))
                                        <b>Txn ID:</b> {{ $receipt->reference_id }}<br>
                                    @endif

                                    @if(!empty($receipt->cheque_number))
                                        <b>Cheque No:</b> {{ $receipt->cheque_number }}
                                    @endif

                                    @if(empty($receipt->bank_name) && empty($receipt->reference_id) && empty($receipt->cheque_number))
                                        -
                                    @endif
                                </td>

                           
                            <td>{{ $receipt->receipt_type }}</td>
                            <td>{{ $receipt->order_status }}</td>
                            <td>{{ $receipt->remark }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="3"></td>
                        <td style="border-top:1px solid black;border-bottom:1px solid black;"><strong>{{ number_format($totalAmountSum, 2) }}</strong></td>
                        <td colspan="6"></td>
                    </tr>
                </tbody>
            </table>

            <div class="row-divider"></div>
        @endforeach
    @endforeach

    <div style="margin-top: 20px; font-weight: bold;">
        <span style="border-bottom: 5px double black; padding-bottom: 4px;">Grand Total : ₹{{ number_format($grandTotal, 2) }}</span>
    </div>

    <div class="footer">
        Generated on {{ \Carbon\Carbon::now()->format('d M, Y h:i A') }}
    </div>
<br><br>
     @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('customer_receipt_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer'),'order' => request('order'),'payment_mode' => request('payment_mode')])}}">Download</a>
          <button type="button" class="custom-button" onclick="window.print()">Print</button>

         @endif

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

