<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Sales Report</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 14px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-row td {
            font-weight: bold;
            border-top: 2px solid black;
        }

        .double-border {
            border-top: 3px double black;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 15px;
        }

         .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
      }


    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        header img{
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }
        hr{
            border: 1px solid black;
            margin-bottom: 15px;
        }

        .custom-button {
      background-color: #4CAF50; 
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

    .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
    </style>
    <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>
<header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('orders') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header>
<hr>

<h2 style="text-align: center;">Invoice Sales Report</h2><br>
@if(!$is_pdf)
   <form method="GET" action="{{ route('inv_sales') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($customers as $row)
        <option value="{{ $row->id}}" {{ request('customer') == $row->id ? 'selected' : '' }}>{{ $row->customer_name}}</option>
       @endforeach
    
    </select>
     
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('inv_sales')}}" class="reset-button">Reset</a>
</form>
@endif
<br><br>

<section>
    <table>
        <tr style="white-space:nowrap;">
            <th>InvDate</th>
            <th>InvNo</th>
            <th>Customer Name</th>
            <th>GST Rate</th>
            <th>HSN code</th>
            <th>Base Amount</th>
            <th>SGST Sum</th>
            <th>CGST Sum</th>
            <th>IGST Sum</th>
            <th>Customer GST No</th>
        </tr>

        @php
            $final_base_amount = 0;
            $final_sgst = 0;
            $final_cgst = 0;
            $final_igst = 0;
        @endphp

        @foreach($salesdata as $data)
        <tr class="section-title">
            <td colspan="10">{{ $data['percentage'] }}% GST</td>
        </tr>

        @php
            $base_amount = 0;
            $sgst = 0;
            $cgst = 0;
            $igst = 0;
        @endphp

        @foreach($data['sales_items'] as $item)
        @php
            $base_amount += $item->base_amount;
            $sgst += $item->sgst_amount;
            $cgst += $item->cgst_amount;
            $igst += $item->igst_amount;
        @endphp
        <tr>
            <td>{{ \Carbon\Carbon::parse($item->invoice_date)->format('Y-m-d') }}</td>
            <td>{{ $item->invoice_no }}</td>
            <td>{{ $item->customer_name }}</td>
            <td>{{ $item->gst_rate }}%</td>
            <td>{{ $item->hsn_code }}</td>
            <td>{{ number_format($item->base_amount, 2) }}</td>
            <td>{{ number_format($item->sgst_amount, 2) }}</td>
            <td>{{ number_format($item->cgst_amount, 2) }}</td>
            <td>{{ number_format($item->igst_amount, 2) }}</td>
            <td>{{ $item->gst_number }}</td>
        </tr>
        @endforeach

        <tr class="total-row">
            <td colspan="5">Subtotal</td>
            <td>{{ number_format($base_amount, 2) }}</td>
            <td>{{ number_format($sgst, 2) }}</td>
            <td>{{ number_format($cgst, 2) }}</td>
            <td>{{ number_format($igst, 2) }}</td>
            <td></td>   

        </tr>

        @php
            $final_base_amount += $base_amount;
            $final_sgst += $sgst;
            $final_cgst += $cgst;
            $final_igst += $igst;

            if (!isset($gst_summary[$data['percentage']])) {
                $gst_summary[$data['percentage']] = [
                    'base' => 0, 'sgst' => 0, 'cgst' => 0, 'igst' => 0
                ];
            }

            $gst_summary[$data['percentage']]['base'] += $base_amount;
            $gst_summary[$data['percentage']]['sgst'] += $sgst;
            $gst_summary[$data['percentage']]['cgst'] += $cgst;
            $gst_summary[$data['percentage']]['igst'] += $igst;
        @endphp
        @endforeach

        <tr class="total-row double-border">
            <td>Grand Total</td>
            <td colspan="4"></td>
            <td>{{ number_format($final_base_amount, 2) }}</td>
            <td>{{ number_format($final_sgst, 2) }}</td>
            <td>{{ number_format($final_cgst, 2) }}</td>
            <td>{{ number_format($final_igst, 2) }}</td>
            <td></td>
        </tr>
    </table>

    <div style="margin-top:5%; border: 1px solid black; padding: 20px;">
            <h3>GST Summary</h3>
            <table>
                <tr>
                    <th>GST Rate</th>
                    <th>Base Amount</th>
                    <th>SGST Sum</th>
                    <th>CGST Sum</th>
                    <th>IGST Sum</th>
                </tr>
                @php
                    $summary_base_total = 0;
                    $summary_sgst_total = 0;
                    $summary_cgst_total = 0;
                    $summary_igst_total = 0;
                @endphp

                @foreach($gst_summary as $rate => $values)
                <tr>
                    <td>{{ $rate }}%</td>
                    <td>{{ number_format($values['base'], 2) }}</td>
                    <td>{{ number_format($values['sgst'], 2) }}</td>
                    <td>{{ number_format($values['cgst'], 2) }}</td>
                    <td>{{ number_format($values['igst'], 2) }}</td>
                </tr>
                @php
                    $summary_base_total += $values['base'];
                    $summary_sgst_total += $values['sgst'];
                    $summary_cgst_total += $values['cgst'];
                    $summary_igst_total += $values['igst'];
                @endphp
                @endforeach

                <tr class="double-border">
                    <td>Grand Total</td>
                    <td>{{ number_format($summary_base_total, 2) }}</td>
                    <td>{{ number_format($summary_sgst_total, 2) }}</td>
                    <td>{{ number_format($summary_cgst_total, 2) }}</td>
                    <td>{{ number_format($summary_igst_total, 2) }}</td>
                </tr>
            </table>
    </div>

    </div>
</section>

  <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('inv_sales_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer')])}}">Download</a>
             <button type="button" class="custom-button" onclick="window.print()">Print</button>

         @endif
</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>
