<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>LABOUR'S WORK DONE</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            white-space: nowrap;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 16px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-row td {
            font-weight: bold;
            border-top: 2px solid black;
        }

        .double-border {
            border-top: 3px double black;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 15px;
            text-decoration: underline;
        }

        .underline {
            text-decoration: underline;
        }

        .text-center {
            text-align: center;
        }
        .header img{
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }
        hr{
            border: 1px solid black;
            margin-bottom: 15px;
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .header {
            display: flex;
               justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        .logo {
            width: 150px;    
            margin-right: 20px;
            margin-bottom: 10px;
        }
        .address {
            font-size: 14px;
            line-height: 1.5;
            text-align: right;
        }
          .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

@media print {
    form,
    .custom-button,
    .back-button,
    .reset-button {
        display: none !important;
    }
}

    </style>
</head>
<body>
 <div class="header">
        <div class="logo">
            <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 100%;"><br><br><br>
            @if(!$is_pdf)
            <a href="{{route('index')}}" class="back-button">Back</a>
           @endif
        </div>
        <div class="address" >
            <strong>Kukreja Interiors</strong><br>
            A-45, R Quarters, Near Sai Chowk, Pimpri,<br>
            Pune - 411017 Maharashtra, India<br>
            Phone : +91 96650 65522<br>
            Email : kukreja_interiors@yahoo.com
        </div>
    </div><hr>

<section>
    <div style="">
        
        <h2 class="underline text-center">LABOUR'S WORK DONE</h2>
    </div>

    @if(!$is_pdf)
   <form method="GET" action="{{ route('labour_workdowns') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
      <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($customers as $row)
        <option value="{{ $row->id}}" {{ request('customer') == $row->id ? 'selected' : '' }}>{{ $row->customer_name}}</option>
       @endforeach
    
    </select>

       <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Installer:</b></label>
    <select name="installer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($installers as $row)
        <option value="{{ $row->id}}" {{ request('installer') == $row->id ? 'selected' : '' }}>{{ $row->full_name}}</option>
       @endforeach
        
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('labour_workdowns')}}" class="reset-button">Reset</a>
</form>
@endif

    @foreach($workdowns as $workdown)
        @php $total = 0; @endphp

        <div><p class="section-title">{{ $workdown['labour'] }}</p></div>
        <table>
            <tr>
                <th>Order No</th>
                <th>Date</th>
                <th>Customer Name</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>Total</th>
            </tr>

            @php 
                $groupedLabours = collect($workdown['workdown_items'])->groupBy('labour_name');
                $grandTotal = 0;  // Define once, outside the loop
            @endphp

            @foreach($groupedLabours as $labourName => $items)
                @php 
                    $labourTotal = 0; 
                @endphp
                
                <!-- Labour Name Row -->
                <tr>
                    <td colspan="6" style="font-weight:bold; background:#f2f2f2;">Labour: {{ $labourName }}</td>
                </tr>

                @foreach($items as $item)
                    @php 
                        $rowTotal = ($item->quantity * ($item->labour_rate ?? 0));
                        $labourTotal += $rowTotal;
                    @endphp
                    <tr>
                        <td>{{ $item->order_code }}</td>
                        <td>{{ \Carbon\Carbon::parse($item->updated_at)->format('d-m-Y') }}</td>
                        <td>{{ $item->customer_name }}</td>
                        <td>{{ $item->quantity }}</td>
                        <td>{{ number_format($item->labour_rate ?? 0, 2) }}</td>
                        <td>{{ number_format($rowTotal, 2) }}</td>
                    </tr>
                @endforeach

                <!-- Labour Total Row -->
                <tr class="total-row">
                    <td colspan="5" ><b style="float:right">Total for {{ $labourName }}</b></td>
                    <td><span class="double-border">{{ number_format($labourTotal, 2) }}</span></td>
                </tr>

                @php 
                    $grandTotal += $labourTotal; // Add after finishing this labour
                @endphp
            @endforeach

            <tr></tr>
            <!-- Grand Total Row -->
            <tr class="grand-total-row" style="font-weight:bold; background:#d9edf7;">
                <td colspan="5"><b>Grand Total</b></td>
                <td><span class="double-border">{{ number_format($grandTotal, 2) }}</span></td>
            </tr>
        </table>


    @endforeach
</section>
<br>
 @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('labour_workdowns_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer'),'installer' => request('installer')])}}">Download</a>
   <button type="button" class="custom-button" onclick="window.print()">Print</button>
         @endif

</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

