<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Stock Report</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

         .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        header div {
            /*text-align: right;*/
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            text-decoration: underline;
            margin-top: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
            font-size: 14px;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .total-row {
            font-weight: bold;
            background-color: #e6e6e6;
        }

        .section-header {
            font-size: 16px;
            font-weight: bold;
            text-align: left;
            padding: 10px;
            background-color: #f2f2f2;
            border: 1px solid black;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
        .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

    .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
    </style>
    <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

 <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('index') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header>
<hr>

    <h2> Stock Report</h2>
    <br>

     @if(!$is_pdf)
   <form method="GET" action="{{ route('supplier_stock_report') }}" id="filterForm" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">

    {{-- Supplier --}}
    <label for="supplier"><b>Supplier:</b></label>
    <select name="supplier" id="supplierSelect" class="form-control"   style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($suppliers as $row)
            <option value="{{ $row->id }}" {{ request('supplier') == $row->id ? 'selected' : '' }}>
                {{ $row->supplier_name }}
            </option>
        @endforeach
    </select>

    {{-- Product --}}
    <label for="product"><b>Product:</b></label>
    <select name="product" id="productSelect" class="form-control"   style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($products as $row)
            <option value="{{ $row->id }}" {{ request('product') == $row->id ? 'selected' : '' }}>
                {{ $row->product_name }}
            </option>
        @endforeach
    </select>

    {{-- Warehouse --}}
    <label for="warehouse"><b>Warehouse:</b></label>
    <select name="warehouse" id="warehouseSelect" class="form-control"   style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($warehouses as $row)
            <option value="{{ $row->id }}" {{ request('warehouse') == $row->id ? 'selected' : '' }}>
                {{ $row->warehouse_name }}
            </option>
        @endforeach
    </select>

    <button type="submit" class="custom-button">Filter</button>
    <a href="{{ route('supplier_stock_report') }}" class="reset-button">Reset</a>
</form>

@endif


    <section>
        @php
            $totalinwardGrandTotal= 0;
            $totalavlGrandTotal = 0;
            $totalcpGrandTotal = 0;
            $totalinwamtGrandTotal = 0;
        @endphp

        @foreach($inward_items as $inward)
            @php
                // Calculate inward total based on items
                $inwardTotal = 0;
                 $avlTotal = 0;
                  $cpTotal = 0;
                 $inwardAmountTotal = 0;

                
                
                foreach ($inward['items'] as $item) {
                    $inwardTotal += isset($item->availability) ? (float) $item->availability : 0;
                      $avlTotal += isset($item->quantity) ? (float) $item->quantity : 0;
                       $cpTotal += isset($item->basic_cost) ? (float) $item->basic_cost : 0;
                      $rowAmount = ((float)$item->availability) * ((float)$item->basic_cost);
                      $inwardAmountTotal += $rowAmount;
                      
                }
                $totalinwardGrandTotal += $inwardTotal;
                $totalavlGrandTotal += $avlTotal;
                $totalcpGrandTotal += $cpTotal;
                $totalinwamtGrandTotal += $inwardAmountTotal;
                
            @endphp

            <!-- <div class="section-title">{{ $inward['inward_id'] }} {{ $inward['supplier_name'] }}</div> -->
            <div class="section-title">{{ $inward['supplier_name'] }}</div>
            <table>
                <tr>
                    <th>Roll No</th>
                     <th>Product</th>
                    <th>Varient</th>
                    <th>Place</th>
                    <th>Roll-Qty</th>
                    <th>Avl-Qty</th>
                     <th>Rate</th>
                    <th>Total Amount</th>
                </tr>

                <tr class="section-header">
                    <!-- <td colspan="4">{{ $inward['inward_id'] }}- {{ $inward['supplier_name'] }}</td> -->
                     <td colspan="4">{{ $inward['supplier_name'] }}</td>
                </tr>

                @foreach($inward['items'] as $item)
                    <tr>
                        <td>{{ $item->id }}</td>
                        <td>{{ $item->product_name }}</td>
                        <td>{{ $item->varient_code ?? '-' }}-{{ $item->varient_name }}</td>
                        <td>{{ $inward['warehouse'] }}</td>
                        <td>{{ number_format((float) $item->quantity, 2) }}</td>
                        <td>{{ number_format((float) $item->availability, 2) }}</td>
                         <td>{{$item->basic_cost ?? ''}}</td>
                          <td>{{ $item->availability * $item->basic_cost }}</td>
                    </tr>
                @endforeach

                <tr class="total-row">
                    <td colspan="4">Total</td>
                    <td>{{ number_format($avlTotal, 2) }}</td>
                     <td>{{ number_format($inwardTotal, 2) }}</td>
                     <td> {{ number_format($cpTotal, 2) }}</td>
                      <td>{{  $inwardAmountTotal}}</td>
                </tr>
            </table>
        @endforeach

        <!-- Grand Total -->
        <table>
            <tr class="total-row">
                <td colspan="4" style="text-align:right;">Grand Total</td>
                <td>Avl-Qty:{{ number_format($totalavlGrandTotal, 2) }}</td>
                <td>Inward-Qty:{{ number_format($totalinwardGrandTotal, 2) }}</td>
                <td>CP:{{ number_format($totalcpGrandTotal, 2) }}</td>
                <td>Total Amount:{{ number_format($totalinwamtGrandTotal, 2) }}</td>
            </tr>
        </table>
         <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('supplier_stock_report_pdf',['supplier' => request('supplier'), 'product' => request('product'),'warehouse' => request('warehouse')])}}">Download</a>
   <button type="button" class="custom-button" onclick="window.print()">Print</button>
         @endif
    </section>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {

    $('#supplierSelect').on('change', function() {
        let supplierId = $(this).val();
        $('#productSelect').html('<option value="">Loading...</option>');
        $('#warehouseSelect').html('<option value="">Select</option>');

        if (supplierId) {
          $.get('/get-products-by-supplier/' + supplierId, function(data) {
            let options = '<option value="">Select</option>';
            // Access the 'products' key from the object
            (data.products || []).forEach(function(product) {
                options += `<option value="${product.id}">${product.product_name}</option>`;
            });
            $('#productSelect').html(options);
        });

        } else {
            $('#productSelect').html('<option value="">Select</option>');
        }
    });

    $('#productSelect').on('change', function() {
        let productId = $(this).val();
        let supplierId = $('#supplierSelect').val();
        $('#warehouseSelect').html('<option value="">Loading...</option>');

        if (productId) {
            let url = '/get-warehouses-by-product/' + productId;
            if (supplierId) {
                url += '/' + supplierId;
            }

            $.get(url, function(data) {
                let options = '<option value="">Select</option>';
                data.forEach(function(warehouse) {
                    options += `<option value="${warehouse.id}">${warehouse.warehouse_name}</option>`;
                });
                $('#warehouseSelect').html(options);
            });
        } else {
            $('#warehouseSelect').html('<option value="">Select</option>');
        }
    });

});
</script>


