<!DOCTYPE html>
<html lang="en">
    
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todays Inward</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 5px;
            font-size: 16px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

        .total {
            font-weight: bold;
            text-align: right;
        }

        .total hr {
            margin: 0;
            border-top: 1px solid black;
        }

        .final-total {
            font-size: 18px;
            font-weight: bold;
            text-align: right;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

    .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}


    </style>
    
<style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
    
</head>
<body>
     
<header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('inwards') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header><hr>

    <h2 class="section-title">Todays Inward</h2><br>
    <!-- {{ date('d-M-Y') }}<br> -->
@if(!$is_pdf)
   <form method="GET" action="{{ route('todays_inward') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('todays_inward')}}" class="reset-button">Reset</a>
</form>
@endif

    <section style="margin-top: 20px;">
    <!-- <table>
        <tr>
            <th>Sr No</th>
            <th style="width: 200px;">Design No / Name</th>
            <th>InwardQty</th>
            <th>UoM</th>
            <th>CP</th>
            <th>%GST</th>
            <th>GST amt</th>
            <th>Amount</th>
            <th>No Of Rolls</th>
        </tr>

        @php
            $grand_total_qty = 0;
            $grand_total_amount = 0;
            $serial = 1;
        @endphp

        @foreach($inward_data as $company_name => $suppliers)
            <tr><td colspan="9"><b>{{ $company_name }}</b></td></tr>

            @foreach($suppliers as $supplier_data)
                <tr>
                    <td colspan="3"><b>Supplier Invoice No: {{ $supplier_data['supplier_id'] ?? 'N/A' }}</b></td>
                    <td> <b>Inward Date:</b> {{ date('d-m-Y',strtotime($supplier_data['inward_date'])) }}</td>
                    <td colspan="3"></td>
                    <td><b>Place</b></td>
                    <td><b>{{ $supplier_data['warehouse'] ?? 'N/A' }}</b></td>
                </tr>

                @foreach($supplier_data['purchase_orders'] as $po_id => $purchase_order)
                    @foreach($purchase_order['items'] as $item)
                        @php
                            $total_type_qty = 0;
                            $total_type_amount = 0;
                        @endphp

                        <tr>
                            <td colspan="9"><b><u>TYPE {{ strtoupper($item['product_name'] ?? '-') }}</u></b></td>
                        </tr>

                        @foreach($item['purchase_order_items'] as $po_item)
                            @php
                                $gst_amt = ($po_item->gst_percent  * $po_item->rate) / 100;
                                $amount = ($po_item->rate * $po_item->quantity* $po_item->no_of_rolls) + ($gst_amt * $po_item->quantity);
                                $total_type_qty += $po_item->quantity;
                                $total_type_amount += $amount;
                                $grand_total_qty += $po_item->quantity;
                                $grand_total_amount += $amount;
                            @endphp

                            <tr>
                                <td>{{ $serial++ }}</td>
                                <td>{{ $po_item->varient_code }}-{{ $po_item->varient_name }}</td>
                                <td>{{ $po_item->quantity }}</td>
                                <td>{{ $po_item->unit_name }}</td>
                                <td>{{ $po_item->rate }}</td>
                                <td>{{ $po_item->gst_percent }}</td>
                                <td>{{ number_format($gst_amt, 2) }}</td>
                                <td>{{ number_format($amount, 2) }}</td>
                                <td>{{ $po_item->no_of_rolls }}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td colspan="2" class="total">Total Type Qty</td>
                            <td><b>{{ number_format($total_type_qty, 2) }}</b></td>
                            <td></td>
                            <td colspan="3" class="total">Total Type Amount</td>
                            <td><b>{{ number_format($total_type_amount, 2) }}</b></td>
                            <td></td>
                        </tr>
                    @endforeach
                @endforeach
            @endforeach
        @endforeach

        <tr>
            <td colspan="2" class="final-total">Grand Total</td>
            <td><b>{{ number_format($grand_total_qty, 2) }}</b></td>
            <td></td>
            <td colspan="3"></td>
            <td class="final-total"><b>{{ number_format($grand_total_amount, 2) }}</b></td>
            <td></td>
        </tr>
    </table> -->
    <table>
    <tr>
        <th>Sr No</th>
        <th style="width: 200px;">Varient Name</th>
        <th>Roll No</th>
        <th>InwardQty</th>
        <th>UoM</th>
        <th>CP</th>
        <th>%GST</th>
        <th>GST amt</th>
        <th>Amount</th>
    </tr>

    @php
        $grand_total_qty = 0;
        $grand_total_amount = 0;
        $serial = 1;
    @endphp

    @foreach($inward_data as $company_name => $suppliers)
        <tr><td colspan="9"><b>{{ $company_name }}</b></td></tr>

        @foreach($suppliers as $supplier_data)

            @php
                $inward_total_qty = 0;
                $inward_total_amount = 0;
            @endphp

            <tr>
                <td colspan="3"><b>Supplier Invoice No: {{ $supplier_data['supplier_id'] ?? 'N/A' }}</b></td>
                <td><b>Inward Date:</b> {{ date('d-m-Y',strtotime($supplier_data['inward_date'])) }}</td>
                <td colspan="3"></td>
                <td><b>Place</b></td>
                <td><b>{{ $supplier_data['warehouse'] ?? 'N/A' }}</b></td>
            </tr>

            @foreach($supplier_data['purchase_orders'] as $po_id => $purchase_order)
                @foreach($purchase_order['items'] as $item)
                    @php
                        $total_type_qty = 0;
                        $total_type_amount = 0;
                    @endphp

                    <tr>
                        <td colspan="9"><b><u>TYPE {{ strtoupper($item['product_name'] ?? '-') }}</u></b></td>
                    </tr>

                    @foreach($item['purchase_order_items'] as $po_item)
                        @php
                            $gst_amt = ($po_item->gst_percent * $po_item->rate) / 100;
                            $amount = ($po_item->rate * $po_item->no_of_rolls) + ($gst_amt);
                        @endphp

                        @foreach($po_item->rolls as $roll)
                            @php
                                // ✅ Add for each roll
                                $total_type_qty += $po_item->quantity;
                                $total_type_amount += $amount;
                                $inward_total_qty += $po_item->quantity;
                                $inward_total_amount += $amount;
                                $grand_total_qty += $po_item->quantity;
                                $grand_total_amount += $amount;
                            @endphp

                            <tr>
                                <td>{{ $serial++ }}</td>
                                <td>{{ $po_item->varient_code }}-{{ $po_item->varient_name }}</td>
                                <td>{{ $roll->roll_no }}</td>
                                <td>{{ number_format($po_item->quantity, 2) }}</td>
                                <td>{{ $po_item->unit_name }}</td>
                                <td>{{ $po_item->rate }}</td>
                                <td>{{ $po_item->gst_percent }}</td>
                                <td>{{ number_format($gst_amt, 2) }}</td>
                                <td>{{ number_format($amount, 2) }}</td>
                            </tr>
                        @endforeach
                    @endforeach

                    <tr>
                        <td colspan="3" class="total">Total Type Qty</td>
                        <td><b>{{ number_format($total_type_qty, 2) }}</b></td>
                        <td colspan="4" class="total">Total Type Amount</td>
                        <td><b>{{ number_format($total_type_amount, 2) }}</b></td>
                    </tr>
                @endforeach
            @endforeach

            {{-- ✅ Inward total row --}}
            <!-- <tr>
                <td colspan="3" class="inward-total">Inward Total Qty</td>
                <td><b>{{ number_format($inward_total_qty, 2) }}</b></td>
                <td colspan="4" class="inward-total">Inward Total Amount</td>
                <td><b>{{ number_format($inward_total_amount, 2) }}</b></td>
            </tr> -->
        @endforeach
    @endforeach

    <tr>
        <td colspan="3" class="final-total">Grand Total</td>
        <td><b>{{ number_format($grand_total_qty, 2) }}</b></td>
        <td colspan="4"></td>
        <td class="final-total"><b>{{ number_format($grand_total_amount, 2) }}</b></td>
    </tr>
</table>

     <br>
  @if(!$is_pdf)
       <a class="custom-button"
   href="{{ route('todays_inward_pdf', ['start_date' => request('start_date'), 'end_date' => request('end_date')]) }}">
   Download
</a>
 <button type="button" class="custom-button" onclick="window.print()">Print</button>
   @endif

   

   
</section>

</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>
