<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todays Inward</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 5px;
            font-size: 16px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            /*padding: 10px 20px;*/
        }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

        .total {
            font-weight: bold;
            text-align: right;
        }

        .total hr {
            margin: 0;
            border-top: 1px solid black;
        }

        .final-total {
            font-size: 18px;
            font-weight: bold;
            text-align: right;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }
    </style>
</head>
<body>
    <header class="header">
       <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo">
        <div style="line-height: 20px;">
            <b>{{ $company->company_name }}</b> <br>
            {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
            Phone: {{ $company->phone1 }} <br>
            GST NO: {{ $company->gst_no }}
        </div>
    </header><hr>

    <h2 class="section-title">Todays Inward</h2>
    {{ date('d-M-Y') }}<br>

    <section style="margin-top: 20px;">
    <table>
        <tr>
            <th>RollNo</th>
            <th style="width: 200px;">Design No / Name</th>
            <th>InwardQty</th>
            <th>UoM</th>
            <th>CP</th>
            <th>%GST</th>
            <th>GST amt</th>
            <th>Amount</th>
            <th>No Of Rolls</th>
        </tr>

        @php
            $grand_total_qty = 0;
            $grand_total_amount = 0;
            $serial = 1;
        @endphp

        @foreach($inward_data as $company_name => $suppliers)
            <tr><td colspan="9"><b>{{ $company_name }}</b></td></tr>

            @foreach($suppliers as $supplier_data)
                <tr>
                    <td colspan="4"><b>Supplier Invoice No: {{ $supplier_data['supplier_id'] ?? 'N/A' }}</b></td>
                    <td colspan="3"></td>
                    <td><b>Place</b></td>
                    <td><b>{{ $supplier_data['warehouse'] ?? 'N/A' }}</b></td>
                </tr>

                @foreach($supplier_data['purchase_orders'] as $po_id => $purchase_order)
                    @foreach($purchase_order['items'] as $item)
                        @php
                            $total_type_qty = 0;
                            $total_type_amount = 0;
                        @endphp

                        <tr>
                            <td colspan="9"><b><u>TYPE {{ strtoupper($item['product_name'] ?? '-') }}</u></b></td>
                        </tr>

                        @foreach($item['purchase_order_items'] as $po_item)
                            @php
                                $gst_amt = ($po_item->gst_percent * $po_item->rate) / 100;
                                $amount = ($po_item->rate * $po_item->quantity * $po_item->no_of_rolls) + ($gst_amt * $po_item->quantity);
                                $total_type_qty += $po_item->quantity;
                                $total_type_amount += $amount;
                                $grand_total_qty += $po_item->quantity;
                                $grand_total_amount += $amount;
                            @endphp

                            <tr>
                                <td>{{ $serial++ }}</td>
                                <td>{{ $po_item->varient_name }}</td>
                                <td>{{ $po_item->quantity }}</td>
                                <td>{{ $po_item->unit_name }}</td>
                                <td>{{ $po_item->rate }}</td>
                                <td>{{ $po_item->gst_percent }}</td>
                                <td>{{ number_format($gst_amt, 2) }}</td>
                                <td>{{ number_format($amount, 2) }}</td>
                                <td>{{ $po_item->no_of_rolls }}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td colspan="2" class="total">Total Type Qty</td>
                            <td><b>{{ number_format($total_type_qty, 2) }}</b></td>
                            <td></td>
                            <td colspan="3" class="total">Total Type Amount</td>
                            <td><b>{{ number_format($total_type_amount, 2) }}</b></td>
                            <td></td>
                        </tr>
                    @endforeach
                @endforeach
            @endforeach
        @endforeach

        <tr>
            <td colspan="2" class="final-total">Grand Total</td>
            <td><b>{{ number_format($grand_total_qty, 2) }}</b></td>
            <td></td>
            <td colspan="3"></td>
            <td class="final-total"><b>{{ number_format($grand_total_amount, 2) }}</b></td>
            <td></td>
        </tr>
    </table>

     <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('todays_inward_pdf')}}">Download</a>
   @endif
</section>

</body>
</html>