<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todays Cash</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border: 2px solid black;
            page-break-inside: auto;
        }

        th, td {
            border: 1px solid black;
            padding: 8px;
            font-size: 14px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
            border-bottom: 2px solid black;
        }

        .total-row td {
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
        }

        .grand-total td {
            text-decoration: underline;
            text-decoration-style: double;
            text-underline-offset: 5px;
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
            border-bottom: 2px solid black;
        }

        tr, td, th {
            page-break-inside: avoid;
        }

        tr.total-row td[colspan], tr.grand-total td[colspan] {
            border-right: 1px solid black;
            border-left: 1px solid black;
        }

         .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }

           .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

    </style>
    <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

 <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('orders') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header><hr>

<h2 class="section-title">Today's Cash</h2>
<!-- {{ date('d-M-Y') }} -->
  @if(!$is_pdf)
   <form method="GET" action="{{ route('todays_cash') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date', date('Y-m-d')) }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date', date('Y-m-d')) }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
     
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('todays_cash')}}" class="reset-button">Reset</a>
</form>
@endif
<br>

<section style="margin-top: 25px;">
  
    <table class="table table-bordered" style="width: 100%; font-size: 14px; border-collapse: collapse;" border="1">
    <thead>
        <tr style="white-space: nowrap; background-color: #f8f9fa;">
            <th>Order No</th>
            <th>Customer Name</th>
            <th>Transaction Date</th>
            <th>Amount</th>
            <th>Bill No</th>
            <th>Remarks</th>
            <th>Receipt Type</th>
        </tr>
    </thead>
    <tbody>
        @php $grandTotal = 0; @endphp

        @foreach($grouped_data as $paymentMethod => $customers)
            <tr>
                <td colspan="7" style="background-color: #d9edf7; font-weight: bold; text-align: center;">
                    {{ strtoupper($paymentMethod) }}
                </td>
            </tr>

            @foreach($customers as $customerName => $details)
                <tr>
                    <td colspan="7" style="font-weight: bold;">{{ ucfirst($customerName) }}</td>
                </tr>

                @php
                    $customerTotal = 0;
                    // Group first by order_id, then inside group by receipt_id
                    $ordersGrouped = collect($details['orders'])->groupBy('order_id');
                @endphp

                @foreach($ordersGrouped as $orderId => $orderGroup)
                    @php
                        $orderRowCount = $orderGroup->count();
                        $firstOrderRow = true;
                    @endphp

                    @php
                        $receiptGroups = $orderGroup->groupBy('receipt_id');
                    @endphp

                    @foreach($receiptGroups as $receiptId => $transactions)
                        @php
                            $receiptRowCount = count($transactions);
                            $firstReceiptRow = true;
                        @endphp

                        @foreach($transactions as $txn)
                            <tr>
                                {{-- Order No (rowspan) --}}
                                @if($firstOrderRow)
                                    <td rowspan="{{ $orderRowCount }}">{{ $txn['order_id'] }}</td>
                                    <td rowspan="{{ $orderRowCount }}">{{ ucfirst($customerName) }}</td>
                                    @php $firstOrderRow = false; @endphp
                                @endif

                                <td>{{ date('d-m-Y', strtotime($txn['transaction_date'])) }}</td>
                                <td>{{ number_format(floatval(str_replace(',', '', $txn['amount'])), 2) }}</td>

                                {{-- Receipt ID (Bill No) (rowspan) --}}
                                @if($firstReceiptRow)
                                    <td rowspan="{{ $receiptRowCount }}">{{ $txn['receipt_id'] }}</td>
                                    @php $firstReceiptRow = false; @endphp
                                @endif

                                <td>{{ $txn['remark'] }}</td>
                                <td>{{ $txn['rcpt_type'] }}</td>
                            </tr>

                            @php $customerTotal += floatval(str_replace(',', '', $txn['amount'])); @endphp
                        @endforeach
                    @endforeach
                @endforeach

                {{-- Customer Total --}}
                <tr style="background-color: #dff0d8;">
                    <td colspan="6" style="text-align: right;"><b>Subtotal for {{ ucfirst($customerName) }}:</b></td>
                    <td><b>{{ number_format($customerTotal, 2) }}</b></td>
                </tr>

                @php $grandTotal += $customerTotal; @endphp
            @endforeach
        @endforeach

        {{-- Grand Total --}}
        <tr style="background-color: #fcf8e3;">
            <td colspan="6" style="text-align: right;"><b>Grand Total:</b></td>
            <td><b>{{ number_format($grandTotal, 2) }}</b></td>
        </tr>
    </tbody>
</table>



    
  <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('todays_cash_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date')])}}">Download</a>
   <button type="button" class="custom-button" onclick="window.print()">Print</button>
         @endif
</section>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>
