<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Today's Collection</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 5px;
            font-size: 16px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
      }


    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

        .total {
            font-weight: bold;
            text-align: right;
        }

        .total hr {
            margin: 0;
            border-top: 1px solid black;
        }

        .final-total {
            font-size: 18px;
            font-weight: bold;
            text-align: right;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
        .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
    </style>
    <style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>
    <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('orders') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header>
    <hr>

    <h2 class="section-title">Today's Collection</h2>
    <!-- {{ date('d-M-Y') }} -->

    @if(!$is_pdf)
   <form method="GET" action="{{ route('todays_collection') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

     <label for="payment_mode" style="margin-bottom: 0; font-size:15px"><b>Payment Mode:</b></label>
<select name="payment_mode" id="payment_mode"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
    <option value="">Select</option>
    <option value="Bank Transfer" {{ request('payment_mode') == 'Bank Transfer' ? 'selected' : '' }}>Bank Transfer</option>
    <option value="Cash" {{ request('payment_mode') == 'Cash' ? 'selected' : '' }}>Cash</option>
    <option value="Online" {{ request('payment_mode') == 'Online' ? 'selected' : '' }}>Online</option>
    <option value="Cheque" {{ request('payment_mode') == 'Cheque' ? 'selected' : '' }}>Cheque</option>
</select>
 <div id="bank_section" style="display: {{ request('payment_mode') == 'Bank Transfer' ? 'block' : 'none' }};">
<label for="bank" style="margin-bottom: 0; font-size:15px"><b>Banks:</b></label>
<select name="bank"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
    <option value="">Select</option>
    @foreach($banks as $row)
        <option value="{{ $row->id }}" {{ request('bank') == $row->id ? 'selected' : '' }}>
            {{ $row->bank_name }}
        </option>
    @endforeach
</select>
</div>

 <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($customers as $row)
        <option value="{{ $row->id}}" {{ request('customer') == $row->id ? 'selected' : '' }}>{{ $row->customer_name}}</option>
       @endforeach
    
    </select>

    <label for="bank" style="margin-bottom: 0; font-size:15px"><b>Order No:</b></label>
    <select name="order"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        @foreach($orders as $row)
            <option value="{{ $row->id }}" {{ request('order') == $row->id ? 'selected' : '' }}>
                {{ $row->order_code }}
            </option>
        @endforeach
    </select>

     
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('todays_collection')}}" class="reset-button">Reset</a>
</form>
@endif
 

</br>

    <section style="margin-top: 20px;">
    <table border="1" style="border-collapse: collapse; width: 100%; font-size: 14px;">
        <tr>
            <th>Order No</th>
            <th style="width: 200px;">Customer Name</th>
            <th>Amount</th>
            <th>Transaction Date</th>
            <th>Rcpt No</th>
            <th>Payment Mode</th>
          
            <th>Rcpt Type</th>
            <th>Remarks</th>
        </tr>

        @php
            $grand_total = 0;
        @endphp

        @foreach($grouped_data as $payment_method => $customers)
            <tr style="background: cornsilk;"><td colspan="8"><b>{{ $payment_method }}</b></td></tr>

            @foreach($customers as $customer_name => $customer_data)
                <tr>
                    <td colspan="8"><b>{{ $customer_name }} (Total: {{ number_format($customer_data['total_amount'], 2) }})</b></td>
                </tr>

                @php
                    // Group by order_id to get rowspan
                    $orderGroups = collect($customer_data['orders'])->groupBy('order_id');
                @endphp

                @foreach($orderGroups as $order_id => $orders)
                    @php
                        $rowspan = $orders->count();
                        $first = true;
                    @endphp

                    @foreach($orders as $order)
                        <tr>
                            @if($first)
                                <td rowspan="{{ $rowspan }}">{{ $order_id }}</td>
                                <td rowspan="{{ $rowspan }}">{{ $customer_name }}</td>
                            @endif

                            <td>{{ number_format(floatval(str_replace(',', '', $order['amount'])), 2) }}</td>
                            <td>{{ date('d-m-Y', strtotime($order['transaction_date'] ?? '-')) }}</td>

                            @if($first)
                                <td rowspan="{{ $rowspan }}">{{ $order['receipt_id'] }}</td>
                            @endif
                            <td> @if(!empty($order['bank']))
                                <b>Bank:</b> {{ $order['bank'] }}<br>
                                <b>Ac No:</b> {{ $order['account_number'] ?? '-' }}<br>
                                <b>IFSC:</b> {{ $order['ifsc_code'] ?? '-' }}<br>
                            @endif

                            @if(!empty($order['reference_id']))
                                <b>Txn ID:</b> {{ $order['reference_id'] }}<br>
                            @endif

                            @if(!empty($order['cheq_no']))
                                <b>Cheque No:</b> {{ $order['cheq_no'] }}
                            @endif

                            @if(empty($order['bank']) && empty($order['reference_id']) && empty($order['cheq_no']))
                                -
                            @endif</td>
                            <td>{{ $order['rcpt_type'] }}</td>
                            <td>{{ $order['remark'] ?? '-' }}</td>
                        </tr>
                        @php $first = false; @endphp
                    @endforeach
                @endforeach

                @php
                    $grand_total += $customer_data['total_amount'];
                @endphp
            @endforeach
        @endforeach

        <tr>
            <td colspan="2" class="final-total"><b>Grand Total</b></td>
            <td class="final-total"><b>{{ number_format($grand_total, 2) }}</b></td>
            <td colspan="5"></td>
        </tr>
    </table>

        <br>
            @if(!$is_pdf)
                    <a class="custom-button"  href="{{ route('todays_collection_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'payment_mode' => request('payment_mode'),'bank' => request('bank'),'customer' => request('customer'),'order' => request('order')])}}">Download</a>
                    <button type="button" class="custom-button" onclick="window.print()">Print</button>
                    @endif
    </section>
</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });

    document.getElementById('payment_mode').addEventListener('change', function () {
        var bankSection = document.getElementById('bank_section');
        if (this.value === 'Bank Transfer') {
            bankSection.style.display = 'block';
        } else {
            bankSection.style.display = 'none';
        }
    });
</script>

