<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Today's Cutting</title>
</head>
<style>
    @page {
        size: A4 landscape;
        margin: 45px 40px 20px 40px;
    }

    body {
        font-family: DejaVu Sans, Arial, sans-serif;
        font-size: 14px;
        color: #000;
    }

    /* Table Styling */
    table {
        width: 100%;
        border-collapse: collapse;
        border: 1px solid black;
    }

    th, td {
        border: 1px solid black;
        text-align: left;
        padding: 8px;
        font-size: 16px;
    }

    th {
        background-color: #f2f2f2;
        font-weight: bold;
        text-align: center;
        line-height: 14px !important;
    }

    /* Header Styling */
      .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    .header img {
        height: 50px;
        width: 170px;
        margin-bottom: 7px;
    }

    .header .company-details {
        /*text-align: right;*/
    }

    .report-title {
        text-align: center;
        margin-top: 20px;
        font-size: 24px;
        font-weight: bold;
    }

    .report-date {
        margin-top: 10px;
        /*font-size: 18px;*/
        /*font-weight: bold;*/
    }
      .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
</style>
<style>
@media print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
<body>

    <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        @if(!$is_pdf)
            <a href="{{ route('orders') }}" class="back-button">Back</a>
        @endif
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b>{{ $company->company_name }}</b> <br>
        {{ $company->address }}, {{ $company->city }}, {{ $company->state }} <br>
        Phone: {{ $company->phone1 }} <br>
        GST NO: {{ $company->gst_no }}
    </div>
</header><br>

    <div class="report-title">Today's Cutting</div><br>
 @if(!$is_pdf)
   <form method="GET" action="{{ route('todays_cutting') }}" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="{{ request('start_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="{{ request('end_date') ?? date('Y-m-d') }}"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
     
           <button type="submit" class="custom-button">Filter</button>
     <a href="{{ route('todays_cutting')}}" class="reset-button">Reset</a>
</form>
@endif
    <!-- <div class="report-date">{{ date('d-m-Y') }}</div><br> -->

    <section>
       <table>
    <thead>
        <tr>
            <th>OrdNo</th>
            <th>Order Date</th>
            <th>Customer Name</th>
            <th>Roll No</th>
            <th>Product-Varient</th>
            <th>Rate</th>
            <th>From Quantity</th>
            <th>Used</th>
            <th>Balance</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        @if(isset($order_receipts) && count($order_receipts) > 0)
           @foreach($order_receipts as $order)
    @if($order->customer_name != '')
        @php $firstRow = true; $rowspan = count($order->order_items); @endphp

        @foreach($order->order_items as $item)
            <tr>
                {{-- Show Order ID and Customer Name only once using rowspan --}}
                @if($firstRow)
                    <td rowspan="{{ $rowspan }}">{{ $order->id }}</td>
                      <td rowspan="{{ $rowspan }}">{{ date('d-m-Y',strtotime($order->order_date)) }}</td>
                    <td rowspan="{{ $rowspan }}">{{ $order->customer_name }}</td>
                    @php $firstRow = false; @endphp
                @endif

                <td>{{ $item->roll_id }}</td>
                <td><b>{{ $item->product_name }}</b><br>{{ $item->varient_code }}-{{ $item->varient_name }}</td>
                <td>{{ number_format($item->price, 2) }}</td>
                <td>{{ number_format($item->roll_quantity, 2) }}</td>
                <td>{{ number_format($item->used_quantity, 2) }}</td>
                <td>{{ number_format($item->available_quantity, 2) }}</td>
                <td>{{ $item->installer_status }}</td>
            </tr>
        @endforeach

        {{-- Totals --}}
        @php
            $total = collect($order->order_items)->sum(fn($item) => $item->used_quantity * $item->price);
            $discount = $order->customer_discount_amount ?? 0;
            $finalTotal = $total - $discount;
        @endphp

        <tr>
            <td colspan="5" style="border-top: 1px solid black; font-weight: bold; text-align: right;">Total</td>
            <td style="border-top: 1px solid black; font-weight: bold; text-align: right;">
                @if($discount > 0)
                    {{ number_format($total, 2) }}<br>
                    <span>Discount: − {{ number_format($discount, 2) }}</span><br>
                    <span style="border-top: 1px dashed #000; display: inline-block; width: 100%; margin-top: 4px;">
                        {{ number_format($finalTotal, 2) }}
                    </span>
                @else
                    {{ number_format($total, 2) }}
                @endif
            </td>
            <td colspan="4"></td>
        </tr>
    @endif
@endforeach

            {{-- Grand Total --}}
            @php
                $grandTotal = collect($order_receipts)->sum(function ($order) {
                    $orderTotal = collect($order->order_items)->sum(function ($item) {
                        return $item->used_quantity * $item->price;
                    });
                    $discount = $order->customer_discount_amount ?? 0;
                    return $orderTotal - $discount;
                });
            @endphp

            <tr>
                <td colspan="4" style="border-bottom: double; font-weight: bold; text-align: right;">Grand Total</td>
                <td style="border-bottom: double; font-weight: bold; text-align: right;">
                    ₹{{ number_format($grandTotal, 2) }}
                </td>
                <td colspan="4"></td>
            </tr>
        @else
            <tr>
                <td colspan="9" style="text-align: center; padding: 20px; font-style: italic;">
                    No data available to display.
                </td>
            </tr>
        @endif
    </tbody>
</table>



        <br>
  @if(!$is_pdf)
         <a class="custom-button"  href="{{ route('todays_cutting_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date')])}}">Download</a>
    <button type="button" class="custom-button" onclick="window.print()">Print</button>
         @endif
    </section>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

