<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\CatalogController;
use App\Http\Controllers\Api\SearchController;
use App\Http\Controllers\Api\OrderController;
use App\Models\User;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('login', [UserController::class, 'login'])->name('login');

Route::post('sign-in', [UserController::class, 'sign_in']);
Route::post('login-with-otp', [UserController::class, 'login_with_otp']);
Route::post('sign-up', [UserController::class, 'sign_up']);

Route::post('verify-email', [UserController::class, 'verify_email']);
Route::post('verify-otp', [UserController::class, 'verify_otp']);
Route::post('verify-otp-forgotpassword', [UserController::class, 'verify_otp_forgotpassword']);
Route::post('send-otp', [UserController::class, 'send_otp']);
Route::post('resend-otp', [UserController::class, 'resend_otp']);
Route::post('update-business-details', [UserController::class, 'update_business_details']);
Route::post('forgot-password', [UserController::class, 'forgot_password']);
Route::post('forgot-password-mobile', [UserController::class, 'forgot_password_withmobile']);
Route::post('reset-password', [UserController::class, 'reset_password']);
Route::post('resend-email-code', [UserController::class, 'resend_email_code']);

Route::middleware('auth:api')->group(function () {
Route::post('change-password', [UserController::class, 'change_password']);
Route::post('customer-profile', [UserController::class, 'customer_profile']);
Route::post('update-customer-profile', [UserController::class, 'update_customer_profile']);
Route::post('delete-profile-picture', [UserController::class, 'delete_profilepicture']);
Route::get('get-all-brands', [CatalogController::class, 'get_all_brands']);
Route::get('get-all-categories', [CatalogController::class, 'get_all_categories']);
Route::get('get-all-products', [ProductController::class, 'get_all_products']);
Route::get('get-transporters', [CatalogController::class, 'get_transporters']);
Route::post('brandwise-category', [CatalogController::class, 'brandwise_category']);
Route::post('categorywise-product', [CatalogController::class, 'categorywise_product']);
Route::post('sub-categorywise-product', [CatalogController::class, 'sub_categorywise_product']);
Route::post('product-details', [ProductController::class, 'product_details']);
Route::post('transporter-details', [CatalogController::class, 'transporter_details']);
Route::post('add-transporter', [CatalogController::class, 'add_transporter']);
Route::post('update-transporter', [CatalogController::class, 'update_transporter']);
Route::post('delete-transporter', [CatalogController::class, 'delete_transporter']);

//searches
Route::post('search-by-all', [SearchController::class, 'search_by_all']);
Route::post('search-by-product', [SearchController::class, 'search_by_product']);
Route::get('top-selling-product', [SearchController::class, 'top_selling_product']);
Route::get('search-history', [SearchController::class, 'search_history']);
Route::post('store-history', [SearchController::class, 'storeSearchHistory']);
Route::get('popular-search-history', [SearchController::class, 'popular_search_history']);
Route::post('remove-history', [SearchController::class, 'removeSearchHistory']);
Route::get('remove-all-history', [SearchController::class, 'removeAllHistory']);

//cart 
Route::post('add-cart', [ProductController::class, 'addToCart']);
Route::get('view-cart', [ProductController::class, 'viewCart']);
Route::put('update-cart/{varientId}', [ProductController::class, 'updateCart']);
Route::post('remove-item', [ProductController::class, 'removeFromCart']);
Route::delete('clear-cart', [ProductController::class, 'clearCart']);

//end cart

//wishlist
Route::post('add-wishlist', [ProductController::class, 'addToWishlist']);
Route::get('view-wishlist', [ProductController::class, 'viewWishlist']);
Route::post('remove-wishlist', [ProductController::class, 'removeFromWishlist']);
Route::delete('clear-wishlist', [ProductController::class, 'clearWishlist']);
//end wishlist

//customer addresses
Route::get('address-list', [CatalogController::class, 'address_list']);
Route::post('add-address', [CatalogController::class, 'add_address']);
Route::post('delete-address', [CatalogController::class, 'delete_address']);
Route::get('coupons', [CatalogController::class, 'coupons']);
Route::post('/apply-coupon', [CatalogController::class, 'applyCoupon']);
Route::post('/remove-coupon', [CatalogController::class, 'removeCoupon']);
Route::get('pickup-points', [CatalogController::class, 'pickup_points']);


//orders
Route::post('order-save', [OrderController::class, 'order_save']);
Route::get('order-list', [OrderController::class, 'order_list']);
Route::post('view-order', [OrderController::class, 'view_order']);
Route::post('order-again', [OrderController::class, 'order_again']);

Route::get('get-pickups', [ProductController::class, 'get_pickups']);

Route::post('get-current-location', [CatalogController::class, 'get_current_location']);
Route::post('update-location', [CatalogController::class, 'update_location']);
Route::post('/calculate-distance', [CatalogController::class, 'calculateDistance']);


Route::post('first-addtocart', [ProductController::class, 'first_addtocart']);
Route::post('check-availability-varients', [ProductController::class, 'check_availability_varients']);
Route::post('pickup-point-list', [ProductController::class, 'pickup_point_list']);

Route::post('logout', [UserController::class, 'logout']);

});






