<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AdminController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\InstallerController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\DBUpdateController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\OrderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('admin.login');
});
Route::view('login', 'admin.login')->name('admin.login');
Route::post('/login', [LoginController::class, 'login'])->name('loginprocess');
 //Route::group(['prefix'=>'admin'],function(){

Route::group(['middleware'=>'admin.auth'],function(){
Route::match(['get','post'],'profile',[LoginController::class,'profile'])->name('profile');
Route::match(['get','post'],'update-profile',[LoginController::class,'update_profile'])->name('update_profile');
Route::match(['get','post'],'index',[AdminController::class,'index'])->name('index');
Route::match(['get','post'],'sales-dashboard',[AdminController::class,'sales_dashboard'])->name('sales_dashboard');
Route::match(['get','post'],'company-list',[AdminController::class,'company_list'])->name('company_list');
Route::match(['get','post'],'add-company',[AdminController::class,'add_company'])->name('add_company');
Route::get('view-company/{id}',[AdminController::class,'view_company'])->name('view_company');
Route::get('edit-company/{id}',[AdminController::class,'edit_company'])->name('edit_company');
Route::post('update-company',[AdminController::class,'update_company'])->name('update_company');
Route::match(['get','post'],'save-company',[AdminController::class,'save_company'])->name('save_company');
Route::match(['get','post'],'inactive_company/{id}',[AdminController::class,'inactive_company'])->name('inactive_company');
Route::match(['get','post'],'active_company/{id}',[AdminController::class,'active_company'])->name('active_company');
Route::delete('delete-company/{id}', [AdminController::class, 'delete_company'])->name('delete_company');
Route::match(['get','post'],'view-category/{id}',[AdminController::class,'view_category'])->name('view_category');
Route::match(['get','post'],'add-subcategory',[AdminController::class,'add_subcategory'])->name('add_subcategory');
Route::match(['get','post'],'add-category',[AdminController::class,'add_category'])->name('add_category');
Route::match(['get','post'],'edit-category',[AdminController::class,'edit_category'])->name('edit_category');
Route::match(['get','post'],'edit-subcategory',[AdminController::class,'edit_subcategory'])->name('edit_subcategory');
Route::match(['get','post'],'category-list',[AdminController::class,'category_list'])->name('category_list');
Route::match(['get','post'],'add-brand',[AdminController::class,'add_brand'])->name('add_brand');
Route::match(['get','post'],'edit-brand',[AdminController::class,'edit_brand'])->name('edit_brand');
Route::match(['get','post'],'brand-list',[AdminController::class,'brand_list'])->name('brand_list');
Route::match(['get','post'],'add-unit',[AdminController::class,'add_unit'])->name('add_unit');
Route::match(['get','post'],'edit-unit',[AdminController::class,'edit_unit'])->name('edit_unit');
Route::match(['get','post'],'unit-list',[AdminController::class,'unit_list'])->name('unit_list');
Route::match(['get','post'],'add-bank',[AdminController::class,'add_bank'])->name('add_bank');
Route::match(['get','post'],'edit-bank',[AdminController::class,'edit_bank'])->name('edit_bank');
Route::match(['get','post'],'bank-list',[AdminController::class,'bank_list'])->name('bank_list');
Route::match(['get','post'],'inactive_bank/{id}',[AdminController::class,'inactive_bank'])->name('inactive_bank');
Route::match(['get','post'],'active_bank/{id}',[AdminController::class,'active_bank'])->name('active_bank');
Route::delete('delete-bank/{id}', [AdminController::class, 'delete_bank'])->name('delete_bank');
Route::match(['get','post'],'brand-list',[AdminController::class,'brand_list'])->name('brand_list');
Route::match(['get','post'],'manage-stocks',[AdminController::class,'manage_stocks'])->name('manage_stocks');
Route::match(['get','post'],'stock-adjustment',[AdminController::class,'stock_adjustment'])->name('stock_adjustment');
Route::match(['get','post'],'stock-transfer',[AdminController::class,'stock_transfer'])->name('stock_transfer');
Route::match(['get','post'],'sales-list',[AdminController::class,'sales_list'])->name('sales_list');
Route::match(['get','post'],'sales-returns',[AdminController::class,'sales_returns'])->name('sales_returns');
Route::match(['get','post'],'quotation-list',[AdminController::class,'quotation_list'])->name('quotation_list');
Route::match(['get','post'],'pos',[AdminController::class,'pos'])->name('pos');
Route::match(['get','post'],'purchase-list',[AdminController::class,'purchase_list'])->name('purchase_list');
Route::match(['get','post'],'purchase-order-report',[AdminController::class,'purchase_order_report'])->name('purchase_order_report');
Route::match(['get','post'],'purchase-returns',[AdminController::class,'purchase_returns'])->name('purchase_returns');
Route::match(['get','post'],'customers',[AdminController::class,'customers'])->name('customers');
Route::match(['get','post'],'add-customer',[AdminController::class,'add_customer'])->name('add_customer');
Route::get('view-customer/{id}',[AdminController::class,'view_customer'])->name('view_customer');
Route::get('edit-customer/{id}',[AdminController::class,'edit_customer'])->name('edit_customer');
Route::post('update-customer',[AdminController::class,'update_customer'])->name('update_customer');
Route::match(['get','post'],'save-customer',[AdminController::class,'save_customer'])->name('save_customer');
Route::match(['get','post'],'inactive_customer/{id}',[AdminController::class,'inactive_customer'])->name('inactive_customer');
Route::match(['get','post'],'active_customer/{id}',[AdminController::class,'active_customer'])->name('active_customer');
Route::match(['get','post'],'add-supplier',[AdminController::class,'add_supplier'])->name('add_supplier');
Route::get('edit-supplier/{id}',[AdminController::class,'edit_supplier'])->name('edit_supplier');
Route::post('update-supplier',[AdminController::class,'update_supplier'])->name('update_supplier');
Route::match(['get','post'],'save-supplier',[AdminController::class,'save_supplier'])->name('save_supplier');
Route::match(['get','post'],'inactive_supplier/{id}',[AdminController::class,'inactive_supplier'])->name('inactive_supplier');
Route::match(['get','post'],'active_supplier/{id}',[AdminController::class,'active_supplier'])->name('active_supplier');
Route::match(['get','post'],'suppliers',[AdminController::class,'suppliers'])->name('suppliers');
Route::match(['get','post'],'transporters',[AdminController::class,'transporters'])->name('transporters');
Route::match(['get','post'],'add-transporter',[AdminController::class,'add_transporter'])->name('add_transporter');
Route::get('edit-transporter/{id}',[AdminController::class,'edit_transporter'])->name('edit_transporter');
Route::post('update-transporter',[AdminController::class,'update_transporter'])->name('update_transporter');
Route::match(['get','post'],'save-transporter',[AdminController::class,'save_transporter'])->name('save_transporter');
Route::match(['get','post'],'inactive_transporter/{id}',[AdminController::class,'inactive_transporter'])->name('inactive_transporter');
Route::match(['get','post'],'active_transporter/{id}',[AdminController::class,'active_transporter'])->name('active_transporter');
Route::match(['get','post'],'store-list',[AdminController::class,'store_list'])->name('store_list');
Route::match(['get','post'],'add-warehouse',[AdminController::class,'add_warehouse'])->name('add_warehouse');
Route::match(['get','post'],'edit-warehouse',[AdminController::class,'edit_warehouse'])->name('edit_warehouse');
Route::match(['get','post'],'inactive_warehouse/{id}',[AdminController::class,'inactive_warehouse'])->name('inactive_warehouse');
Route::match(['get','post'],'active_warehouse/{id}',[AdminController::class,'active_warehouse'])->name('active_warehouse');
Route::match(['get','post'],'warehouse',[AdminController::class,'warehouse'])->name('warehouse');
Route::match(['get','post'],'staff',[AdminController::class,'staff'])->name('staff');
Route::match(['get','post'],'add-staff',[AdminController::class,'add_staff'])->name('add_staff');
Route::match(['get','post'],'save-staff',[AdminController::class,'save_staff'])->name('save_staff');
Route::match(['get','post'],'edit-staff/{id}',[AdminController::class,'edit_staff'])->name('edit_staff');
Route::match(['get','post'],'update-staff',[AdminController::class,'update_staff'])->name('update_staff');
Route::match(['get','post'],'tailor',[AdminController::class,'tailor'])->name('tailor');
Route::match(['get','post'],'godown-manager',[AdminController::class,'godown_manager'])->name('godown_manager');
Route::match(['get','post'],'add-godown-manager',[AdminController::class,'add_godown_manager'])->name('add_godown_manager');
Route::match(['get','post'],'save-godown-manager',[AdminController::class,'save_godown_manager'])->name('save_godown_manager');
Route::match(['get','post'],'edit-godown-manager/{id}',[AdminController::class,'edit_godown_manager'])->name('edit_godown_manager');
Route::match(['get','post'],'update-godown-manager',[AdminController::class,'update_godown_manager'])->name('update_godown_manager');
Route::match(['get','post'],'accounts',[AdminController::class,'accounts'])->name('accounts');
Route::match(['get','post'],'sales-report',[AdminController::class,'sales_report'])->name('sales_report');
Route::match(['get','post'],'purchase-report',[AdminController::class,'purchase_report'])->name('purchase_report');
Route::match(['get','post'],'inventory-report',[AdminController::class,'inventory_report'])->name('inventory_report');
Route::match(['get','post'],'invoice-report',[AdminController::class,'invoice_report'])->name('invoice_report');
Route::match(['get','post'],'supplier-report',[AdminController::class,'supplier_report'])->name('supplier_report');
Route::match(['get','post'],'customer-report',[AdminController::class,'customer_report'])->name('customer_report');
Route::match(['get','post'],'expense-report',[AdminController::class,'expense_report'])->name('expense_report');
Route::match(['get','post'],'income-report',[AdminController::class,'income_report'])->name('income_report');
Route::match(['get','post'],'tax-reports',[AdminController::class,'tax_reports'])->name('tax_reports');
Route::match(['get','post'],'profit-and-loss',[AdminController::class,'profit_and_loss'])->name('profit_and_loss');
Route::match(['get','post'],'users',[AdminController::class,'users'])->name('users');
Route::match(['get','post'],'add-user',[AdminController::class,'add_user'])->name('add_user');
Route::get('edit-user/{id}',[AdminController::class,'edit_user'])->name('edit_user');
Route::delete('delete-user/{id}', [AdminController::class, 'delete_user'])->name('delete_user');
Route::delete('delete-supplier/{id}', [AdminController::class, 'delete_supplier'])->name('delete_supplier');
Route::delete('delete-staff/{id}', [AdminController::class, 'delete_staff'])->name('delete_staff');
Route::delete('delete-godown-manager/{id}', [AdminController::class, 'delete_godown_manager'])->name('delete_godown_manager');
Route::delete('delete-transporter/{id}', [AdminController::class, 'delete_transporter'])->name('delete_transporter');
Route::delete('delete-customer/{id}', [AdminController::class, 'delete_customer'])->name('delete_customer');
Route::delete('delete-warehouse/{id}', [AdminController::class, 'delete_warehouse'])->name('delete_warehouse');
Route::delete('delete-usertype/{id}', [AdminController::class, 'delete_usertype'])->name('delete_usertype');
Route::delete('delete-brand/{id}', [AdminController::class, 'delete_brand'])->name('delete_brand');
Route::delete('delete-unit/{id}', [AdminController::class, 'delete_unit'])->name('delete_unit');
Route::delete('delete-category/{id}', [AdminController::class, 'delete_category'])->name('delete_category');
Route::delete('delete-subcategory/{id}', [AdminController::class, 'delete_subcategory'])->name('delete_subcategory');
Route::post('update-user',[AdminController::class,'update_user'])->name('update_user');
Route::match(['get','post'],'usertype',[AdminController::class,'usertype'])->name('usertype');
Route::match(['get','post'],'add-usertype',[AdminController::class,'add_usertype'])->name('add_usertype');
Route::match(['get','post'],'edit-usertype',[AdminController::class,'edit_usertype'])->name('edit_usertype');
Route::match(['get','post'],'inactive_usertype/{id}',[AdminController::class,'inactive_usertype'])->name('inactive_usertype');
Route::match(['get','post'],'active_usertype/{id}',[AdminController::class,'active_usertype'])->name('active_usertype');
Route::match(['get','post'],'inactive_user/{id}',[AdminController::class,'inactive_user'])->name('inactive_user');
Route::match(['get','post'],'active_user/{id}',[AdminController::class,'active_user'])->name('active_user');
Route::match(['get','post'],'inactive_unit/{id}',[AdminController::class,'inactive_unit'])->name('inactive_unit');
Route::match(['get','post'],'active_unit/{id}',[AdminController::class,'active_unit'])->name('active_unit');
Route::match(['get','post'],'inactive_category/{id}',[AdminController::class,'inactive_category'])->name('inactive_category');
Route::match(['get','post'],'active_subcategory/{id}',[AdminController::class,'active_subcategory'])->name('active_subcategory');
Route::match(['get','post'],'inactive_subcategory/{id}',[AdminController::class,'inactive_subcategory'])->name('inactive_subcategory');
Route::match(['get','post'],'active_category/{id}',[AdminController::class,'active_category'])->name('active_category');
Route::match(['get','post'],'inactive_brand/{id}',[AdminController::class,'inactive_brand'])->name('inactive_brand');
Route::match(['get','post'],'active_brand/{id}',[AdminController::class,'active_brand'])->name('active_brand');
Route::match(['get','post'],'roles-permissions',[AdminController::class,'roles_permissions'])->name('roles_permissions');
Route::get('get-customerdetails/{id}', [ProductController::class, 'get_customerdetails'])->name('get_customerdetails');
Route::post('/check-msme-customer', [AdminController::class, 'checkMsmeCustomer']);
Route::post('/check-msme-supplier', [AdminController::class, 'checkMsmeSupplier']);
Route::post('/check-msme-transporter', [AdminController::class, 'checkMsmeTransporter']);
Route::match(['get','post'],'add-brand-dynamic',[AdminController::class,'add_brand_dynamic'])->name('add_brand_dynamic');  
Route::match(['get','post'],'add-unit-dynamic',[AdminController::class,'add_unit_dynamic'])->name('add_unit_dynamic');  
Route::match(['get','post'],'add-category-dynamic',[AdminController::class,'add_category_dynamic'])->name('add_category_dynamic');
Route::match(['get','post'],'add-subcategory-dynamic',[AdminController::class,'add_subcategory_dynamic'])->name('add_subcategory_dynamic');
Route::match(['get','post'],'add-installer',[AdminController::class,'add_installer'])->name('add_installer');
Route::match(['get','post'],'save-installer',[AdminController::class,'save_installer'])->name('save_installer');
Route::match(['get','post'],'edit-installer/{id}',[AdminController::class,'edit_installer'])->name('edit_installer');
Route::match(['get','post'],'update-installer',[AdminController::class,'update_installer'])->name('update_installer');
Route::delete('delete-installer/{id}', [AdminController::class, 'delete_installer'])->name('delete_installer');
Route::match(['get','post'],'inactive_installer/{id}',[AdminController::class,'inactive_installer'])->name('inactive_installer');
Route::match(['get','post'],'active_installer/{id}',[AdminController::class,'active_installer'])->name('active_installer');
Route::match(['get','post'],'inactive_staff/{id}',[AdminController::class,'inactive_staff'])->name('inactive_staff');
Route::match(['get','post'],'active_staff/{id}',[AdminController::class,'active_staff'])->name('active_staff');
Route::match(['get','post'],'inactive_godown_manager/{id}',[AdminController::class,'inactive_godown_manager'])->name('inactive_godown_manager');
Route::match(['get','post'],'active_godown_manager/{id}',[AdminController::class,'active_godown_manager'])->name('active_godown_manager');
Route::match(['get','post'],'add-staff-dynamic',[AdminController::class,'add_staff_dynamic'])->name('add_staff_dynamic');  
Route::match(['get','post'],'add-installer-dynamic',[AdminController::class,'add_installer_dynamic'])->name('add_installer_dynamic');
Route::match(['get','post'],'add-godownmanager',[AdminController::class,'add_godownmanager_dynamic'])->name('add_godownmanager');  
Route::get('/get-sales-purchase-data', [AdminController::class, 'getSalesPurchaseData']);
Route::match(['get','post'],'installer',[AdminController::class,'installer'])->name('installer');
Route::get('/check-gst-exists-supplier/{gst}', [AdminController::class, 'checkGSTExistssupplier']);
Route::get('/check-gst-exists-customer/{gst}', [AdminController::class, 'checkGSTExistscustomer']);
Route::get('/check-gst-exists-transporter/{gst}', [AdminController::class, 'checkGSTExiststransporter']);
Route::match(['get','post'],'coupons',[AdminController::class,'coupons'])->name('coupons');
Route::match(['get','post'],'dataset',[AdminController::class,'dataset'])->name('dataset');
Route::match(['get','post'],'add-coupon',[AdminController::class,'add_coupon'])->name('add_coupon');
Route::match(['get','post'],'save-coupon',[AdminController::class,'save_coupon'])->name('save_coupon');
Route::get('edit-coupon/{id}',[AdminController::class,'edit_coupon'])->name('edit_coupon');
Route::post('update-coupon',[AdminController::class,'update_coupon'])->name('update_coupon');
Route::match(['get','post'],'inactive_coupon/{id}',[AdminController::class,'inactive_coupon'])->name('inactive_coupon');
Route::match(['get','post'],'active_coupon/{id}',[AdminController::class,'active_coupon'])->name('active_coupon');
Route::delete('delete-coupon/{id}', [AdminController::class, 'delete_coupon'])->name('delete_coupon');
Route::match(['get','post'],'add-customer-dynamic',[AdminController::class,'add_customer_dynamic'])->name('add_customer_dynamic');  
Route::post('/check-email-exists', [AdminController::class, 'checkEmailExists'])->name('check_email_exists');
Route::post('/check-usertype-exists', [AdminController::class, 'checkUsertypeExists'])->name('check_usertype_exists');
Route::post('/check-category-exists', [AdminController::class, 'checkCategoryExists'])->name('check_category_exists');
Route::post('/check-brand-exists', [AdminController::class, 'checkBrandExists'])->name('check_brand_exists');
Route::post('/check-unit-exists', [AdminController::class, 'checkUnitExists'])->name('check_unit_exists');
Route::post('/check-customeremail-exists', [AdminController::class, 'checkCustomeremailExists'])->name('check_customeremail_exists');
Route::post('/check-company-exists', [AdminController::class, 'checkCompanyExists'])->name('check_company_exists');
Route::post('/check-coupon-exists', [AdminController::class, 'checkCouponExists'])->name('check_coupon_exists');
Route::post('/check-supplier-exists', [AdminController::class, 'checkSupplierExists'])->name('check_supplier_exists');
Route::post('/check-warehouse-exists', [AdminController::class, 'checkWarehouseExists'])->name('check_warehouse_exists');
Route::post('/check-transporter-exists', [AdminController::class, 'checkTransporterExists'])->name('check_transporter_exists');
Route::post('/check-installer-exists', [AdminController::class, 'checkInstallerExists'])->name('check_installer_exists');
Route::post('/check-staff-exists', [AdminController::class, 'checkStaffExists'])->name('check_staff_exists');
Route::post('/check-gmanager-exists', [AdminController::class, 'checkGmngrExists'])->name('check_gmanager_exists');
Route::match(['get','post'],'change-password',[AdminController::class,'change_password'])->name('change_password');
Route::match(['get','post'],'update-password',[AdminController::class,'update_password'])->name('update_password');
Route::post('/check-msme-company', [AdminController::class, 'checkMsmeCompany']);
Route::get('/check-gst-exists-company/{gst}', [AdminController::class, 'checkGSTExistscompany']);
Route::match(['get','post'],'add-transporter-dynamic',[AdminController::class,'add_transporter_dynamic'])->name('add_transporter_dynamic');  
Route::match(['get','post'],'add-supplier-dynamic',[AdminController::class,'add_supplier_dynamic'])->name('add_supplier_dynamic');  

Route::post('logout',[LoginController::class,'logout'])->name('logout');

//products 
Route::get('edit-product/{id}',[ProductController::class,'edit_product'])->name('edit_product');
Route::get('get-images/{id}',[ProductController::class,'getImages'])->name('getImages');
Route::match(['get','post'],'view-product-details/{id}',[ProductController::class,'view_product_details'])->name('view_product_details');
Route::match(['get','post'],'product-details',[ProductController::class,'product_details'])->name('product_details');
Route::match(['get','post'],'add-product',[ProductController::class,'add_product'])->name('add_product');
Route::match(['get','post'],'store-product',[ProductController::class,'store_product'])->name('store_product');
Route::match(['get','post'],'update-product',[ProductController::class,'update_product'])->name('update_product');
Route::match(['get','post'],'expired_products',[ProductController::class,'expired_products'])->name('expired_products');
Route::match(['get','post'],'low_stocks',[ProductController::class,'low_stocks'])->name('low_stocks');
Route::delete('delete-product/{id}', [ProductController::class, 'delete_product'])->name('delete_product');
Route::match(['get','post'],'product-list',[ProductController::class,'product_list'])->name('product_list');
Route::get('get-subcategories/{category_id}', [ProductController::class, 'getSubcategories']);
Route::match(['get','post'],'inactive_product/{id}',[ProductController::class,'inactive_product'])->name('inactive_product');
Route::match(['get','post'],'active_product/{id}',[ProductController::class,'active_product'])->name('active_product');
Route::match(['get','post'],'product-varient',[ProductController::class,'product_varient'])->name('product_varient');
Route::match(['get','post'],'add-product-varient',[ProductController::class,'add_product_varient'])->name('add_product_varient');
Route::get('edit-product-varient/{id}',[ProductController::class,'edit_product_varient'])->name('edit_product_varient');
Route::match(['get','post'],'store-product-varient',[ProductController::class,'store_product_varient'])->name('store_product_varient');
Route::match(['get','post'],'inactive_product_varient/{id}',[ProductController::class,'inactive_product_varient'])->name('inactive_product_varient');
Route::match(['get','post'],'active_product_varient/{id}',[ProductController::class,'active_product_varient'])->name('active_product_varient');
Route::delete('delete-product-varient/{id}', [ProductController::class, 'delete_product_varient'])->name('delete_product_varient');
Route::get('/convert-unit-inward', [ProductController::class, 'convertunit_inward'])->name('convertunit_inward');
Route::match(['get','post'],'update-product-varient',[ProductController::class,'update_product_varient'])->name('update_product_varient');
Route::get('/convert-unit', [ProductController::class, 'convertunit'])->name('convertunit');
Route::post('/check-product-code', [ProductController::class, 'checkProductCode'])->name('check.product.code');
Route::post('/update-order-installer', [ProductController::class, 'update_order_installer'])->name('update_order_installer');
Route::get('/get-variants-by-product', [ProductController::class, 'getVariantsByProduct']);
Route::get('/get-products-by-company', [ProductController::class, 'getProductsByCompany']);
Route::match(['get','post'],'store_order_reciept',[ProductController::class,'store_order_reciept'])->name('store_order_reciept');
Route::get('/get-order-details', [ProductController::class, 'getOrderDetails']);
Route::match(['get','post'],'update_order_reciept',[ProductController::class,'update_order_reciept'])->name('update_order_reciept');
Route::get('/generate-order-receipt/{id}', [ProductController::class, 'generate_orderreceipt'])->name('generate_orderreceipt');
Route::get('/get-variant-details', [ProductController::class, 'getVariantDetails'])->name('getVariantDetails');
Route::get('/get-variant-details-order', [ProductController::class, 'getVariantDetailsorder'])->name('getVariantDetailsorder');
Route::get('/get-variants-by-company', [ProductController::class, 'getVariantsByCompany']);
Route::get('/get-products-by-company', [ProductController::class, 'getProductsByCompany']);
Route::get('/get-variants-by-supplier', [ProductController::class, 'getVariantsBySupplier']);
Route::match(['get','post'],'orders',[ProductController::class,'orders'])->name('orders');
Route::get('view-order/{id}', [ProductController::class, 'view_order']);
Route::post('assign-transporter/', [ProductController::class, 'assign_transporter']);
Route::match(['get','post'],'/order/change-status', [ProductController::class, 'changeStatus'])->name('order.changeStatus');
Route::get('/get-variants/{product_id}', function ($productId) {
    $variants = DB::table('product_variant')
        ->where('product_id', $productId)
        ->whereNull('deleted_at')
        ->get();
    return response()->json($variants);
});






Route::match(['get','post'],'view-purchase-orders/{id}',[InventoryController::class,'view_purchase_orders'])->name('view_purchase_orders');
Route::match(['get','post'],'purchase-orders',[InventoryController::class,'purchase_orders'])->name('purchase_orders');
Route::match(['get','post'],'add-purchase-order',[InventoryController::class,'add_purchase_order'])->name('add_purchase_order');
Route::match(['get','post'],'save-purchase-order',[InventoryController::class,'save_purchase_order'])->name('save_purchase_order');
Route::get('preview-purchase-order/{id}',[InventoryController::class,'preview_purchase_order'])->name('preview_purchase_order');
Route::get('edit-purchase-order/{id}',[InventoryController::class,'edit_purchase_order'])->name('edit_purchase_order');
Route::match(['get','post'],'update-purchase-order',[InventoryController::class,'update_purchase_order'])->name('update_purchase_order');
Route::get('/get-rolls-data/{inward_id}', [InventoryController::class, 'getRollsData']);
Route::get('/get-order-data/{inward_id}/{varient}', [InventoryController::class, 'getOrderData']);
Route::post('/change-roll-status', [InventoryController::class, 'change_roll_status']);
Route::match(['get','post'],'store-category-ajax',[InventoryController::class,'store_category_ajax'])->name('store_category_ajax');
Route::match(['get','post'],'store-product-ajax',[InventoryController::class,'store_product_ajax'])->name('store_product_ajax');
Route::match(['get','post'],'store-product-varient-ajax',[InventoryController::class,'store_product_varient_ajax'])->name('store_product_varient_ajax');
Route::match(['get','post'],'inwards',[InventoryController::class,'inwards'])->name('inwards');
Route::match(['get','post'],'add-inward',[InventoryController::class,'add_inward'])->name('add_inward');
Route::match(['get','post'],'save-inward',[InventoryController::class,'save_inward'])->name('save_inward');
Route::match(['get','post'],'edit-inward/{id}',[InventoryController::class,'edit_inward'])->name('edit_inward');
Route::match(['get','post'],'update-inward',[InventoryController::class,'update_inward'])->name('update_inward');
Route::match(['get','post'],'view-inward/{id}',[InventoryController::class,'view_inward'])->name('view_inward');
Route::delete('delete-inward/{id}', [InventoryController::class, 'delete_inward'])->name('delete_inward');
Route::match(['get','post'],'view-all-inwards/{id}',[InventoryController::class,'view_all_inwards'])->name('view_all_inwards');
Route::get('/get-inward-details/{id}', [InventoryController::class, 'getInwardJson']);
Route::post('/update-inward/{id}', [InventoryController::class, 'updateinward']);
Route::post('get-po-details', [InventoryController::class, 'getPoDetails']);
Route::get('/view-purchase-order-details/{id}', [InventoryController::class, 'view_purchase_order_details'])->name('view-purchase-order-details');
Route::post('/store-warehouse-ajax', [InventoryController::class, 'store_warehouse_ajax'])->name('store_warehouse_ajax');
Route::get('/get-variant-warehouses', [InventoryController::class, 'getVariantWarehouses'])->name('getVariantWarehouses');
Route::get('/get-variant-warehouse-availability', [InventoryController::class, 'getVariantWarehouseAvailability'])->name('getVariantWarehouseAvailability');
Route::get('/get-products/{categoryId}', [InventoryController::class, 'getProductsByCategory']);
Route::get('/get-product-varient/{productId}', [InventoryController::class, 'getProductsVarient']);
Route::get('/get-warehouse/{companyId}', [InventoryController::class, 'getWarehouse']);
Route::get('/get-variants-by-product-report/{id}', [InventoryController::class, 'getVariantsByProduct']);
Route::get('/get-products-by-supplier-report/{id}', [InventoryController::class, 'getProductsBySupplierreportsection']);

Route::delete('delete-purchase-order/{id}', [InventoryController::class, 'delete_purchase_order'])->name('delete_purchase_order');
Route::get('/stock-report', [InventoryController::class, 'stock_report'])->name('stock_report');
Route::get('/stocks', [InventoryController::class, 'stocks'])->name('stocks');
Route::get('/check-availability/{variantId}', [InventoryController::class, 'checkAvailability']);
Route::get('/get-rolls-by-variant-warehouse', [InventoryController::class, 'getRollsByVariantWarehouse'])->name('getRollsByVariantWarehouse');
Route::match(['get','post'],'view-inward-data/{id}',[InventoryController::class,'view_inward_data'])->name('view_inward_data');
Route::get('/get-products-by-supplier/{id}', [InventoryController::class, 'getProductsBySupplier']);
Route::get('/purchase-order/download/{id}', [InventoryController::class,'download_po'])->name('purchase_order.download');
Route::get('/get-variants-by-product-po', [InventoryController::class, 'getVariantsByProductPo']);
Route::get('/get-roll-details', [InventoryController::class, 'getRollDetails']);






//roll cutting
Route::get('/get-order-mapping_rolls-admin/{order_id}', [OrderController::class, 'getRollsmappingadmin']);
Route::post('/update-roll-status-admin', [OrderController::class, 'updateRollStatusadmin'])->name('update-roll-status-admin');
Route::post('/cut-all-rolls-admin', [OrderController::class, 'cutAllRollsAdmin']);
//orders
Route::get('/add-new-order', [OrderController::class, 'add_new_order']);
Route::post('/save-new-order', [OrderController::class, 'save_new_order'])->name('save_new_order');
Route::get('edit-new-order/{id}', [OrderController::class, 'edit_new_order']);
Route::post('/update-new-order', [OrderController::class, 'update_new_order'])->name('update_new_order');
Route::post('/orders/{id}/cancel', [OrderController::class, 'cancel_order'])->name('orders.cancel');
Route::match(['get','post'],'orders',[OrderController::class,'orders'])->name('orders');
Route::get('view-order/{id}', [OrderController::class, 'view_order'])->name('view_order');
Route::match(['get','post'],'/order/change-status', [OrderController::class, 'changeStatus'])->name('order.changeStatus');
Route::match(['get','post'],'store_order_reciept',[OrderController::class,'store_order_reciept'])->name('store_order_reciept');
Route::match(['get','post'],'update_order_reciept',[OrderController::class,'update_order_reciept'])->name('update_order_reciept');
Route::get('/generate-order-receipt/{id}', [OrderController::class, 'generate_orderreceipt'])->name('generate_orderreceipt');
Route::get('/get-order-details', [OrderController::class, 'getOrderDetails']);
Route::get('/generate-taxinvoice/{id}', [OrderController::class, 'generate_taxinvoice']);
Route::post('/save-taxinvoice', [OrderController::class, 'save_taxinvoice'])->name('save_taxinvoice');
//refund
Route::post('/orders/process-refund', [OrderController::class, 'process_refund']);

// Reports Routes
Route::match(['get','post'],'bill-report',[ReportController::class,'billNotUpdated'])->name('bill_report');
Route::match(['get','post'],'bill-report-pdf',[ReportController::class,'billNotUpdatedpdf'])->name('bill_report_pdf');
Route::match(['get','post'],'credit-report',[ReportController::class,'creditReport'])->name('credit_report');
Route::match(['get','post'],'credit-report-pdf',[ReportController::class,'creditReportpdf'])->name('credit_report_pdf');
Route::match(['get','post'],'customer-receipt',[ReportController::class,'customerReceiptDetails'])->name('customer_receipt');
Route::match(['get','post'],'customer-receipt-pdf',[ReportController::class,'customerReceiptDetailspdf'])->name('customer_receipt_pdf');
Route::match(['get','post'],'day-sales',[ReportController::class,'daySales'])->name('day_sales');
Route::match(['get','post'],'day-sales-pdf',[ReportController::class,'daySalespdf'])->name('day_sales_pdf');
Route::match(['get','post'],'inv-sales',[ReportController::class,'invSales'])->name('inv_sales');
Route::match(['get','post'],'inv-sales-pdf',[ReportController::class,'invSalespdf'])->name('inv_sales_pdf');
Route::match(['get','post'],'labour-workdowns',[ReportController::class,'labourWorkdowns'])->name('labour_workdowns');
Route::match(['get','post'],'labour-workdowns-pdf',[ReportController::class,'labourWorkdownspdf'])->name('labour_workdowns_pdf');
Route::match(['get','post'],'product-supplier',[ReportController::class,'productSupplier'])->name('product_supplier');
Route::match(['get','post'],'product-supplier-pdf',[ReportController::class,'productSupplierpdf'])->name('product_supplier_pdf');
Route::match(['get','post'],'reserved-stocks',[ReportController::class,'reservedStocks'])->name('reserved_stocks');
Route::match(['get','post'],'reserved-stocks-pdf',[ReportController::class,'reservedStockspdf'])->name('reserved_stocks_pdf');
Route::match(['get','post'],'stock-supply',[ReportController::class,'stockSupply'])->name('stock_supply');
Route::match(['get','post'],'stock-supply-pdf',[ReportController::class,'stockSupplypdf'])->name('stock_supply_pdf');
Route::match(['get','post'],'supplier-stock-report',[ReportController::class,'supplierStockReport'])->name('supplier_stock_report');
Route::match(['get','post'],'supplier-stock-report-pdf',[ReportController::class,'supplierStockReportpdf'])->name('supplier_stock_report_pdf');
Route::match(['get','post'],'todays-cutting',[ReportController::class,'todaysCutting'])->name('todays_cutting');
Route::match(['get','post'],'todays-cutting-pdf',[ReportController::class,'todaysCuttingpdf'])->name('todays_cutting_pdf');
Route::match(['get','post'],'todays-order',[ReportController::class,'todaysOrder'])->name('todays_order');
Route::match(['get','post'],'todays-order-pdf',[ReportController::class,'todaysOrderpdf'])->name('todays_order_pdf');
Route::match(['get','post'],'todays-cash',[ReportController::class,'todaysCash'])->name('todays_cash');
Route::match(['get','post'],'todays-cash-pdf',[ReportController::class,'todaysCashpdf'])->name('todays_cash_pdf');
Route::match(['get','post'],'todays-collection',[ReportController::class,'todaysCollection'])->name('todays_collection');
Route::match(['get','post'],'todays-collection-pdf',[ReportController::class,'todaysCollectionpdf'])->name('todays_collection_pdf');
Route::match(['get','post'],'todays-inward',[ReportController::class,'todaysInward'])->name('todays_inward');
Route::match(['get','post'],'todays-inward-pdf',[ReportController::class,'todaysInwardpdf'])->name('todays_inward_pdf');
Route::match(['get','post'],'inward-invoice',[ReportController::class,'inwardInvoice'])->name('inward_invoice');
Route::match(['get','post'],'check-invoice',[ReportController::class,'checkInvoice'])->name('check_invoice');
Route::match(['get','post'],'generate-invoice',[ReportController::class,'generateInvoice'])->name('generate_invoice');

Route::get('/get-products-by-supplier/{supplierId}', [ReportController::class, 'getProductsBySupplier']);
Route::get('/get-warehouses-by-product/{productId}/{supplierId?}', [ReportController::class, 'getWarehousesByProduct']);



});



Route::group(['middleware' => 'installer.auth'], function () {
    Route::match(['get','post'],'installer/index',[InstallerController::class,'installer_index'])->name('installer.index');
    Route::get('/installer/dashboard', [InstallerController::class, 'dashboard'])->name('installer.dashboard');
    Route::get('/installer/profile', [InstallerController::class, 'profile'])->name('installer.profile');
    Route::get('/installer/orders', [InstallerController::class, 'orders'])->name('installer.orders');
    Route::match(['get','post'],'installer/update-profile',[InstallerController::class,'update_profile'])->name('installer.update_profile');
    Route::match(['get','post'],'/installer/change-password',[InstallerController::class,'change_password'])->name('installer.change_password');
    Route::match(['get','post'],'/installer/update-password',[InstallerController::class,'update_password'])->name('installer.update_password');
    Route::get('installer/view-order/{id}', [InstallerController::class, 'view_order']);
    Route::get('/get-order-mapping_rolls/{order_id}', [InstallerController::class, 'getRollsmapping']);
    Route::post('/update-roll-status', [InstallerController::class, 'updateRollStatus'])->name('update-roll-status');
    Route::post('installer-logout',[LoginController::class,'installer_logout'])->name('installer.logout');
});


Route::get('/cls', function () {    
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    session()->flush();
    return "cache cleared";
});
 
// route for update the database 
// Added by sachin darkunde
Route::get('/db-update', [DBUpdateController::class, 'db_update']);


// route for view and download the invoice the database 
// Added by sachin darkunde
Route::get('invoices',[InvoiceController::class,'index'])->name('invoices');

Route::get('view-invoice/{id}',[InvoiceController::class,'viewInvoice'])->name('view-invoice');

Route::get('download-invoice/{productId}',[InvoiceController::class,'downloadInvoice'])->name('download-invoice');




 //});
