<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>LABOUR'S WORK DONE</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            white-space: nowrap;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 16px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-row td {
            font-weight: bold;
            border-top: 2px solid black;
        }

        .double-border {
            border-top: 3px double black;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 15px;
            text-decoration: underline;
        }

        .underline {
            text-decoration: underline;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>

<header style="padding: 20px;">
    <div style="width: 30%; float: left;">
        <img src="assets/img/report_images/img.png" alt="Company Logo" height="50px" width="200px">
    </div>
    <div style="width: 70%; float: right; text-align:right;">
        <b>
            XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324
        </b>
    </div>
</header>

<section>
    <div style="">
        <p><?php echo e(date('Y-m-d')); ?></p>
        <h2 class="underline text-center">LABOUR'S WORK DONE</h2>
    </div>
    <?php
    $total = 0;
    ?>
    <?php $__currentLoopData = $workdowns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workdown): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    
    <div><p class="section-title"><?php echo e($workdown['labour']); ?></p></div>

    <table>
        <tr>
            <th>Order No</th>
            <th>Date</th>
            <th>Customer Name</th>
            <th>Quantity</th>
            <th>Labour</th>
            <th>Status</th>
        </tr>
        <?php $__currentLoopData = $workdown['workdown_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $total += $item->roll_price;
        ?>
        <tr>
            <td><?php echo e($item->order_id); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($item->updated_at)->format('Y-m-d')); ?></td>
            <td><?php echo e($item->customer_name); ?></td>
            <td><?php echo e($item->used_quantity); ?></td>
            <td><?php echo e($item->roll_price?$item->roll_price:0); ?></td>
            <td><?php echo e($item->installer_status); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr class="total-row">
            <td colspan="4"><b><?php echo e($workdown['labour']); ?></b></td>
            <td>
                <span class="double-border"><?php echo e($total); ?></span>
            </td>
        
            <td></td>
        </tr>
    </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</section>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/labourworkdowns.blade.php ENDPATH**/ ?>