<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
			
			<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Brand</h4>
								<h6>Manage your brands</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="#" class="btn btn-added" data-bs-toggle="modal" data-bs-target="#add-brand"><i data-feather="plus-circle" class="me-2"></i>Add New Brand</a>
						</div>
					</div>

					<?php if(session()->has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session()->has('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session()->get('error')); ?>

                </div>
            <?php endif; ?>

					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<a class="btn btn-filter" id="filter_search">
										<i data-feather="filter" class="filter-icon"></i>
										<span><img src="assets/img/icons/closes.svg" alt="img"></span>
									</a>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div>-->
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select">
													<option>Choose Brand</option>
													<option>Lenevo</option>
													<option>Boat</option>
													<option>Nike</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="calendar" class="info-img"></i>
												<div class="input-groupicon">
													<input type="text" class="datetimepicker" placeholder="Choose Date" >
												</div>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="stop-circle" class="info-img"></i>
												<select class="select">
													<option>Choose Status</option>
													<option>Active</option>
													<option>Inactive</option>
												</select>
											</div>
										</div>
										<div class="col-lg-3 col-sm-6 col-12 ms-auto">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive">
								<table class="table  datanew">
									<thead>
										<tr>
											<th class="no-sort">Action</th>
											<th>Brand</th>
											<th>Logo</th>
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="action-table-data">
												<div class="edit-delete-action">
													<a class="me-2 p-2" href="#" data-bs-toggle="modal" data-bs-target="#edit-brand" onclick="editBrand(<?php echo e($row->id); ?>, '<?php echo e($row->brand_name); ?>', '<?php echo e($row->status); ?>')">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
												
											</td>
											<td><?php echo e($row->brand_name); ?></td>
											<td><span class="d-flex"><img src="<?php echo e(url('uploads/brand/'.$row->brand_logo)); ?>" alt="brandlogo" style="height:50px;width:100px" onerror="this.onerror=null;this.src='<?php echo e(url('uploads/images.jpeg')); ?>';"></span></td>
											<td><?php if($row->status==1): ?><a href="<?php echo e(url('inactive_brand/'.$row->id)); ?>"><span class="badge badge-linesuccess">Active</span></a><?php else: ?>
                                                <a href="<?php echo e(url('active_brand/'.$row->id)); ?>"><span class="badge badge-linedanger">Inactive</span></a>
                                            <?php endif; ?></td>
											
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			</div>
			<!-- /Main Wrapper -->

			<!-- Add Brand -->
			<div class="modal fade" id="add-brand">
				<div class="modal-dialog modal-dialog-centered custom-modal-two">
					<div class="modal-content">
						<div class="page-wrapper-new p-0">
							<div class="content">
								<div class="modal-header border-0 custom-modal-header">
									<div class="page-title">
										<h4>Add Brand</h4>
									</div>
									<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									</button>
								</div>
								<div class="modal-body custom-modal-body new-employee-field">
									<form action="<?php echo e(route('add_brand')); ?>" id="myForm" method="post" enctype="multipart/form-data">
										<?php echo csrf_field(); ?>
										<div class="mb-3">
											<label class="form-label">Brand</label>
											<input type="text" name="name" id="brand" class="form-control"><small id="brand-error" style="color: red; display: none;">This brand is already registered!</small>
										</div>
										<div class="mb-3">
											<label class="form-label">Logo</label>
											<input type="file" name="logo" class="form-control">
										</div>
										<div class="mb-3">
											<label class="form-label">Status</label>
										<select class="form-control" name="status" required>
											<option value="">Choose</option>
											<option value="1">Active</option>
											<option value="0">Inactive</option>
										</select>
									</div>
										
										<div class="modal-footer-btn">
											<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
											<button type="submit" id="submitBtn" class="btn btn-submit">Save</button><p id="message" style="color: red;">
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- /Add Brand -->

			<!-- Edit Brand -->
			<div class="modal fade" id="edit-brand">
				<div class="modal-dialog modal-dialog-centered custom-modal-two">
					<div class="modal-content">
						<div class="page-wrapper-new p-0">
							<div class="content">
								<div class="modal-header border-0 custom-modal-header">
									<div class="page-title">
										<h4>Edit Brand</h4>
									</div>
									<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									</button>
								</div>
								<div class="modal-body custom-modal-body new-employee-field">
									<form action="<?php echo e(route('edit_brand')); ?>" method="post" enctype="multipart/form-data">
										<?php echo csrf_field(); ?>
										<input type="hidden" id="edit-id" name="id">
										<div class="mb-3">
											<label class="form-label">Brand</label>
											<input type="text" name="name" id="edit-name" class="form-control">
										</div>

										<div class="mb-3">
											<label class="form-label">Logo</label>
											<input type="file" name="logo" id="edit-logo" class="form-control">
										</div>
										<div class="mb-3">
											<label class="form-label">Status</label>
										<select class="form-control" id="edit-status" name="status" required>
											<option value="">Choose</option>
											<option value="1">Active</option>
											<option value="0">Inactive</option>
										</select>
									</div>
										
										<div class="modal-footer-btn">
											<button type="button" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</button>
											<button type="submit" class="btn btn-submit">Save Changes</button>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		
        <script>
            function editBrand(id, name, status) {
                // Set the values in the modal form
                document.getElementById('edit-id').value = id;
                document.getElementById('edit-name').value = name;
                
                console.log("Editing User Type:", { id, name, status });  // Debugging line
        
                // Set the selected status
                var statusSelect = document.getElementById('edit-status');
                statusSelect.value = status; 
                
                // Debugging: Log selected value
                console.log("Status Select Value:", statusSelect.value);  // Debugging line
                
                // Ensure that the correct option is selected
                Array.from(statusSelect.options).forEach(function(option) {
                    console.log("Option Value:", option.value);  // Debugging line
                    if (option.value == status) {
                        option.selected = true;
                    }
                });
            }
        



	$(document).ready(function () {

		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
        });

		$(document).on('click', '.delete-action', function (e) {
			
            e.preventDefault();
            var userId = $(this).data('id');
			
            var deleteUrl = "<?php echo e(url('delete-brand')); ?>/" + userId;

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({

						
                        url: deleteUrl,
                        method: 'DELETE',
                        success: function (response) {
                            Swal.fire(
                                'Deleted!',
                                'Brand has been deleted.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr, status, error) {
                            Swal.fire(
                                'Error!',
                                'There was a problem deleting the user.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
        
        
              $("#brand").on("keyup blur", function (e) { 
        let brand = $(this).val();
       
            $.ajax({
                url: "<?php echo e(route('check_brand_exists')); ?>",
                type: "POST",
                data: {
                    brand: brand,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#brand-error").show(); 
                        $("#brand").addClass("error-field"); 
                        $("#brand").focus(); 
                        $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This brand is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#brand-error").hide(); 
                        $("#brand").removeClass("error-field"); 
                    }
                }
            });
             $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#brand").on("keydown", function (e) {
        if (e.key === "Tab" && $("#brand-error").is(":visible")) {
            e.preventDefault(); 
        }
    });

    });
    
     document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); 
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
</script>
			<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/brand-list.blade.php ENDPATH**/ ?>