<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Day Sales</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: Arial, sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border: 2px solid black;
            page-break-inside: auto;
        }

        th, td {
            border: 1px solid black;
            padding: 8px;
            font-size: 16px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
            border-bottom: 2px solid black;
        }

        .total-row td {
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
        }

        .grand-total td {
            text-decoration: underline;
            text-decoration-style: double;
            text-underline-offset: 5px;
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
            border-bottom: 2px solid black;
        }

        tr, td, th {
            page-break-inside: avoid;
        }

        tr.total-row td[colspan], tr.grand-total td[colspan] {
            border-right: 1px solid black;
            border-left: 1px solid black;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .header div {
            text-align: right;
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

    </style>
</head>
<body>

<header class="header">
    <img src="assets/img/report_images/img.png" alt="Logo">
    <div>
        <b>XYZ Trading Pvt Ltd.</b> <br>
        33/2 Rayna Building, Balewadi <br>
        GST NO: 98751324680881324
    </div>
</header>

<h2 class="section-title">Daily Sales Report</h2>
<b><?php echo e(date('d-M-Y')); ?></b>

<section style="margin-top: 25px;">
    <table>
        <thead>
            <tr>
                <th>Order No</th>
                <th>Customer Name</th>
                <th>Amount</th>
                <th>Bill No</th>
                <th>Bank</th>
                <th>Remarks</th>
                <th>Cheque No</th>
                <th>Receipt Type</th>
            </tr>
        </thead>
        <tbody>
            <?php $grandTotal = 0; ?>

            <?php $__currentLoopData = $grouped_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod => $customers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="8" style="background-color: #d9edf7; font-weight: bold; text-align: center;">
                        <?php echo e(strtoupper($paymentMethod)); ?>

                    </td>
                </tr>

                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerName => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="8" style="font-weight: bold;"><?php echo e(ucfirst($customerName)); ?></td>
                    </tr>

                    <?php $customerTotal = 0; ?>
                    <?php $__currentLoopData = $details['orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($order['order_id']); ?></td>
                            <td><?php echo e(ucfirst($customerName)); ?></td>
                            <td><?php echo e(number_format(floatval(str_replace(',', '', $order['amount'])), 2)); ?></td>
                            <td><?php echo e($order['receipt_id']); ?></td>
                            <td><?php echo e($order['bank'] ?: '-'); ?></td>
                            <td><?php echo e($order['remark']); ?></td>
                            <td><?php echo e($order['cheq_no'] ?: '-'); ?></td>
                            <td><?php echo e($order['rcpt_type']); ?></td>
                        </tr>
                        <?php $customerTotal += floatval(str_replace(',', '', $order['amount'])); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <tr class="total-row">
                        <td colspan="7" style="text-align: right;"><b>Subtotal for <?php echo e(ucfirst($customerName)); ?>:</b></td>
                        <td><b><?php echo e(number_format($customerTotal, 2)); ?></b></td>
                    </tr>

                    <?php $grandTotal += $customerTotal; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr class="grand-total">
                <td colspan="7" style="text-align: right;"><b>Grand Total:</b></td>
                <td><b><?php echo e(number_format($grandTotal, 2)); ?></b></td>
            </tr>
        </tbody>
    </table>
</section>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/daysales.blade.php ENDPATH**/ ?>