<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
	/* Ensure that the Select2 dropdown arrow is visible and styled properly */
.select2-container .select2-selection--single .select2-selection__arrow {
    height: 100% !important;
    position: absolute !important;
    top: 0 !important;
    right: 0 !important;
    width: 20px !important; /* Adjust width if necessary */
    background-color: transparent !important;
    border-left: 1px solid #aaa !important; /* Optional: Add border for better visibility */
}

.select2-container .select2-selection__arrow b {
    border-color: #333 transparent transparent transparent !important; /* Arrow color */
    border-width: 5px 5px 0 5px !important; /* Adjust arrow size */
    border-style: solid !important;
    display: inline-block !important;
    margin-top: 5px !important;
    vertical-align: middle !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow 
{
	display: none !important;
}

</style>

		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Product Varient</h4>
						
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('product_varient')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Product Varient</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<!-- /add -->
				   <?php if(session()->has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('success')); ?>

                    </div>
					<?php endif; ?>
					<?php if(session()->has('error')): ?>
					<div class="alert alert-danger">
						<?php echo e(session()->get('error')); ?>

					</div>
				    <?php endif; ?>
				
				<div class="row">
					<div class="card">
						<div class="card-body">
				<form action="<?php echo e(route('store_product_varient')); ?>" id="myForm" method="POST" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<input type="hidden" class="form-control" value="1" name="product_id" required />
			
					<!-- Wrapping container for scrollbar -->
					<div class="productdetails" style="overflow-x: auto; white-space: nowrap; scroll-behavior: smooth; scrollbar-width: thin; display: flex; flex-direction: column; gap: 10px;">
						<div class="input-group mb-3 gap-2" id="subcategory-0" style="display: flex;">
							<div class="add-icon" style="margin-top: 18px; flex: 0 0 auto;">
								<a href="#" title="Add" class="choose-add" id="add-subcategory" style="color:white; background:green;">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
										<circle cx="12" cy="12" r="10"></circle>
										<line x1="12" y1="8" x2="12" y2="16"></line>
										<line x1="8" y1="12" x2="16" y2="12"></line>
									</svg>
								</a>
							</div>
			
							<!-- Fields container -->
							<div class="fields-container gap-2" style="display: flex; flex: 1;">
								<!-- Your form fields here -->
								<div class="form-group mb-3" style="flex: 0 0 200px;">
									<label for="varient_code">Product</label>
									<select class="form-control" name="product_id[]" id="productSelect">
										<option>Select Product</option>	
										<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($row->id); ?>"><?php echo e($row->product_name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
								<div class="form-group mb-3" style="flex: 0 0 200px;">
									<label for="varient_code">Code</label>
									<input type="text" class="form-control" name="varient_code[]" placeholder="Code" required />
								</div>
								<div class="form-group mb-3" style="flex: 0 0 200px;">
									<label for="varient_name">Name</label>
									<input type="text" class="form-control" placeholder="Name" name="varient_name[]" required />
								</div>
								<div class="form-group mb-3" style="flex: 0 0 200px;">
									<label for="varient_image">Image</label>
									<input type="file" class="form-control" name="varient_image[]" accept=".jpg,.png,.jpeg" required />
								</div>
						   
								<div class="form-group mb-3" style="flex: 0 0 200px;">
									<label for="more_image">Additional Images</label>
									<input type="file" class="form-control" name="more_image_0[]" accept=".jpg,.png,.jpeg" multiple required />
								</div>
							</div>
						</div>
						<!-- Additional rows will be added here by JavaScript -->
						<div id="additional-subcategories"></div>
					</div>
			
					<button type="submit" id="submitBtn" class="btn btn-primary mt-3">Submit</button>
				</form>
			</div>
		</div>

		
	</div>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->

	



	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	 <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> 



<script>

	$(document).on('click', '.delete-action', function (e) {
		
		e.preventDefault();
		var userId = $(this).data('id');
		
		var deleteUrl = "<?php echo e(url('delete-product-varient')); ?>/" + userId;

		Swal.fire({
			title: 'Are you sure?',
			text: "You won't be able to revert this!",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonColor: '#3085d6',
			cancelButtonColor: '#d33',
			confirmButtonText: 'Yes, delete it!'
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
					url: deleteUrl,
					method: 'DELETE',
					headers: {
					 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') 
				 },
					success: function (response) {
						Swal.fire(
							'Deleted!',
							'Product Varient has been deleted.',
							'success'
						).then(() => {
							location.reload(); 
						});
					},
					error: function (xhr, status, error) {
						Swal.fire(
							'Error!',
							'There was a problem deleting the user.',
							'error'
						);
					}
				});
			}
		});
	});

	let subcategoryCount = 0;

function addSubcategoryRow() {

		const lastSubcategoryName = $('input[name="varient_name[]"]').last().val();
		const lastSubcategoryImage = $('input[name="varient_image[]"]').last().val();
		const lastSubcategoryColor = $('input[name="varient_code[]"]').last().val();

		if (!lastSubcategoryName || !lastSubcategoryImage || !lastSubcategoryColor) {
			Swal.fire({
				title: 'Validation Error',
				text: 'Please fill in all fields before adding another.',
				icon: 'warning',
				confirmButtonText: 'Okay'
			});
			return;
		}

		subcategoryCount++;

	 var mrp = 1;

	$('#additional-subcategories').append(`
		<div class="input-group mb-3" id="subcategory-${subcategoryCount}" style="display: flex;">
			<div class="add-icon" style="margin-top: 0px; margin-right: 10px; flex: 0 0 auto;">
				<a href="#" title="Add" class="choose-add" style="color:white;background:green;">
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
						<circle cx="12" cy="12" r="10"></circle>
						<line x1="12" y1="8" x2="12" y2="16"></line>
						<line x1="8" y1="12" x2="16" y2="12"></line>
					</svg>
				</a>
			</div>
			<div class="fields-container gap-2" style="display: flex; flex: 1;">
				<div class="form-group mb-2" style="flex: 0 0 200px;">
								
									<select class="form-control" name="product_id[]" id="productSelect">
										<option>Select</option>	
										<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($row->id); ?>"><?php echo e($row->product_name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
				<div class="form-group mb-3" style="flex: 0 0 200px;">
					<input type="text" class="form-control" name="varient_code[]" placeholder="Code" required />
				</div>
				<div class="form-group mb-3" style="flex: 0 0 200px;">
					<input type="text" class="form-control" placeholder="Name" name="varient_name[]" required />
				</div>
				<div class="form-group mb-3" style="flex: 0 0 200px;">
					<input type="file" class="form-control" name="varient_image[]" accept=".jpg,.png,.jpeg" required />
				</div>
			
				<div class="form-group mb-3" style="flex: 0 0 200px;">
					<input type="file" class="form-control" name="more_image_${subcategoryCount}[]" accept=".jpg,.png,.jpeg" multiple required />
				</div>
			</div>
		</div>
	`);
	attachDiscountCalculation();
	$('.add-icon a').not(':last').replaceWith(`
		<a href="#" class="remove-subcategory" title="Remove" style="color:white;background:red;">
			<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus">
				<circle cx="12" cy="12" r="10"></circle>
				<line x1="8" y1="12" x2="16" y2="12"></line>
			</svg>
		</a>
	`);
}

$(document).on('click', '#add-subcategory, .choose-add', function(e) {
	e.preventDefault();
	addSubcategoryRow();
});

$(document).on('click', '.remove-subcategory', function(e) {
	e.preventDefault();
	$(this).closest('.input-group').remove();
});


	function attachDiscountCalculation() {
	$('.discount-input').on('input', function() {
		let discount = parseFloat($(this).val());
		let mrp = 1; 

		if (!isNaN(discount) && discount >= 0 && discount <= 100) {
			let retailPrice = mrp - (mrp * discount / 100);
			$(this).closest('.fields-container').find('.retail-price-input').val(retailPrice.toFixed(2)); 
		} else {
			$(this).closest('.fields-container').find('.retail-price-input').val(''); 
		}
	});
}


attachDiscountCalculation();


function editVarient(id, name, color,image) {
   
		$('#edit-id').val(id); 
		$('#edit-name').val(name); 
		$('#edit-color').val(color);
	
		let imageUrl = '<?php echo e(url("uploads/products/")); ?>/' + image;
		$('#edit-image').attr('src', imageUrl);

   
}


$(document).on('click', '.edit-icon', function() {
var id = $(this).data('id');  
$.ajax({
	url: '/get-images/' + id, 
	type: 'GET',
	success: function(response) {
		var imagesContainer = $('#image-gallery');
		imagesContainer.empty(); 
		
	  
		$.each(response.images, function(index, image) {
			var imgElement = '<div class="col-md-3 gallery-image-container">' +
								'<div class="gallery-image">' +
									'<img src="/uploads/products/' + image.image + '" class="img-fluid" alt="Product Image">' +
								'</div>' +
							'</div>';
			imagesContainer.append(imgElement);
		});
	},
	error: function() {
		console.error('Could not fetch images.');
	}
});
});

 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });


</script>
	<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add-product-varient.blade.php ENDPATH**/ ?>