<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todays Inward</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 5px;
            font-size: 16px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .header div {
            text-align: right;
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

        .total {
            font-weight: bold;
            text-align: right;
        }

        .total hr {
            margin: 0;
            border-top: 1px solid black;
        }

        .final-total {
            font-size: 20px;
            font-weight: bold;
            text-align: right;
        }
    </style>
</head>
<body>
    <header class="header">
        <img src="assets/img/report_images/img.png" alt="Logo">
        <div>
            <b>XYZ Trading Pvt Ltd.</b> <br>
            33/2 Rayna Building, Balewadi <br>
            GST NO: 98751324680881324
        </div>
    </header>

    <h2 class="section-title">Todays Inward</h2>
    <b><?php echo e(date('d-M-Y')); ?></b>

    <section style="margin-top: 20px;">
        <table>
            <tr>
                <th>RollNo</th>
                <th style="width: 200px;">Design No / Name</th>
                <th>InwardQty</th>
                <th>UoM</th>
                <th>CP</th>
                <th>%GST</th>
                <th>GST amt</th>
                <th>Amount</th>
                <th>No Of Rolls</th>
            </tr>

            <?php
                $grand_total_qty = 0;
                $grand_total_amount = 0;
            ?>

            <?php $__currentLoopData = $inward_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_name => $suppliers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr><td colspan="9"><b><?php echo e($company_name); ?></b></td></tr>

                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="4"><b>Supplier Invoice No: <?php echo e($supplier_data['supplier_id']); ?></b></td>
                        <td colspan="3"></td>
                            <td><b>Place</b></td>
                            <td><b><?php echo e($supplier_data['warehouse']); ?></b></td>
                    </tr>

                    <?php $__currentLoopData = $supplier_data['purchase_orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $po_id => $purchase_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   
                        <tr><td colspan="9"><b><u>TYPE <?php echo e(strtoupper($purchase_order['items'][0]['product_name'])); ?></u></b></td></tr>

                        <?php
                            $total_type_qty = 0;
                            $total_type_amount = 0;
                        ?>

                        <?php $__currentLoopData = $purchase_order['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $item['purchase_order_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $po_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $gst_amt = ($po_item->gst_percent * $po_item->rate) / 100;
                                    $amount = ($po_item->rate * $po_item->quantity) + (($po_item->gst_percent * $po_item->rate * $po_item->quantity) / 100);
                                    $total_type_qty += $po_item->quantity;
                                    $total_type_amount += $amount;
                                    $grand_total_qty += $po_item->quantity;
                                    $grand_total_amount += $amount;
                                ?>
                                <tr>
                                    <td>4</td>
                                    <td><?php echo e($po_item->varient_name); ?></td>
                                    <td><?php echo e($po_item->quantity); ?></td>
                                    <td><?php echo e($po_item->unit_name); ?></td>
                                    <td><?php echo e($po_item->rate); ?></td>
                                    <td><?php echo e($po_item->gst_percent); ?></td>
                                    <td><?php echo e(number_format($gst_amt, 2)); ?></td>
                                    <td><?php echo e(number_format($amount, 2)); ?></td>
                                    <td><?php echo e($po_item->no_of_rolls); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td colspan="2" class="total">Total Type Qty</td>
                            <td><b><?php echo e(number_format($total_type_qty, 2)); ?></b></td>
                            <td></td>
                            <td colspan="3" class="total">Total Type Amount</td>
                            <td><b><?php echo e(number_format($total_type_amount, 2)); ?></b></td>
                            <td></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr>
                <td colspan="2" class="final-total">Grand Total</td>
                <td><b><?php echo e(number_format($grand_total_qty, 2)); ?></b></td>
                <td></td>
                <td colspan="3"></td>
                <td class="final-total"><b><?php echo e(number_format($grand_total_amount, 2)); ?></b></td>
                <td></td>
            </tr>
        </table>
    </section>
</body>
</html><?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/todaysinward.blade.php ENDPATH**/ ?>