<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Receipt</title>
    <style>
  body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 0;
        }
        .receipt-container {
            max-width: 800px;
            margin: auto;
            padding: 20px;
            border: 1px solid #ddd;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0;
        }
        .logo img {
            max-height: 60px;
            max-width: 150px;
            float: right;
            margin-top:-20px;
        }
        .company-receipt {
            width: 100%;
            margin-bottom: 20px;
        }
        .company-info {
            text-align: left;
            width: 50%;
        }
        .receipt-info {
          float:right;
            width: 50%;
            margin-right: -90px;
            margin-top: -130px;
        }
        .bill-ship-info, .order-summary, .payment-details {
            margin-bottom: 20px;
        }
        .info-table {
            width: 100%;
           
        }
        .info-table td {
            padding: 5px;
            vertical-align: top;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid #ddd;
            text-align: left;
            padding: 8px;
        }
      
        .total {
            font-weight: bold;
            text-align: right;
        }  
        .info-table {
        width: 100%;
        border: none;
    }

    .info-table td {
        border: none; 
        padding: 5px; 
        vertical-align: top;
    }

        
        </style>
</head>
<body>
    <div class="receipt-container">
        <div class="header">
            <h2>RECEIPT</h2>
            <div class="logo">
                <img src="assets/img/logo.png" alt="Company Logo">
            </div>
        </div>

        <div class="company-details">
            <div class="company-info">
                <h3>Kukreja Interiors</h3>
                <p>A-45, R Quarters, Near Sai Chowk, Pimpri Pune 411017</p>
                <p>9665065522 /25 /34 | kukreja_interiors@yahoo.com</p>
            </div>
            <div class="receipt-info">
                <p><strong>Receipt No:</strong> <?php echo e($ord_details['receipt_id']); ?></p>
                <p><strong>Payment Date:</strong> <?php echo e($ord_details['order_date']); ?></p>
            </div>
        </div>

        <div class="bill-ship-info">
            <h3>Bill To:</h3>
            <table class="info-table" >
                <tr>
                    <td><strong>Customer Name:</strong><?php echo e($ord_details['customer_name']); ?></td>
                    <td><strong>Ship To:</strong> <?php echo e($ord_details['shipping_address']); ?></td>
                </tr>
                <tr>
                    <!--<td><strong>Address:</strong> <?php echo e($ord_details['customer_address']); ?></td>-->
                    <td><strong>Phone:</strong> <?php echo e($ord_details['customer_mobile']); ?></td>
                </tr>
                <tr>
                    <td><strong>Email:</strong> <?php echo e($ord_details['customer_email']); ?></td>
                </tr>
            </table>
        </div>

        <div class="order-summary">
            <h3>Order Summary</h3>
            <table>
                <tr style="background:#9E00D7;color:white">
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Total</th>
                </tr>
                <?php $__currentLoopData = $ord_details['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->varient_name); ?></td>
                    <td><?php echo e($item->quantity); ?></td>
                    <td><?php echo e(number_format($item->price, 2)); ?></td>
                    <td><?php echo e(number_format($item->quantity * $item->price, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <?php if($ord_details['discount'] > 1): ?>
                 <tr>
                    <td colspan="3" class="total"><strong>Coupon Discount</strong></td>
                    <td><strong><?php echo e(number_format($ord_details['discount'] , 2)); ?></strong></td>
                </tr>
                <?php endif; ?>
                 <?php if($ord_details['customer_discount_amount'] > 1): ?>
                 <tr>
                    <td colspan="3" class="total"><strong>Special Discount</strong></td>
                    <td><strong><?php echo e(number_format($ord_details['customer_discount_amount'] , 2)); ?></strong></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td colspan="3" class="total"><strong>Grand Total</strong></td>
                    <td><strong><?php echo e(number_format($ord_details['grandtotal'] , 2)); ?></strong></td>
                </tr>
            </table>
        </div>

        <div class="payment-details">
            <h3>Payment Details</h3>
            <p><strong>Payment Method:</strong> <?php echo e($ord_details['payment_method']); ?></p>
            <?php if($ord_details['payment_method'] == 'Online'): ?>
            <p><strong>Bank Name:</strong> <?php echo e($ord_details['bank_name'] ?? ''); ?></p>
            <p><strong>Account Number:</strong> <?php echo e($ord_details['account_number'] ?? ''); ?></p>
            <p><strong>Transaction ID:</strong> <?php echo e($ord_details['reference_id'] ?? ''); ?></p>
            <?php elseif($ord_details['payment_method']  == 'Cheque'): ?>
            <p><strong>Cheque Number:</strong> <?php echo e($ord_details['cheque_number'] ?? ''); ?></p>
            <?php endif; ?>
          
        </div>

        <div class="remarks">
            <h3>Remark</h3>
            <p><?php echo e($ord_details['remark']); ?></p>
        </div>

        
    </div>
</body>
</html>

<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/order-receipt-pdf.blade.php ENDPATH**/ ?>