<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
			
			<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Orders</h4>
								<h6>Manage your orders</h6>
							</div>
						</div>
						
						<div class="page-btn">

						</div>
					</div>

					<?php if(session()->has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('success')); ?>

                    </div>
                    <?php endif; ?>
                <?php if(session()->has('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session()->get('error')); ?>

                </div>
            <?php endif; ?>

					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								 
								<!--<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>Newest</option>
										<option>Oldest</option>
									</select>
								</div>--> 
							</div>
								<!-- /Filter -->
								<div class="card mb-0" id="filter_inputs">
									<div class="card-body pb-0">
										<div class="row">
											<div class="col-lg-12 col-sm-12">
												<div class="row">
													<div class="col-lg-2 col-sm-6 col-12">
													</div>
													<div class="col-lg-1 col-sm-6 col-12">
													</div>
											
													<!-- Supplier Select -->
													<div class="col-lg-3 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="supplier_id">Customer</label>
															<i data-feather="git-merge" class="info-img" style="margin-top: 14px;"></i>
															
															<select class="select" name="customer_id" id="customer_id">
																<option value="">Choose Customer</option>
																<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($row->id); ?>"><?php echo e($row->customer_name); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													</div>
											
													<!-- Start Date -->
													<div class="col-lg-2 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="start_date">Start Date</label>
															<i data-feather="calendar" class="info-img" style="margin-top: 14px;"></i>
															<input type="date" class="form-control" id="start_date" placeholder="Start Date" name="start_date">
														</div>
													</div>
											
													<!-- End Date -->
													<div class="col-lg-2 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="end_date">End Date</label>
															<i data-feather="calendar" class="info-img" style="margin-top: 14px;"></i>
															<input type="date" class="form-control" id="end_date" placeholder="End Date" name="end_date">
														</div>
													</div>
											
													
												</div>
											</div>
											
										</div>
									</div>
								</div>
								<!-- /Filter -->
							<div class="table-responsive " id="ordersTable">
								<table class="table  datanew">
									<thead>
										<tr>
											<th class="no-sort">Action</th>
											<th>Order Id</th>
											<th>Customer</th>
                                            <th>Order Date</th>
											<th>Order Total</th>
											<th>Order Status</th>
											
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="action-table-data">
												
                                             


                                                <a href="<?php echo e(url('installer/view-order/'.$row->id)); ?>"  title="View Order"><i data-feather="eye" class="feather-eye"></i></a>
                                            </td>
											<td><a href="javascript:void(0);" class="expand-row" data-id="<?php echo e($row->id); ?>"><?php echo e($row->order_code); ?></a></td>
											<td><?php echo e($row->customer_name); ?></td>
											<td><?php echo e(date('d M Y', strtotime($row->order_date))); ?></td>
											<td><?php echo e($row->grandtotal); ?></td>
											<td> <span class="badge <?php echo e($row->status == 'Completed' ? 'badge-bgsuccess' : 'badge-bgdanger'); ?>">
												<?php echo e($row->status); ?>

											</span></td>
										
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			</div>
			<!-- /Main Wrapper -->


			

			<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

			<script>
	$(document).ready(function() {
		function fetchFilteredOrders() {
			var customer_id = $('#customer_id').val();
			var start_date = $('#start_date').val();
			var end_date = $('#end_date').val();

			$.ajax({
				url: "<?php echo e(url('orders')); ?>",
				method: "GET",
				data: {
					customer_id: customer_id,
					start_date: start_date,
					end_date: end_date
				},
				success: function(response) {
					var tbody = $("#ordersTable tbody");
					tbody.empty();

					if (response.orders.length > 0) {
						
						$.each(response.orders, function(index, order) {
							var editUrl = `edit-new-order/${order.id}`;
							var viewUrl = `view-order/${order.id}`;

							var row = `<tr>
								<td class="action-table-data">
									<a href="${editUrl}" style="margin-right: 10px" title="Edit Order">
										<i data-feather="edit" class="feather-edit"></i>
									</a>
									<a href="${viewUrl}" title="View Order">
										<i data-feather="eye" class="feather-eye"></i>
									</a>
								</td>
								<td>${order.order_code}</td>
								<td>${order.customer_name}</td>
								<td>${new Date(order.order_date).toLocaleDateString()}</td>
								<td>${order.grandtotal}</td>
								<td>
									<span class="badge ${order.status === 'Completed' ? 'badge-bgsuccess' : 'badge-bgdanger'}">
										${order.status}
									</span>
								</td>
								<td>
									<span class="badge ${order.status === 'Paid' ? 'badge-linesuccess' : 'badge-linedanger'}">
										Pending
									</span>
								</td>
							</tr>`;

							tbody.append(row);
						});

						feather.replace(); // Re-initialize icons
					} else {
						tbody.append('<tr><td colspan="7" class="text-center">No records found.</td></tr>');
					}
				}
			});
		}

		$('#customer_id, #start_date, #end_date').on('change', function() {
			alert(1);
			fetchFilteredOrders();
		});
	});



	$(document).on('click', '.expand-row', function () {
    const parentRow = $(this).closest('tr'); 
    const itemId = $(this).data('id'); 
    
    const isExpanded = parentRow.next().hasClass('expanded-row');

    // Remove existing expanded row if already present
    $('.expanded-row').remove();

    // If not expanded, add the expanded row
    if (!isExpanded) {
        const loadingContent = `
            <tr class="expanded-row">
                <td colspan="8">
                    <div class="nested-table">
                        <table class="table datanew table-bordered" id="roll_table">
                            <thead>
                                <tr>
                                    <th>Order Code</th>
                                    <th>Customer</th>
                                    <th>Varient</th>
                                    <th>Roll</th>
                                    <th>Quantity</th>
                                    <th>Used</th>
                                    <th>Availability</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8" class="text-center">Loading data...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </td>
            </tr>
        `;

        // Insert loading row
        parentRow.after(loadingContent);

        // Fetch data from the server
        $.ajax({
            url: `/get-order-mapping_rolls/${itemId}`,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                if (Array.isArray(data) && data.length > 0) {
                    const rows = data.map(item => `
                        <tr>
                            <td>${item.order_code || 'N/A'}</td>
                            <td>${item.customer_name || 'N/A'}</td>
                            <td>${item.varient_name || 'N/A'}</td>
                            <td>${item.roll_id || 'N/A'}</td>
                            <td>${item.total_quantity || 0}</td>
                            <td>${item.used_quantity || 0}</td>
                            <td>${item.available_quantity || 0}</td>
                            <td>
                                <span class=" text-primary" 
                                      data-roll-id="${item.roll_id}"
									   data-order-id="${item.order_id}"
                                      data-status="${item.installer_status}">
                                    ${item.installer_status || 'N/A'}
                                </span>
                            </td>
                        </tr>
                    `).join('');

                    // Update the table body with fetched rows
                    parentRow.next().find('tbody').html(rows);
                } else {
                    // Display message if no data found
                    parentRow.next().find('tbody').html(`
                        <tr>
                            <td colspan="8" class="text-center">No data available</td>
                        </tr>
                    `);
                }
            },
            error: function () {
                // Display error message
                parentRow.next().find('tbody').html(`
                    <tr>
                        <td colspan="8" class="text-center">Error fetching data</td>
                    </tr>
                `);
            }
        });
    }
});

// Handle click on installer status for SweetAlert confirmation
$(document).on('click', '.installer-status', function () {
    let rollId = $(this).data('roll-id');
	let orderId = $(this).data('order-id');
    let currentStatus = $(this).data('status');

    Swal.fire({
        title: "Are you sure?",
        text: "Do you want to cut this roll?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, cut it!"
    }).then((result) => {
        if (result.isConfirmed) {
            // Make AJAX request to update status
            $.ajax({
                url: "/update-roll-status", 
                type: "POST",
                data: {
                    roll_id: rollId,
					order_id: orderId,
                    status: "Cutting Done", // New status
                    _token: $('meta[name="csrf-token"]').attr("content") // CSRF token
                },
                success: function (response) {
                    if (response.success) {
                        Swal.fire("Updated!", "The roll has been cut.", "success");
                        location.reload(); // Reload to update the table
                    } else {
                        Swal.fire("Error!", response.message, "error");
                    }
                },
                error: function () {
                    Swal.fire("Error!", "Something went wrong!", "error");
                }
            });
        }
    });
});




			</script>
		
			<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/installer/orders.blade.php ENDPATH**/ ?>