<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supplier Stock Report</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        header img {
            height: 50px;
            width: 200px;
        }

        header div {
            text-align: right;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            text-decoration: underline;
            margin-top: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
            font-size: 14px;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .total-row {
            font-weight: bold;
            background-color: #e6e6e6;
        }

        .section-header {
            font-size: 16px;
            font-weight: bold;
            text-align: left;
            padding: 10px;
            background-color: #f2f2f2;
            border: 1px solid black;
        }
    </style>
</head>
<body>

<header class="header">
    <img src="assets/img/report_images/img.png" alt="Logo">
    <div>
        <b>XYZ Trading Pvt Ltd.</b> <br>
        33/2 Rayna Building, Balewadi <br>
        GST NO: 98751324680881324
    </div>
</header>

    <h2>Supplier Stock Report</h2>

    <section>
        <?php
            $totalGrandTotal = 0;
        ?>
        <!-- Section: 551101 ORNATE -->
        <?php $__currentLoopData = $inward_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $totalGrandTotal += isset($inward['grand_total']) ? (float) $inward['grand_total'] : 0;
        ?>
        <div class="section-title"><?php echo e($inward['inward_id']); ?> <?php echo e($inward['supplier_name']); ?></div>
        <table>
            <tr>
                <th>Roll NO</th>
                <th>Design NO / Name</th>
                <th>Place</th>
                <th>Avl-Qty</th>
            </tr>
           
            <tr class="section-header">
                <td colspan="4"><?php echo e($inward['inward_id']); ?> <?php echo e($inward['supplier_name']); ?></td>
            </tr>
            <?php $__currentLoopData = $inward['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item->id); ?></td>
                <td><?php echo e($inward['inward_id']); ?> <?php echo e($inward['supplier_name']); ?></td>
                <td><?php echo e($inward['warehouse']); ?> </td>
                <td><?php echo e($item->quantity); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="total-row">
                <td colspan="3">Total</td>
                <td><?php echo e($inward['grand_total'] ?? '0.00'); ?></td>
            </tr>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        

        <!-- Grand Total -->
        <table>
            <tr class="total-row">
                <td colspan="3">Grand Total</td>
                <td><?php echo e(number_format($totalGrandTotal, 2)); ?></td>
            </tr>
        </table>

    </section>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/supplierstockreport.blade.php ENDPATH**/ ?>