<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>			
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			
			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Product List</h4>
								<h6>Manage your products</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="<?php echo e(url('add-product')); ?>" class="btn btn-added"><i data-feather="plus-circle" class="me-2"></i>Add New Product</a>
						</div>	
						
					</div>
					
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="javascript:void(0);" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								<!--<div class="search-path">
									<a class="btn btn-filter" id="filter_search">
										<i data-feather="filter" class="filter-icon"></i>
										<span><img src="assets/img/icons/closes.svg" alt="img"></span>
									</a>
								</div>
								<div class="form-sort">
									<i data-feather="sliders" class="info-img"></i>
									<select class="select">
										<option>Sort by Date</option>
										<option>14 09 23</option>
										<option>11 09 23</option>
									</select>
								</div>-->
							</div>
							<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
							<!-- /Filter -->
							<div class="card mb-0" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-12 col-sm-12">
											<div class="row">
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="box" class="info-img"></i>
														<select class="select">
															<option>Choose Product</option>
															<option>
																Lenovo 3rd Generation</option>
															<option>Nike Jordan</option>
														</select>
													</div>
												</div>
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="stop-circle" class="info-img"></i>
														<select class="select">
															<option>Choose Categroy</option>
															<option>Laptop</option>
															<option>Shoe</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="git-merge" class="info-img"></i>
														<select class="select">
															<option>Choose Sub Category</option>
															<option>Computers</option>
															<option>Fruits</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i data-feather="stop-circle" class="info-img"></i>
														<select class="select">
															<option>All Brand</option>
															<option>Lenovo</option>
															<option>Nike</option>
														</select>
													</div>
												</div>
												
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<i class="fas fa-money-bill info-img"></i>
														<select class="select">
															<option>Price</option>
															<option>$12500.00</option>
															<option>$12500.00</option>
														</select>
													</div>
												</div>
												<div class="col-lg-2 col-sm-6 col-12">
													<div class="input-blocks">
														<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Filter -->
							<div class="table-responsive product-list">
								<table class="table datanew">
									<thead>
										<tr>
											
											<th class="no-sort">Action</th>
											<th>Product Name</th>
											<th>Product Code</th>
											<th>Image</th>
											<th>Company</th>
											
											
											<th>Category</th>
											
											<th>Status</th>
											
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="action-table-data">
												<div class="edit-delete-action">
													<a class="me-2 edit-icon  p-2" href="<?php echo e(url('view-product-details/'.$row->id)); ?>" title="View Product Detail">
														<i data-feather="eye" class="feather-eye"></i>
													</a>
													<a class="me-2 p-2" href="<?php echo e(url('edit-product/'.$row->id)); ?>" title="Edit">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);" title="Delete">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
											</td>
											<td> <?php echo e($row->product_name); ?></td>
											<td> <?php echo e($row->product_code); ?></td>
																						<td><img src="<?php echo e(url('uploads/products/'.$row->product_image)); ?>" alt="Product Image" style="height:50px;width:100px;" onerror="this.onerror=null;this.src='<?php echo e(url('uploads/images.jpeg')); ?>';"></td>

											<td><?php echo e($row->company_name); ?></td>
											
											
											<td><?php echo e($row->category_name); ?></td>
											
											<td><?php if($row->status==1): ?><a href="<?php echo e(url('inactive_product/'.$row->id)); ?>"><span class="badge badge-linesuccess">Active</span></a><?php else: ?>
                                                <a href="<?php echo e(url('active_product/'.$row->id)); ?>"><span class="badge badge-linedanger">Inactive</span></a>
                                            <?php endif; ?>
											</td>
											
											
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->


		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script>
			$(document).ready(function () {

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

				$(document).on('click', '.delete-action', function (e) {
					
					e.preventDefault();
					var userId = $(this).data('id');
					
					var deleteUrl = "<?php echo e(url('delete-product')); ?>/" + userId;

					Swal.fire({
						title: 'Are you sure?',
						text: "You won't be able to revert this!",
						icon: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Yes, delete it!'
					}).then((result) => {
						if (result.isConfirmed) {
							$.ajax({

								
								url: deleteUrl,
								method: 'DELETE',
								success: function (response) {
									Swal.fire(
										'Deleted!',
										'Product has been deleted.',
										'success'
									).then(() => {
										location.reload(); // Refresh the page to reflect the changes
									});
								},
								error: function (xhr, status, error) {
									Swal.fire(
										'Error!',
										'There was a problem deleting the user.',
										'error'
									);
								}
							});
						}
					});
				});

			});
		</script>
		<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/product-list.blade.php ENDPATH**/ ?>