<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Installer</h4>
							<h6>Create new installer</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('installer')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Installer</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
				<!-- /add -->
				<form action="<?php echo e(route('save_installer')); ?>" id="myForm"  method="post">
					<?php echo csrf_field(); ?>
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Installer Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
										<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Installer ID </label>
													<input type="text" name="installer_id" id="installer_id" class="form-control" value="<?php echo e($newInstallerId); ?>" readonly>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<div class="add-newplus">
														<label class="form-label">Installer</label>
														<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-units-brand"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
													</div>
													<select name="user_id" class="form-control" required>
                                                        <option value="">Select</option>
														<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($row->id); ?>"><?php echo e($row->full_name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</div>
										
											
											
											
											
										</div>

										<div class="row">
											
											
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" class="form-control" placeholder="Enter Phone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57" required>
												</div>
											</div>
											<div class="col-lg-6 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div><!-- Editor -->
                                        <div class="col-lg-12">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Address</label>
                                                <textarea class="form-control h-100" rows="5" required name="address" placeholder="Enter Address"></textarea>
                                               
                                            </div>
                                        </div>
                                        <!-- /Editor -->
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">State</label>
													<input type="text" name="state" class="form-control" placeholder="Enter State">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">PIN Code</label>
													<input type="text" name="pincode" class="form-control" placeholder="Enter PIN Code" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
												</div>
											</div>
										</div>
										
										
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="<?php echo e(route('installer')); ?>" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn" class="btn btn-submit">Save Installer</button>
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>

	<div class="modal fade" id="add-units-brand">
		<div class="modal-dialog modal-dialog-centered custom-modal-two">
			<div class="modal-content">
				<div class="page-wrapper-new p-0">
					<div class="content">
						<div class="modal-header border-0 custom-modal-header">
							<div class="page-title">
								<h4>Add New Installer</h4>
							</div>
							<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body custom-modal-body">
							<form id="addInstallerForm">
							<?php echo csrf_field(); ?>
							<div class="mb-3">
								<label class="form-label">Installer</label>
								<input type="text" name="name" id="installer_name" class="form-control" required> <small id="installer-error" style="color: red; display: none;">This installer  is already added!</small>
							</div>
							<div class="mb-3">
								<label class="form-label">Email</label>
								<input type="email" name="email" id="email" class="form-control" required> 
							</div>
							<div class="mb-3">
								<label class="form-label">Password</label>
								<input type="password" name="password" id="password" class="form-control" required> 
							</div>
							<div class="modal-footer-btn">
								<a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
								<input type="submit" id="submitinsBtn" class="btn btn-submit" name="submit" value="Submit"><p id="message" style="color: red;">
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Main Wrapper -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">
	
	/*let lastProductNumber = 1; // Initialize with the starting value

	function generateProductCode(name, lastNumber = lastProductNumber) {
		const words = name.split(" ");
		let initials = '';
	
		// Get the first letter of each word
		words.forEach(word => {
			if (word.length > 0) {
				initials += word[0].toUpperCase();
			}
		});
	
		// Increment the last number and pad with zeros if needed
		let incrementedNumber = String(lastNumber).padStart(2, '0');
		return '#' + initials + incrementedNumber;
	}
	
	// Function to check if the product code already exists
	function checkProductCode(productName, lastNumber) {
		const productCode = generateProductCode(productName, lastNumber);
	
		return $.ajax({
			url: "<?php echo e(route('check.product.code')); ?>", // URL to your Laravel route
			type: "POST",
			data: {
				_token: "<?php echo e(csrf_token()); ?>",
				product_code: productCode
			},
			dataType: "json"
		}).then(response => {
			if (response.exists) {
				// If the product code exists, increment the number and try again
				return checkProductCode(productName, lastNumber + 1);
			} else {
				// If the product code doesn't exist, return the unique code
				return productCode;
			}
		});
	}
	
	// Event listener for the product name input
	document.getElementById('user_id').addEventListener('input', function() {
		const productName = this.value.trim();
	
		if (productName.length > 0) {
			checkProductCode(productName, lastProductNumber)
				.then(uniqueProductCode => {
					// Set the unique product code
					document.getElementById('installer_id').value = uniqueProductCode;
					lastProductNumber++; // Update the last product number for the next product
				})
				.catch(error => {
					console.error('Error checking product code:', error);
				});
		} else {
			document.getElementById('installer_id').value = ''; // Clear the product code if the product name is empty
		}
	});*/

	$('#addInstallerForm').submit(function(e) {
			e.preventDefault(); // Prevent the default form submission

			// Get the brand name value
			var installerName = $('#installer_name').val();
			var email = $('#email').val();
			var password = $('#password').val();
			
			

			// Make the AJAX request to add the brand
			$.ajax({
				url: "<?php echo e(route('add_installer_dynamic')); ?>", // Your route for adding the brand
				method: 'POST',
				data: {
					_token: '<?php echo e(csrf_token()); ?>', // Add CSRF token
					name: installerName,
					email: email,
					password: password,
				},
				success: function(response) {
					console.log(response.installer);
					if (response.success) {
						
						$('#add-units-brand').modal('hide');

						
						$('#addInstallerForm')[0].reset();

					
						$('select[name="user_id"]').append('<option value="' + response.installer.id + '" selected>' + response.installer.full_name + '</option>');

					
					
					} else {
						alert('Failed to add installer!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
		});
		
		document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
    document.getElementById("addInstallerForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitinsBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
    $("#installer_name").on("keyup blur", function (e) { 
        let installer = $(this).val();
       
            $.ajax({
                url: "<?php echo e(route('check_installer_exists')); ?>",
                type: "POST",
                data: {
                    installer: installer,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#installer-error").show(); 
                        $("#installer_name").addClass("error-field"); 
                        $("#installer_name").focus(); 
                         $("#submitinsBtn").prop("disabled", true);
                        $("#message")
            .text("This installer  name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#installer-error").hide(); 
                        $("#installer_name").removeClass("error-field"); 
                    }
                }
            });
            $("#submitinsBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#installer_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#installer-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
</script>	
	
	<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add-installer.blade.php ENDPATH**/ ?>