<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
	.btn-outline-pink:hover{
		background-color: #d6487e!important;
		color:#fff!important
	}
</style>
		<!-- /Header -->
			
			<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Orders</h4>
								<h6>Manage your orders</h6>
							</div>
						</div>
						
						<div class="page-btn">
													<a href="<?php echo e(url('add-new-order')); ?>" class="btn btn-added"><i data-feather="plus-circle" class="me-2"></i>Add New Order</a>

						</div>
					</div>

					<?php if(session()->has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session()->has('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session()->get('error')); ?>

                </div>
            <?php endif; ?>

					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								 
							</div>
							<!-- /Filter -->
								<div class="card mb-0" id="filter_inputs">
									<div class="card-body pb-0">
										<div class="row">
											<div class="col-lg-12 col-sm-12">
												<div class="row">
													<div class="col-lg-2 col-sm-6 col-12">
													</div>
													<div class="col-lg-1 col-sm-6 col-12">
													</div>
											
													<!-- Supplier Select -->
													<div class="col-lg-3 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="supplier_id">Customer</label>
															<i data-feather="git-merge" class="info-img" style="margin-top: 14px;"></i>
															
															<select class="select" name="customer_id" id="customer_id">
																<option value="">Choose Customer</option>
																<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($row->id); ?>"><?php echo e($row->customer_name); ?></option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													</div>
											
													<!-- Start Date -->
													<div class="col-lg-2 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="start_date">Start Date</label>
															<i data-feather="calendar" class="info-img" style="margin-top: 14px;"></i>
															<input type="date" class="form-control" id="start_date" placeholder="Start Date" name="start_date">
														</div>
													</div>
											
													<!-- End Date -->
													<div class="col-lg-2 col-sm-6 col-12">
														<div class="input-blocks">
															<label for="end_date">End Date</label>
															<i data-feather="calendar" class="info-img" style="margin-top: 14px;"></i>
															<input type="date" class="form-control" id="end_date" placeholder="End Date" name="end_date">
														</div>
													</div>
											
													
												</div>
											</div>
											
										</div>
									</div>
								</div>
								<!-- /Filter -->
							<div class="table-responsive"  id="ordersTable">
								<table class="table  datanew">
									<thead>
										<tr>
											<th class="no-sort">Action</th>
											<th>Order Id</th>
											<th>Customer</th>
                                            <th>Order Date</th>
											<th>Order Total</th>
											<th>Order Status</th>
											<th>Order Type</th>
											<th>Payment Status</th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="action-table-data">
											<a href="<?php echo e(url('view-order/'.$row->id)); ?>"  title="View Order"><i data-feather="eye" class="feather-eye"></i></a>
											&nbsp;&nbsp;
											 <a href="<?php echo e(url('edit-new-order/'.$row->id)); ?>" style="margin-right: 10px"  title="Edit Order"><i data-feather="edit" class="feather-edit"></i></a>

                                               
                                            </td>
											<td><?php echo e($row->order_code); ?></td>
											
											<td><?php echo e($row->customer_name); ?></td>
											<td><?php echo e(date('d M Y', strtotime($row->order_date))); ?></td>
											<td>₹<?php echo e($row->grandtotal); ?></td>
											<td> 
											<?php if($row->status == "Ordered"): ?>
											<span type="button" class="btn btn-md btn-outline-primary  me-2">
												<?php echo e($row->status); ?>

											</button>
											<?php elseif($row->status == "Measurement"): ?>
											<button type="button" class="btn btn-md btn-outline-danger my-1 me-2">
												<?php echo e($row->status); ?>

											</button>
											<?php elseif($row->status == "Cutting Done"): ?>
											<button type="button" class="btn btn-md btn-outline-info my-1 me-2">
												<?php echo e($row->status); ?>

											</button>
											<?php elseif($row->status == "Payment Done"): ?>
											<button type="button" class="btn btn-md btn-outline-success my-1 me-2">
												<?php echo e($row->status); ?>

											</button>
											<?php elseif($row->status == "Packed"): ?>
											<button type="button" class="btn btn-md btn-outline-warning my-1 me-2">
												<?php echo e($row->status); ?>

											</button>
											<?php elseif($row->status == "Shipped"): ?> 
												
											<button type="button" class="btn btn-md btn-outline-pink my-1 me-2" style="background-color: #fff;border-color:#d6487e;	
												color: #d6487e;">
												<?php echo e($row->status); ?>

											</button>
											<?php else: ?>
											<button type="button" class="btn btn-md btn-outline-dark">
												<?php echo e($row->status); ?>

											</button>
											<?php endif; ?>
												<!-- <span class="badge <?php echo e($row->status == 'Completed' ? 'badge badge-md bg-success' : 'badge badge-md bg-info'); ?>">
												<?php echo e($row->status); ?>

												</span> -->
												
											</td>
											<td>
												<?php if($row->order_type == "Delivery"): ?>
												<span class="badge badge-md bg-success  my-1 me-2"><?php echo e($row->order_type); ?></span>
												<?php else: ?>
												<span class="badge badge-md bg-primary my-1 me-2"><?php echo e($row->order_type); ?></span>
												<?php endif; ?>
												
											</td>
										<td><span class="badge <?php echo e($row->payment_status == 'Paid' ? 'badge badge-md bg-outline-success' : 'badge badge-md bg-outline-danger'); ?>">
											<?php echo e($row->payment_status); ?>

										</span></td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
			</div>
			<!-- /Main Wrapper -->

			<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
			
			<script>
	$(document).ready(function() {
		function fetchFilteredOrders() {
			var customer_id = $('#customer_id').val();
			var start_date = $('#start_date').val();
			var end_date = $('#end_date').val();

			$.ajax({
				url: "<?php echo e(url('orders')); ?>",
				method: "GET",
				data: {
					customer_id: customer_id,
					start_date: start_date,
					end_date: end_date
				},
				success: function(response) {
					var tbody = $("#ordersTable tbody");
					tbody.empty();

					if (response.orders.length > 0) {
						
						$.each(response.orders, function(index, order) {
							var editUrl = `edit-new-order/${order.id}`;
							var viewUrl = `view-order/${order.id}`;

							var row = `<tr>
								<td class="action-table-data">
									<a href="${editUrl}" style="margin-right: 10px" title="Edit Order">
										<i data-feather="edit" class="feather-edit"></i>
									</a>
									<a href="${viewUrl}" title="View Order">
										<i data-feather="eye" class="feather-eye"></i>
									</a>
								</td>
								<td>${order.order_code}</td>
								<td>${order.customer_name}</td>
								<td>${new Date(order.order_date).toLocaleDateString()}</td>
								<td>${order.grandtotal}</td>
								<td>
									<span class="badge ${order.status === 'Completed' ? 'badge-bgsuccess' : 'badge-bgdanger'}">
										${order.status}
									</span>
								</td>
								<td>
									<span class="badge ${order.status === 'Paid' ? 'badge-linesuccess' : 'badge-linedanger'}">
										Pending
									</span>
								</td>
							</tr>`;

							tbody.append(row);
						});

						feather.replace(); // Re-initialize icons
					} else {
						tbody.append('<tr><td colspan="7" class="text-center">No records found.</td></tr>');
					}
				}
			});
		}

		$('#customer_id, #start_date, #end_date').on('change', function() {
			//alert(1);
			fetchFilteredOrders();
		});
	});


			</script>

		
			<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			<script>

$(document).ready(function() {
   /* if ($.fn.DataTable.isDataTable('.datanew')) {
        $('.datanew').DataTable().destroy(); 
    }*/

    $('.datanew').DataTable({
        "pageLength": 25,
        "lengthMenu": [ [10, 25, 50, 100], [10, 25, 50, 100] ], 
        "ordering": false, 
        "retrieve": true 
    });
});

			</script>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/orders.blade.php ENDPATH**/ ?>