<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
	<meta name="description" content="POS - Floorfactory">
	<meta name="keywords" content="carpets, curtains, rolls, sheets">
	<meta name="author" content="Floorfactory">
	<meta name="robots" content="noindex, nofollow">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<title><?php echo e($title ?? 'Floorfactory'); ?></title>

	<!-- Favicon -->
	<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('assets/img/newlogo.png')); ?>">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/bootstrap.min.css')); ?>">

	<!-- Datetimepicker CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/bootstrap-datetimepicker.min.css')); ?>">

	<!-- animation CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/animate.css')); ?>">

	<!-- Feathericon CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/feather.css')); ?>">

	<!-- Select2 CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/select2/css/select2.min.css')); ?>">

	<!-- Summernote CSS -->
	

	<!-- Bootstrap Tagsinput CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css')); ?>">

	<!-- Datatable CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/dataTables.bootstrap5.min.css')); ?>">

	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/fontawesome/css/fontawesome.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/fontawesome/css/all.min.css')); ?>">
	<!-- Owl Carousel CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/owlcarousel/owl.carousel.min.css')); ?>">

	<!-- Mobile CSS-->
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/intltelinput/css/intlTelInput.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(url('assets/plugins/intltelinput/css/demo.css')); ?>">


	<!-- Main CSS -->
	<link rel="stylesheet" href="<?php echo e(url('assets/css/style.css')); ?>">
</head>

<body>

	
	
	<div id="global-loader">
		<div class="whirly-loader"> </div>
	</div>
	<!-- Main Wrapper -->
	<div class="main-wrapper">

		<!-- Header -->
		<div class="header">
<?php
							$indexRoute = Auth::guard('installer')->check() ? route('installer.index') : route('index')?>
			<!-- Logo -->
			<div class="header-left active">
				<a href="<?php echo e($indexRoute); ?>" class="logo logo-normal">
					<img src="<?php echo e(url('assets/img/logo.png')); ?>" alt="">
				</a>
				<a href="<?php echo e($indexRoute); ?>" class="logo logo-white">
					<img src="<?php echo e(url('assets/img/logo-white.png')); ?>" alt="">
				</a>
				<a href="<?php echo e($indexRoute); ?>" class="logo-small">
					<img src="<?php echo e(url('assets/img/newlogo.png')); ?>" alt="">
				</a>
				<a id="toggle_btn" href="javascript:void(0);">
					<i data-feather="chevrons-left" class="feather-16"></i>
				</a>
			</div>
			<!-- /Logo -->

			<a id="mobile_btn" class="mobile_btn" href="#sidebar">
				<span class="bar-icon">
					<span></span>
					<span></span>
					<span></span>
				</span>
			</a>

			<!-- Header Menu -->
			<ul class="nav user-menu">

				<!-- Search -->
				<li class="nav-item nav-searchinputs">
					<div class="top-nav-search">
						<a href="javascript:void(0);" class="responsive-search">
							<i class="fa fa-search"></i>
						</a>
						
					</div>
				</li>
				<!-- /Search -->


				<!-- Select Store -->
				

				<!-- Flag -->
				
				<!-- /Flag -->

				
				<!-- Notifications -->
				
				<!-- /Notifications -->

				
				
				<li class="nav-item dropdown has-arrow main-drop">
					<a href="javascript:void(0);" class="dropdown-toggle nav-link userset" data-bs-toggle="dropdown">
						<span class="user-info">
							<span class="user-letter">
								<img src="assets/img/profiles/ecom.png" alt="" class="img-fluid">
							</span>
							<span class="user-detail">
								<span class="user-name"><?php echo e($authUser->full_name ?? ''); ?>

								</span>
								<span class="user-role"><?php if($authUser->type_id == 1): ?>
									Admin
								<?php elseif($authUser->type_id == 5): ?>
									Installer
								<?php else: ?>
									Unknown Role
								<?php endif; ?></span>
							</span>
						</span>
					</a>
					<div class="dropdown-menu menu-drop-user">
						<div class="profilename">
							<div class="profileset">
								<span class="user-img"><img src="assets/img/profiles/ecom.png" alt="">
									<span class="status online"></span></span>
									
								
								<div class="profilesets">
									<h6><?php echo e($authUser->full_name ?? 'Guest'); ?></h6>
									<h5>
										<?php if($authUser && $authUser->type_id == 1): ?>
											Admin
										<?php elseif($authUser && $authUser->type_id == 5): ?>
											Installer
										<?php else: ?>
											Unknown Role
										<?php endif; ?>
									</h5>
								</div>
								
								
							</div>
							<hr class="m-0">
							<?php
							$profileRoute = Auth::guard('installer')->check() ? route('installer.profile') : route('profile');
							$changePasswordRoute = Auth::guard('installer')->check() ? route('installer.change_password') : route('change_password');
							
							$logoutRoute = Auth::guard('installer')->check() ? route('installer.logout') : route('logout');
						?>
						
						<a class="dropdown-item" href="<?php echo e($profileRoute); ?>"> 
							<i class="me-2" data-feather="user"></i> My Profile
						</a>
						<hr class="m-0">
						<a class="dropdown-item" href="<?php echo e($changePasswordRoute); ?>"> 
							<i class="me-2" data-feather="lock"></i> Change Password
						</a>
						<hr class="m-0">
						
						<a class="dropdown-item logout pb-0" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
							<i class="me-2" data-feather="log-out"></i> Logout
						</a>
						
						
						
					<form id="logout-form" action="<?php echo e($logoutRoute); ?>" method="POST" style="display: none;">
							<?php echo csrf_field(); ?>
						</form>
						

							
						</div>
					</div>
				</li>
				
				<!--<li class="nav-item dropdown has-arrow main-drop">
					<a href="javascript:void(0);" class="dropdown-toggle nav-link userset" data-bs-toggle="dropdown">
						<span class="user-info">
							<span class="user-letter">
								<img src="assets/img/profiles/ecom.jpg" alt="" class="img-fluid">
							</span>
							<span class="user-detail">
								<span class="user-name"></span>
								<span class="user-role"></span>
							</span>
						</span>
					</a>
					<div class="dropdown-menu menu-drop-user">
						<div class="profilename">
							<div class="profileset">
								<span class="user-img"><img src="assets/img/profiles/ecom.png" alt="">
									<span class="status online"></span></span>
								<div class="profilesets">
									<h6></h6>
									<h5></h5>
								</div>
							</div>
							<hr class="m-0">
							<a class="dropdown-item" href="<?php echo e(route('profile')); ?>"> <i class="me-2" data-feather="user"></i> My Profile</a>
							
							<a class="dropdown-item" href="<?php echo e(route('change_password')); ?>"> <i class="me-2" data-feather="user"></i> Change Password</a>
							
							<hr class="m-0">
							<a class="dropdown-item logout pb-0" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a>

							<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
								<?php echo csrf_field(); ?>
							</form>

							
						</div>
					</div>
				</li>-->
			</ul>
			<!-- /Header Menu -->

			<!-- Mobile Menu -->
			<div class="dropdown mobile-user-menu">
				<a href="javascript:void(0);" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
				<div class="dropdown-menu dropdown-menu-right">
					<a class="dropdown-item" href="">My Profile</a>
					
					
					
					<a class="dropdown-item" href="<?php echo e($logoutRoute); ?>">Logout</a>
				</div>
			</div>
			<!-- /Mobile Menu -->
		</div>
		<!-- /Header -->
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/layouts/header.blade.php ENDPATH**/ ?>