<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stock Supply Report</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            border: 2px solid black; /* Outer Border */
        }

        th, td {
            text-align: left;
            padding: 10px;
            font-size: 16px;
            border: 1px solid black; /* Cell Borders */
        }

        th {
            background-color: #f2f2f2;
            text-decoration: underline;
        }

          .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            /*padding: 20px;*/
        }
        .header-container img{
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .company-info {
            text-align: right;
            font-size: 14px;
        }

        .section-title {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
        }

        .supplier-header {
            font-size: 18px;
            font-weight: bold;
            background-color: #f9f9f9;
            text-align: center;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
        .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
    </style>
    
<style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

 <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('inwards')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header><hr>

<h2 class="section-title">Stock Supplier</h2>
<!-- <?php echo e(date('Y-m-d')); ?> -->

  <?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('stock_supply')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    
      <label for="product" style="margin-bottom: 0; font-size:15px"><b>Product:</b></label>
    <select name="product"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($row->id); ?>" <?php echo e(request('product') == $row->id ? 'selected' : ''); ?>><?php echo e($row->product_name); ?></option>
       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('stock_supply')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>

<br>

<section>
    <table>
        <tr>
            <th><u>Stock</u></th>
            <th>Avl Quantity</th>
            <th>QOH</th>
            <th>CP</th>
            <th>Total Amount</th>
        </tr>
        <?php
            $total = 0;
        ?>
        <?php $__currentLoopData = $product_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Timberland Section -->
        <tr class="supplier-header">
            <td colspan="5"><b><?php echo e($items['product_name']); ?></b></td>
        </tr>
        <?php $__currentLoopData = $items['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $total += $item->purchase_cost ? $item->purchase_cost : 0;
        ?>
        <tr>
            <td><?php echo e($item->varient_code); ?>/<?php echo e($item->varient_name); ?></td>
            <td><?php echo e($item->quantity); ?></td>
            <td><?php echo e($item->availability); ?></td>
            <td><?php echo e($item->basic_cost ?? ''); ?></td>
            <td><?php echo e($item->purchase_cost); ?></td>
        </tr>
        
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="4" style="text-align: right;"><b>Total:</b></td>
            <td><u><b><?php echo e($total); ?></b></u></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
    </table>
     <br>
  <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('stock_supply_pdf',['product' => request('product')])); ?>">Download</a>
   <button type="button" class="custom-button" onclick="window.print()">Print</button>
         <?php endif; ?>
</section>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/stocksupply.blade.php ENDPATH**/ ?>