<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Today's Inward</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 5px;
            font-size: 16px;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .header div {
            text-align: right;
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

        .total {
            font-weight: bold;
            text-align: right;
        }

        .total hr {
            margin: 0;
            border-top: 1px solid black;
        }

        .final-total {
            font-size: 20px;
            font-weight: bold;
            text-align: right;
        }
    </style>
</head>
<body>
    <header class="header">
        <img src="assets/img/report_images/img.png" alt="Logo">
        <div>
            <b>XYZ Trading Pvt Ltd.</b> <br>
            33/2 Rayna Building, Balewadi <br>
            GST NO: 98751324680881324
        </div>
    </header>

    <h2 class="section-title">Today's Inward</h2>
    <b><?php echo e(date('d-M-Y')); ?></b>

    <section style="margin-top: 20px;">
        <table>
            <tr>
                <th>Order No</th>
                <th style="width: 200px;">Customer Name</th>
                <th>Amount</th>
                <th>Bill No</th>
                <th>Bank</th>
                <th>Remarks</th>
                <th>Cheq No</th>
                <th>Rcpt Type</th>
            </tr>

            <?php
                $grand_total = 0;
            ?>

            <?php $__currentLoopData = $grouped_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_method => $customers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr><td colspan="8"><b><?php echo e($payment_method); ?></b></td></tr>

                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer_name => $customer_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="8"><b><?php echo e($customer_name); ?> (Total: <?php echo e(number_format($customer_data['total_amount'], 2)); ?>)</b></td>
                    </tr>

                    <?php $__currentLoopData = $customer_data['orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($order['order_id']); ?></td>
                            <td><?php echo e($customer_name); ?></td>
                            <td><?php echo e(number_format(floatval(str_replace(',', '', $order['amount'])), 2)); ?></td>
                            <td><?php echo e($order['receipt_id']); ?></td>
                            <td><?php echo e($order['bank'] ?? '-'); ?></td>
                            <td><?php echo e($order['remark'] ?? '-'); ?></td>
                            <td><?php echo e($order['cheq_no'] ?? '-'); ?></td>
                            <td><?php echo e($order['rcpt_type']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php
                        $grand_total += $customer_data['total_amount'];
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr>
                <td colspan="2" class="final-total">Grand Total</td>
                <td class="final-total"><b><?php echo e(number_format($grand_total, 2)); ?></b></td>
                <td colspan="5"></td>
            </tr>
        </table>
    </section>
</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/todayscollections.blade.php ENDPATH**/ ?>