<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products Supplier Mapping</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 16px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

         .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
        }

        .logo-section {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        
        }

        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
/*            padding: 20px;*/
        }

        .company-info {
            text-align: right;
            font-size: 14px;
        }

        .section-title {
            text-align: center;
            margin-top: 20px;
            font-size: 22px;
            font-weight: bold;
/*            text-decoration: underline;*/
        }

        .supplier-name {
            font-size: 20px;
            font-weight: bold;
            margin-top: 35px;
            margin-bottom: 0px !important;
        }

        .product-header {
            font-size: 18px;
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .total-row td {
            font-weight: bold;
            text-align: left;
            border-top: 2px solid black;
        }
        header img{
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }
        hr{
            border: 1px solid black;
            margin-bottom: 15px;
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
    </style>
    <style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

   <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('index')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header>
<hr>   

    <h2 class="section-title">Product Supplier Mappings</h2><br>
        <?php if(!$is_pdf): ?>
    <form method="GET" action="<?php echo e(route('product_supplier')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
        <label for="supplier" style="margin-bottom: 0; font-size:15px"><b>Supplier:</b></label>
        <select name="supplier" id="supplier" class="form-control"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
            <option value="">Select</option>
            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($row->id); ?>" <?php echo e(request('supplier') == $row->id ? 'selected' : ''); ?>>
                    <?php echo e($row->supplier_name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <label for="product" style="margin-bottom: 0; font-size:15px"><b>Product:</b></label>
        <select name="product" id="product" class="form-control"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
            <option value="">Select</option>
        </select>

      <label for="variant" style="margin-bottom: 0; font-size:15px"><b>Variant:</b></label>
    <select name="variant" id="variant" class="form-control"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
    </select>


        <button type="submit" class="custom-button">Filter</button>
        <a href="<?php echo e(route('product_supplier')); ?>" class="reset-button">Reset</a>
    </form>

  
    <script>
document.addEventListener('DOMContentLoaded', function () {
    const supplierSelect = document.getElementById('supplier');
    const productSelect = document.getElementById('product');
    const variantSelect = document.getElementById('variant');

    const selectedSupplier = "<?php echo e(request('supplier')); ?>";
    const selectedProduct = "<?php echo e(request('product')); ?>";
    const selectedVariant = "<?php echo e(request('variant')); ?>";

    // Load Products by Supplier
    function loadProducts(supplierId, selectedProductId = null) {
        productSelect.innerHTML = '<option value="">Loading...</option>';
        fetch(`/get-products-by-supplier-report/${supplierId}`)
            .then(response => response.json())
            .then(data => {
                let options = '<option value="">Select</option>';
                data.products.forEach(product => {
                    const selected = product.id == selectedProductId ? 'selected' : '';
                    options += `<option value="${product.id}" ${selected}>${product.product_name}</option>`;
                });
                productSelect.innerHTML = options;

                // If product already selected, load variants
                if (selectedProductId) {
                    loadVariants(selectedProductId, selectedVariant);
                }
            })
            .catch(() => {
                productSelect.innerHTML = '<option value="">Select</option>';
            });
    }

    // Load Variants by Product
    function loadVariants(productId, selectedVariantId = null) {
        variantSelect.innerHTML = '<option value="">Loading...</option>';
        fetch(`get-variants-by-product-report/${productId}`)
            .then(response => response.json())
            .then(data => {
                let options = '<option value="">Select</option>';
                data.variants.forEach(variant => {
                    const selected = variant.id == selectedVariantId ? 'selected' : '';
                    options += `<option value="${variant.id}" ${selected}>${variant.varient_code} - ${variant.varient_name}</option>`;
                });
                variantSelect.innerHTML = options;
            })
            .catch(() => {
                variantSelect.innerHTML = '<option value="">Select</option>';
            });
    }

    // Initial load if supplier/product are pre-selected
    if (selectedSupplier) {
        loadProducts(selectedSupplier, selectedProduct);
    }

    if (selectedProduct && !selectedSupplier) {
        loadVariants(selectedProduct, selectedVariant);
    }

    // On supplier change
    supplierSelect.addEventListener('change', function () {
        const supplierId = this.value;
        if (supplierId) {
            loadProducts(supplierId);
            variantSelect.innerHTML = '<option value="">Select</option>'; // reset variants
        } else {
            productSelect.innerHTML = '<option value="">Select</option>';
            variantSelect.innerHTML = '<option value="">Select</option>';
        }
    });

    // On product change
    productSelect.addEventListener('change', function () {
        const productId = this.value;
        if (productId) {
            loadVariants(productId);
        } else {
            variantSelect.innerHTML = '<option value="">Select</option>';
        }
    });
});
</script>

    <?php endif; ?>


<br>
    <?php $__currentLoopData = $product_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <!-- <h2 class="supplier-name"><?php echo e($item['supplier_name']); ?></h2> -->

    <section style="margin-top: 25px;">
        <table>
            <tr>
                <!-- <th>Roll No</th> -->
                 <th>Product</th>
                <th>Design No / Name</th>
                <!-- <th>Place</th>
                <th>Available Qty</th> -->
                <th>Supplier Name</th>
            </tr>
            <?php $total = 0; ?>
            <?php $__currentLoopData = $item['rolls']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $total += $value->availability;
                $i=1; ?>
                <tr>
                  
                     <td><?php echo e($value->product_name); ?></td>
                    <td><?php echo e($value->varient_code); ?> - <?php echo e($value->varient_name); ?></td>
                  
                    <td><?php echo e($item['supplier_name']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <!-- <tr class="total-row">
                <td colspan="4" style="text-align: right;">Total Availability</td>
                <td><?php echo e($total); ?></td>
                <td></td>
            </tr> -->
        </table>
    </section>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<br>
  <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('product_supplier_pdf',['supplier' => $selected_supplier, 'product' => $selected_product,'variant'=>$selected_variant])); ?>">Download</a>
          <button type="button" class="custom-button" onclick="window.print()">Print</button>
         <?php endif; ?>
</body>
</html>



<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/productsuppliermapping.blade.php ENDPATH**/ ?>