<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Transporter</h4>
							<h6>Create new transporter</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('transporters')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Transporter</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
				<!-- /add -->
				<form action="<?php echo e(route('save_transporter')); ?>" id="myForm" method="post">
					<?php echo csrf_field(); ?>
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Transporter Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
										<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Tranporter ID</label>
													<input type="text" name="transporter_id" class="form-control" value="<?php echo e($newTransporter); ?>" readonly>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Tranporter Name</label>
													<input type="text" name="transporter_name" class="form-control" id="transporter" placeholder="Enter Transporter Name" required><small id="transporter-error" style="color: red; display: none;">This transporter is already added!</small>
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Contact Person</label>
													<input type="text" name="contact_person" class="form-control" placeholder="Enter Contact Person" required>
												</div>
											</div>

											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Email</label>
													<input type="text" name="email" class="form-control" placeholder="Enter Email" required>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10" class="form-control" placeholder="Enter Phone1" required>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">
													
												</div>
											</div>
										
<div class="col-lg-12">
	<div class="input-blocks summer-description-box transfer mb-3">
		<label>Address</label>
		<textarea class="form-control h-100" rows="5" name="address" placeholder="Enter Address" required></textarea>
		
	</div>
</div>

											
											
											
											
										</div>


										<div class="row">
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City" >
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">State</label>
													<input type="text" name="state" class="form-control" placeholder="Enter State" >
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">PIN Code</label>
													<input type="text" name="pincode" class="form-control" placeholder="Enter PIN Code" >
												</div>
											</div>
											
											
											
                                            <div class="col-lg-3 col-sm-6 col-12">
												<div class="input-blocks add-product list">
                                                    <label class="form-label">Status</label>
                                            <select class="select" name="status">
                                                <option>Choose Status</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>
                                    </div>
										</div>

									

									
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="<?php echo e(route('transporters')); ?>" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn" class="btn btn-submit">Save Transporter</button><p id="message" style="color: red;">
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->
	<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
	 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
     $("#transporter").on("keyup blur", function (e) { 
        let transporter = $(this).val();
        alert(transporter);
       
            $.ajax({
                url: "<?php echo e(route('check_transporter_exists')); ?>",
                type: "POST",
                data: {
                    transporter: transporter,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#transporter-error").show(); 
                        $("#transporter").addClass("error-field"); 
                        $("#transporter").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This transporter  name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#transporter-error").hide(); 
                        $("#transporter").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#transporter").on("keydown", function (e) {
        if (e.key === "Tab" && $("#transporter-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
    </script>
    
	
	
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add_transporter.blade.php ENDPATH**/ ?>