<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Supplier</h4>
							<h6>Create new supplier</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('suppliers')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Supplier</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
				<!-- /add -->
				<form action="<?php echo e(route('save_supplier')); ?>" method="post" id="myForm">
					<?php echo csrf_field(); ?>
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Supplier Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Supplier ID</label>
													<input type="text" name="supplier_id" class="form-control" value="<?php echo e($newSupplierId); ?>" required readonly>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Supplier Name</label>
													<input type="text" name="supplier_name" class="form-control" id="supplier_name" placeholder="Enter Supplier Name" required><small id="supplier-error" style="color: red; display: none;">This supplier is already added!</small>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Warehouse </label>
													<select class="select" name="warehouse_id" required>
													
													<option value="">Choose</option>
													<?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($row->id); ?>"><?php echo e($row->warehouse_name); ?></option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
												</div>
											</div>
                                            <div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Contact Person</label>
													<input type="text" name="contact_person" class="form-control" placeholder="Enter Contact Person" required>
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">GST No</label>
													<input type="text" name="gst_no" class="form-control" id="gst_no" placeholder="Enter GST No"  required>
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Top</label>
													<input type="text" id="top" name="top" class="form-control" readonly required>
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">MSME</label>
													<input type="text" name="msme" class="form-control" placeholder="Enter MSME" required>
												</div>
											</div>
											
											
										</div>

										<div class="row">
											<div class="col-lg-2 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Telephone code</label>
													<input type="text" class="form-control list" name="code"  placeholder="Enter Code" required onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" class="form-control" placeholder="Enter Phone1" required onkeypress="return event.charCode >= 48 && event.charCode <= 57">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div>

                                        <div class="row">
                                            <div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Mobile No</label>
													<input type="text" name="mobile_no" class="form-control list" placeholder="Enter Mobile No" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10" required>

												</div>
											</div>
                                            <div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Fax No</label>
													<input type="text" name="fax" class="form-control list" placeholder="Enter Fax No" onkeypress="return event.charCode >= 48 && event.charCode <= 57">

												</div>
											</div>
                                            <div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Email</label>
													<input type="email" name="email" class="form-control list" placeholder="Enter Email" required>

												</div>
											</div>
                                        </div>
                                        <!-- Editor -->
                                        <div class="col-lg-12">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Address</label>
                                                <textarea class="form-control h-100" rows="5" name="address" placeholder="Enter Address" required></textarea>
                                                
                                            </div>
                                        </div>
                                        <!-- /Editor -->

										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label>State</label>
													<input type="text" name="state" class="form-control list" placeholder="Enter State">
													
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label>PIN code</label>
													<input type="text" name="pincode" class="form-control list" placeholder="Enter PIN Code" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div>

										
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="<?php echo e(route('suppliers')); ?>" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn" class="btn btn-submit">Save Supplier</button><p id="message" style="color: red;">
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->
	
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

	<script>
		$(document).ready(function() {
       
        $('#top').val('');
        
      
        $('#gst_no').on('input', function() {
            var gstNo = $(this).val(); 

            if (gstNo.length === 0) {
                
                $('#top').val('');
            } else if (gstNo.includes('27')) {
               
                $('#top').val('MSP');
            } else {
                
                $('#top').val('OMS');
            }
        });
    });	</script>
    <script>
document.getElementById("gst_no").addEventListener("input", function() {
    if (this.value.length > 15) {
        alert("GST No length is 15.");
        this.value = this.value.substring(0, 15);
       
    }
});

document.getElementById("gst_no").addEventListener("blur", function() {
    if (this.value.length !== 15) {
        if (!this.dataset.alertShown) { 
            alert("GST number must be exactly 15 characters.");
            this.dataset.alertShown = "true"; 
        }
        this.focus();
    } else {
        this.dataset.alertShown = ""; 
    }
});

document.addEventListener("DOMContentLoaded", function () {
    const textbox = document.getElementById("myTextbox");
    if (textbox) {
        textbox.addEventListener("input", function () {
            this.dataset.alertShown = "";
        });
    } else {
        console.error("Element with ID 'myTextbox' not found!");
    }
});


</script>

<script>
	 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); 
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
     $("#supplier_name").on("keyup blur", function (e) { 
        let supplier_name = $(this).val();
       
            $.ajax({
                url: "<?php echo e(route('check_supplier_exists')); ?>",
                type: "POST",
                data: {
                    supplier_name: supplier_name,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#supplier-error").show(); 
                        $("#supplier_name").addClass("error-field"); 
                        $("#supplier_name").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This supplier  name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#supplier-error").hide(); 
                        $("#supplier_name").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#supplier_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#supplier-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
    </script>
    
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	
	
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add-supplier.blade.php ENDPATH**/ ?>