<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>View Inward</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body style="font-family: Poppins; background: #fff; padding: 20px;">

	<!-- Inward Header -->
	<header style="border-bottom: 3px solid black; padding: 5px;" class="p-4">
		<div>
			<h6 style="font-weight: bold; float:right;">Ph nos: 9665065522 /25 /34</h6>
		</div><br><br>
		<div>
			<h1 style="font-weight: bold;text-align: center;"><?php echo e($inward->company_name); ?></h1>
			<h6 style="text-align: center;">Inward</h6>
		</div>
	</header>

	<!-- Inward Info -->
	<div style="padding: 20px; border-bottom: 3px solid black;">
    <table style="width: 100%; border-collapse: collapse;">
        <tr>
            <td style="width: 50%; padding: 5px;">
                <strong>Inward No:</strong> <?php echo e($inward->inward_no); ?>

            </td>
            <td style="width: 50%; padding: 5px; text-align: right;">
                <strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($inward->inward_date)->format('d-m-Y')); ?>

            </td>
        </tr>
        <tr>
            <td style="width: 50%; padding: 5px;">
                <strong>Warehouse:</strong> <?php echo e($inward->warehouse_name); ?>

            </td>
            <td style="width: 50%; padding: 5px; text-align: right;">
                <strong>PO Number:</strong> <?php echo e($inward->po_number); ?>

            </td>
        </tr>
    </table>
</div>


	<!-- Product Summary -->

   <div style="margin-top: 40px;">
    <h5 style="font-weight: bold;">Product Summary</h5><br>
    <table style="width: 100%; border-collapse: collapse; border: 1px solid #000; font-size: 12px;">
        <thead>
            <tr>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">No</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Product Name</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Design / Variant No</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">No of Rolls</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Quantity per Roll</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">UOM</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Rate per Unit</th>
                <th style="border: 1px solid #000; padding: 6px; white-space: nowrap;">Amount</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="border: 1px solid #000; padding: 6px;">1</td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e($inward->product_name); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e($inward->varient_name); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e($inward->no_of_rolls); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e($inward->quantity); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e($inward->unit_name); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e(number_format($inward->rate, 2)); ?></td>
                <td style="border: 1px solid #000; padding: 6px;"><?php echo e(number_format($inward->amount, 2)); ?></td>
            </tr>

            <!-- Subtotal Row -->
            <tr>
                <td colspan="6" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>Sub Total</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;"><?php echo e(number_format($inward->amount, 2)); ?></td>
            </tr>

            <!-- Grand Total Row -->
            <tr>
                <td colspan="6" style="border: 1px solid #000;"></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right; white-space: nowrap;"><strong>Grand Total</strong></td>
                <td style="border: 1px solid #000; padding: 6px; text-align: right;"><?php echo e(number_format($inward->amount, 2)); ?></td>
            </tr>
        </tbody>
    </table>
</div>



	<!-- Footer -->
	<div style="margin-top: 30px;">
		<h6 style="font-weight: bold; float:right; padding: 10px;">For <?php echo e($inward->company_name ?? ''); ?></h6>
	</div><br><br>
	<div>
		<h6 style="float:right; padding: 10px;">Authorized Signature</h6>
	</div>

</body>
</html>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/emails/inward_mail.blade.php ENDPATH**/ ?>