<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /Header -->
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Edit Purchase Order</h4>
                    <h6>Edit purchase order</h6>
                </div>
            </div>
            <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="<?php echo e(route('purchase_orders')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Purchases</a>
                    </div>
                </li>
            </ul>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
        <?php endif; ?>

        <form action="<?php echo e(route('update_purchase_order')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" value="<?php echo e($po_details['id']); ?>">
            <div class="card">
                <div class="card-body add-product pb-0">
                    <div class="accordion-card-one accordion" id="accordionExample">
                        <div class="accordion-item">
                            <div class="accordion-header" id="headingOne">
                                <div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-controls="collapseOne">
                                    
                                </div>
                            </div>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Number</label>
                                                <input type="text" name="po_number" class="form-control" value="<?php echo e($po_details['po_number']); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Date</label>
                                                <input type="date" name="po_date" class="form-control" value="<?php echo e($po_details['po_date']); ?>" >
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Company</label>
                                                <select class="form-control" name="company" id="company_id">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" <?php echo e($po_details['company_id'] == $row->id ? 'selected' : ''); ?>><?php echo e($row->company_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        </div>
                                        <div class="row">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Supplier</label>
                                                <select class="form-control" name="supplier" id="supplier_select">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" <?php echo e($po_details['supplier_id'] == $row->id ? 'selected' : ''); ?> data-top="<?php echo e($row->top); ?>"> <?php echo e($row->supplier_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                         <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Products</label>
                                                <select class="form-control" name="product" id="product_select" >
                                                    <option value="">Select</option>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Transporter</label>
                                                <select class="form-control" name="transporter" id="transporter_id">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $transporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" <?php echo e($po_details['transporter_id'] == $row->id ? 'selected' : ''); ?>> <?php echo e($row->transporter_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <h5>Order Items</h5>
                                            <div class="table-responsive">
                                                <table class="table table-bordered" id="order-items">
                                                    <thead>
                                                        <tr>
                                                            <th>Action</th>
                                                            <th>Design/Varient No</th>
                                                            <th>No Of Rolls</th>
                                                            <th>Rate /Unit</th>
                                                            <th>Quantity /Roll</th>
                                                            <th style="width: 30%">UOM</th>
                                                            <th>% GST</th>.
                                                            <th style="width: 60%">Amount</th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                        <?php $__currentLoopData = $po_details['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    
                                                        <tr class="order-row">
                                                           
                                                                <td>
                                                                    <a href="#" class="btn btn-success add-item" style="color:white;background:green"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                                        <circle cx="12" cy="12" r="10"></circle>
                                                                        <line x1="12" y1="8" x2="12" y2="16"></line>
                                                                        <line x1="8" y1="12" x2="16" y2="12"></line>
                                                                    </svg></a>
                                                                </td>
                                                            
                                                                <td>
                                                                    <select name="varient_id[]" class="form-control varient-select"  required>
                                                                        <option value="">Select Varient</option>
                                                                        <?php $__currentLoopData = $varients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($row->id); ?>" <?php echo e($item->varient_id == $row->id ? 'selected' : ''); ?> ><?php echo e($row->varient_name); ?>-<?php echo e($row->varient_code); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                                                    </select>
                                                                </td>

                                                                <td>
                                                                    <input type="text" name="no_of_rolls[]" class="form-control no_of_rolls" value="<?php echo e($item->no_of_rolls); ?>" required>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="rate[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control rate" step="0.01" value="<?php echo e($item->rate); ?>" required>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="quantity[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control quantity " value="<?php echo e($item->quantity); ?>" required>
                                                                </td>

                                                               

                                                                <td>
                                                                    
                                                                    <select name="uom[]" class="form-control uom"  required>
                                                                        <option value="">Select Unit</option>
                                                                        <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($row->id); ?>" <?php echo e($item->uom == $row->id ? 'selected' : ''); ?> ><?php echo e($row->unit_name); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                                                    </select>
                                                                </td>

                                                                <td>
                                                                    <input type="text" name="gst_percent[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control gst_percent" step="0.01" value="<?php echo e($item->gst_percent); ?>" required>
                                                                </td>
                                                               
                                                                <td>
                                                                    <input type="text" class="form-control total" name="total[]" value="<?php echo e($item->quantity * $item->rate * $item->no_of_rolls); ?>" readonly>
                                                                </td>
                                                                
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="row">
                                        <!-- Gross Total -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Gross Total:</label>
                                                <input type="number" name="subtotal" value="<?php echo e($po_details['subtotal']); ?>" class="form-control grosstotal" readonly>
                                            </div>
                                        </div>
                                        
                                        <!-- Forwarding Percentage and Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Forwarding:</label>
                                                <div class="input-group" style="width: 50%;">
                                                    <input type="text" class="form-control forwarding_percent"  value="<?php echo e($po_details['f_percent']); ?>" name="f_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="text" name="f_amount" value="<?php echo e($po_details['f_amount']); ?>" class="form-control ms-3 f_amount"  style="width: 50%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                            </div>
                                        </div>
                                       
                                        <input type="hidden" name="gst_amount" class="form-control flex-grow-1" value="<?php echo e($po_details['gst_amount']); ?>" readonly>
                                        <?php
                                        $frwd=$po_details['f_amount'] * $po_details['f_percent'] / 100;
                                        $frwd_amt= $po_details['f_amount'] + $frwd;
                                        ?>
                                        <input type="hidden" name="forwarding" class="form-control forwarding" value="<?php echo e($frwd_amt); ?>" readonly>
                                        

                                        <!-- Forwarding Amount -->
                                        
                                        
                                        <!-- GST Amount -->
                                        

                                        <div class="col-lg-4 offset-lg-8"  style="display:none" id="cgst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">CGST:</label>
                                                
                                                <input type="text" name="cgst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 offset-lg-8"  style="display:none" id="sgst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">SGST:</label>
                                                
                                                <input type="text" name="sgst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 offset-lg-8" style="display:none" id="igst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">IGST:</label>
                                                
                                                <input type="text" name="igst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>

                                    
                                        <!-- Final Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left:-12px">Final Amount:</label>
                                                <input type="number" name="grand_total" value="<?php echo e($po_details['grand_total']); ?>" class="form-control" readonly>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-lg-12">
                    <div class="d-flex align-items-center mb-2">
                        <label class="form-label me-2">Note:</label>
                        <input type="text" name="note" class="form-control" value="<?php echo e($po_details['note']); ?>" >
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="btn-addproduct mb-4">
                    <button type="button" class="btn btn-cancel me-2">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>

let supplierSelectd = document.getElementById('supplier_select');


let selectedOptiond = supplierSelectd.options[supplierSelectd.selectedIndex];
let selectedValued = selectedOptiond.value; 

let dataTopd = selectedOptiond.getAttribute('data-top'); 

const cgstField = document.getElementById('cgst_div');
const sgstField = document.getElementById('sgst_div');
const igstField = document.getElementById('igst_div');

var gstamt=$('input[name="gst_amount"]').val();

               
            if (dataTopd === 'OMS') {
                
                cgstField.style.display = 'none';
                sgstField.style.display = 'none';
                igstField.style.display = 'block';
                $('input[name="igst_amount"]').val(gstamt);
            } else if (dataTopd === 'MSP') {
                var cgstamt=gstamt/2;
                var sgstamt=gstamt/2;
                $('input[name="cgst_amount"]').val(cgstamt);
                $('input[name="sgst_amount"]').val(sgstamt);
               

                cgstField.style.display = 'block';
                sgstField.style.display = 'block';
                igstField.style.display = 'none';
            }



    $('input[name="f_percent"]').on('input', function () {
        // var forwarding_percent = parseFloat($('input[name="f_percent"]').val()) || 0; 
        // var f_amount = parseFloat($('input[name="f_amount"]').val()) || 0;
        // // Calculate the forwarding amount
        // var forwarding = f_amount + (f_amount * forwarding_percent / 100);
        // $('input[name="forwarding"]').val(forwarding.toFixed(2)); 
        
      let gst_percent_single = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;
      var forwarding_percent = parseFloat($('input[name="f_percent"]').val()) || 0; 
      var grosstotal = parseFloat($('input[name="subtotal"]').val()) || 0; 
      var f_amount = parseFloat($('input[name="f_amount"]').val()) || 0;

       var forwarding = grosstotal * forwarding_percent / 100;
       console.log(forwarding);

       $('input[name="f_amount"]').val(forwarding.toFixed(2)); 
        let fmat=grosstotal+forwarding;
       let gstnewAmount = (fmat * gst_percent_single) / 100;
       let halfGst_rownew = gst_percent_single / 2;
       let halfamount=gstnewAmount/2;
       $('input[name="gst_amount"]').val(gstnewAmount.toFixed(2));

       $('input[name="cgst_amount"]').val(halfamount.toFixed(2));
       $('input[name="sgst_amount"]').val(halfamount.toFixed(2));
       $('input[name="igst_amount"]').val(gstnewAmount.toFixed(2));
       let grandTotal = grosstotal + gstnewAmount + forwarding;
      $('input[name="grand_total"]').val(grandTotal.toFixed(2));
      
        updateGrandTotals();
    });


$(document).ready(function () {
    // Initially replace "add" icon with "remove" icon for existing rows
    $('#order-items tbody tr').each(function () {
        $(this).find('.add-item').replaceWith('<a href="#" class="btn btn-danger remove-item" style="color: white;"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>');
    });
    
    const initialRow = '<tr class="add-row">' +
        '<td>' +
        '<a href="#" class="btn btn-success add-item" style="color: white;">' +
        '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">' +
        '<circle cx="12" cy="12" r="10"></circle>' +
        '<line x1="12" y1="8" x2="12" y2="16"></line>' +
        '<line x1="8" y1="12" x2="16" y2="12"></line>' +
        '</svg>' +
        '</a>' +
        '</td>' +
        '</tr>';

    // Append the initial row with only the Add button
    $('#order-items tbody').append(initialRow);

    // Function to create the new row with input fields
    const addItemRow = function () {
        return '<tr class="order-row">' +
            '<td>' +
            '<a href="#" class="btn btn-danger remove-item" style="color: white;"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>' +
            '</td>' +
            '<td><select name="varient_id[]" class="form-control varient-select" required><option value="">Select Varient</option><?php $__currentLoopData = $varients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($row->id); ?>"><?php echo e($row->varient_name); ?>-<?php echo e($row->varient_code); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></td>' +
            '<td><input type="text" name="no_of_rolls[]" class="form-control no_of_rolls"></td>' +
            '<td><input type="text" name="rate[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control rate" step="0.01" required></td>' +
            '<td><input type="text" name="quantity[]" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control quantity" required></td>' +
            '<td><select name="uom[]" class="form-control uom" required><option value="">Select Unit</option><?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($row->id); ?>"><?php echo e($row->unit_name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></td>' +
            '<td><input type="text" name="gst_percent[]" class="form-control gst_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57"></td>' +
            '<td><input type="text" class="form-control total" name="total[]" readonly></td>' +
            '</tr>';
    };



 

    // Add Item Event
    $(document).on('click', '.add-item', function (e) {
        e.preventDefault();

        let newRow = addItemRow(); 
     
 $('.add-row').before(newRow);
        updateGrandTotals();
    });

    // Remove Item Event
    $(document).on('click', '.remove-item', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove(); // Remove the row

        updateGrandTotals();
    });

    // GST Percent Change
    $(document).on('input', '.gst_percent', function () {
     // Get the current row
     let row = $(this).closest('tr');
        
        // Fetch amount and GST percentage values
        let amount = parseFloat(row.find('input[name="total[]"]').val()) || 0;
        let gstPercent = parseFloat($(this).val()) || 0;

        // Calculate net amount
        let netAmount = amount + (amount * gstPercent / 100);

        // Update the Net Amount field
        row.find('input[name="net_total[]"]').val(netAmount.toFixed(2));

        let totalGSTAmount = 0;
     $('.gst_percent').each(function () {
        let row = $(this).closest('tr');
        let rowAmount = parseFloat(row.find('input[name="total[]"]').val()) || 0;
        let rowGstPercent = parseFloat($(this).val()) || 0;
        totalGSTAmount += rowAmount * rowGstPercent / 100;
     });

     // Update the GST Amount field
     $('input[name="gst_amount"]').val(totalGSTAmount.toFixed(2));
        updateGrandTotals();
    });

    // Quantity or Rate Input
    $(document).on('input', 'input[name="quantity[]"],input[name="no_of_rolls[]"], input[name="rate[]"]', function () {
        let row = $(this).closest('tr');
        calculateRowTotal(row);
        
        updateGrandTotals();
    });

    // Calculate the total for a specific row
    function calculateRowTotal(row) {
        let no_of_rolls = parseFloat(row.find('input[name="no_of_rolls[]"]').val()) || 0;
        let quantity = parseFloat(row.find('input[name="quantity[]"]').val()) || 0;
        let rate = parseFloat(row.find('input[name="rate[]"]').val()) || 0;
        let total = no_of_rolls* quantity * rate;
        row.find('input[name="total[]"]').val(total.toFixed(2));

        let gstPercent = parseFloat(row.find('input[name="gst_percent[]"]').val()) || 0;
        let netAmount = total + (total * gstPercent / 100);
        row.find('input[name="net_total[]"]').val(netAmount.toFixed(2));

        let halfGst = gstPercent / 2; 

        let totalformsp= total * halfGst/100;

        let totalforoms= total * gstPercent/100;


        // Add the totalformsp and totalforoms for each row
        let total_cgst = 0;
        let total_sgst = 0;
        let total_igst = 0;

        // Accumulate CGST and SGST for all rows
        $('#order-items tbody tr').each(function() {
        let gst_percent_row = parseFloat($(this).find('.gst_percent').val()) || 0;
        let total_row = parseFloat($(this).find('.total').val()) || 0;
        let halfGst_row = gst_percent_row / 2;

        // For MSP, accumulate CGST and SGST
        if (gst_percent_row > 0) {
        total_cgst += total_row * halfGst_row / 100;
        total_sgst += total_row * halfGst_row / 100;
        }

        // For OMS, accumulate IGST
        total_igst += total_row * gst_percent_row / 100;
        });

        // Update the CGST, SGST, and IGST fields
        $('#cgst_div .cgst').val(total_cgst.toFixed(2));
        $('#sgst_div .sgst').val(total_sgst.toFixed(2));
        $('#igst_div .igst').val(total_igst.toFixed(2));

        // Append the totalformsp to cgst_amount and sgst_amount input fields
        $('input[name="cgst_amount"]').val(total_cgst.toFixed(2));
        $('input[name="sgst_amount"]').val(total_sgst.toFixed(2));
        $('input[name="igst_amount"]').val(total_igst.toFixed(2));

    }

    // Update Grand Totals
    function updateGrandTotals() {
        let subtotal = 0, totalGSTAmount = 0;

        $('#order-items tbody tr').each(function () {

            //let total = parseFloat($(this).find('input[name="total[]"]').val()) || 0;
            //let gstPercent = parseFloat($(this).find('input[name="gst_percent[]"]').val()) || 0;
            let total = parseFloat($(this).find('.total').val()) || 0;

            subtotal += total;
          //  totalGSTAmount += total * gstPercent / 100;

            
        });

        $('input[name="subtotal"]').val(subtotal.toFixed(2));
        //$('input[name="gst_amount"]').val(totalGSTAmount.toFixed(2));


         //new code forwarding & gst
         var fper=parseFloat($('input[name="f_percent"]').val()) || 0;
        var fsub=parseFloat($('input[name="subtotal"]').val()) || 0;
        var newforwarding = fsub * fper / 100;
        
       // let forwarding = parseFloat($('input[name="forwarding"]').val()) || 0;
       $('input[name="f_amount"]').val(newforwarding.toFixed(2));
        let gst_percent_new = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;
        let fcmt=newforwarding+fsub;    
        let gstnewAmountdata = (fcmt * gst_percent_new) / 100;
        let halfGst_new = gst_percent_new / 2;
        let halfamountnew=gstnewAmountdata/2;
       $('input[name="gst_amount"]').val(gstnewAmountdata.toFixed(2));
       $('input[name="cgst_amount"]').val(halfamountnew.toFixed(2));
       $('input[name="sgst_amount"]').val(halfamountnew.toFixed(2));
       $('input[name="igst_amount"]').val(gstnewAmountdata.toFixed(2));

       //end code


       let gst_amount = parseFloat($('input[name="gst_amount"]').val()) || 0;
      
        let forwarding = parseFloat($('input[name="f_amount"]').val()) || 0;
       
        let grandTotal = subtotal + gst_amount + forwarding;

        $('input[name="grand_total"]').val(grandTotal.toFixed(2));
    }

    $(document).on('change', '.varient-select', function () {
      var variantId = $(this).val(); 
      //alert(variantId);
      var row = $(this).closest('tr'); 

      if (variantId) {
        $.ajax({
            url: '<?php echo e(route("getVariantDetails")); ?>', 
            type: 'GET',
            data: { id: variantId },
            success: function (response) {
                console.log(response);
                // Update the fields in the same row
                row.find('.rate').val(response.rate);
                row.find('.quantity').val(response.quantity);
                row.find('.uom').val(response.uom_id);
                row.find('.gst_percent').val(response.gst_rate);
               
            },
            error: function (xhr) {
                console.error("Error fetching variant details: ", xhr.responseText);
            }
        });
     }
   });
   
   
   $(document).on('change', '.uom', function () {
    var unitId = $(this).val(); 
    var row = $(this).closest('tr'); 
    var rate = parseFloat(row.find('.rate').val()) || 0;
    var quantity = parseFloat(row.find('.quantity').val()) || 0;
    var no_of_rolls = parseFloat(row.find('.no_of_rolls').val()) || 1;
    let gst_percent_data = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;
    
    // Store previous values in data attributes
    if (!row.data('originalRate')) {
        row.data('originalRate', rate);
        row.data('originalQuantity', quantity);
    }

    if (unitId) {
        $.ajax({
            url: '<?php echo e(route("convertunit")); ?>', 
            type: 'GET',
            data: { id: unitId, rate: rate, quantity: quantity, no_of_rolls: no_of_rolls },
            success: function (response) {
                console.log(response);

                if (response.unit_name === 'sqft') {
                    // Restore previous values
                    //row.find('.rate').val(row.data('originalRate').toFixed(2));
                    //row.find('.quantity').val(row.data('originalQuantity'));
                     row.find('.rate').val(response.rate.toFixed(2));
                    row.find('.quantity').val(response.quantity);
                    
                } else if (response.unit_name === 'sqm'){
                    // Convert and update values
                    row.find('.rate').val(response.rate.toFixed(2));
                    row.find('.quantity').val(response.quantity);
                }

                row.find('.uom').val(response.uom_id);
                row.find('.no_of_rolls').val(response.no_of_roll);

                // Update total
                row.find('.total').val((parseFloat(row.find('.rate').val()) * parseFloat(row.find('.quantity').val()) * no_of_rolls).toFixed(2));

                // Calculate gross total
                var grossTotal = 0;
                $('.total').each(function() {
                    grossTotal += parseFloat($(this).val()) || 0;
                });

                $('.grosstotal').val(grossTotal.toFixed(2));
                
                 var fper=parseFloat($('input[name="f_percent"]').val()) || 0;
                 var fsub=parseFloat($('input[name="subtotal"]').val()) || 0;
                  var newforwarding = fsub * fper / 100;
                 $('input[name="f_amount"]').val(newforwarding.toFixed(2));
                
                let forwarding = parseFloat($('input[name="f_amount"]').val());
                let newamt=forwarding + grossTotal;
                

                let gstnewAmount = (newamt * gst_percent_data) / 100;
               
                let halfamountnew=gstnewAmount/2;
                $('input[name="gst_amount"]').val(gstnewAmount.toFixed(2));
                $('input[name="cgst_amount"]').val(halfamountnew.toFixed(2));
                $('input[name="sgst_amount"]').val(halfamountnew.toFixed(2));
                $('input[name="igst_amount"]').val(gstnewAmount.toFixed(2));
                
                console.log("Gross Total: ", grossTotal.toFixed(2));
                var finaltotal=gstnewAmount + grossTotal + forwarding;
              
                $('input[name="grand_total"]').val(finaltotal.toFixed(2));


            },
            error: function (xhr) {
                console.error("Error fetching unit details: ", xhr.responseText);
            }
        });
    }
});



   const supplierSelect = document.getElementById('supplier_select');


             supplierSelect.addEventListener('change', function() {
       
            const selectedSupplier = supplierSelect.options[supplierSelect.selectedIndex];
            
            const supplierTop = selectedSupplier.getAttribute('data-top'); 
           
          
            const cgstField = document.getElementById('cgst_div');
            const sgstField = document.getElementById('sgst_div');
            const igstField = document.getElementById('igst_div');

           
            if (supplierTop === 'OMS') {
                cgstField.style.display = 'none';
                sgstField.style.display = 'none';
                igstField.style.display = 'block';
            } else if (supplierTop === 'MSP') {
                cgstField.style.display = 'block';
                sgstField.style.display = 'block';
                igstField.style.display = 'none';
            }



product_id=$(this).val();


if (product_id) {
                $.ajax({
                    url: '/get-variants-by-product',
                    method: 'GET',
                    data: { product_id: product_id },
                    success: function (response) {
                        const variantDropdown = $('.varient-select');
                        variantDropdown.empty(); 
                        variantDropdown.append('<option value="">Select Varient</option>');

                        if (response.length > 0) {
                            response.forEach(variant => {
                                variantDropdown.append(
                                    `<option value="${variant.id}">${variant.varient_name} - ${variant.varient_code}</option>`
                                );
                            });
                        } else {
                            alert('No variants found for this supplier.');
                        }
                        },
                        error: function () {
                            alert('Failed to fetch variants. Please try again.');
                        }
                });
            }

        });




});

 $(document).ready(function () {
    const selectedProductId = "<?php echo e($selectedProductId ?? ''); ?>"; // From Blade

    function loadProducts(supplierId, selectedId = null) {
        $('#product_select').empty().append('<option value="">Select</option>');

        $.ajax({
            url: '/get-products-by-supplier/' + supplierId,
            type: 'GET',
            success: function (response) {
                //console.log(response.products);
                $.each(response.products, function (index, product) {
                    //const selected = selectedId && selectedId == product.id ? 'selected' : '';
                    let isSelected = selectedId == product.id ? 'selected' : '';
                  // console.log(isSelected);
                    console.log(isSelected);
                    $('#product_select').append(
                        `<option value="${product.id}" ${isSelected}>${product.product_name}</option>`
                    );
                    
                    if (product.id) {
                       $('#product_select').val(product.id);
                     }
                });
            }
        });
    }

    // On supplier change
    $('#supplier_select').on('change', function () {
        let supplierId = $(this).val();
        $('.variant-select').prop('disabled', false);
        loadProducts(supplierId); // No selectedProductId on manual change
    });

    // On edit page load
    const currentSupplierId = $('#supplier_select').val();
    if (currentSupplierId) {
        loadProducts(currentSupplierId, selectedProductId);
    }
    });





</script>


<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/edit_purchase_order.blade.php ENDPATH**/ ?>