<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products Supplier Mapping</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: Arial, sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 16px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
        }

        .company-info {
            text-align: right;
            font-size: 14px;
        }

        .section-title {
            text-align: center;
            margin-top: 20px;
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
        }

        .supplier-name {
            font-size: 20px;
            font-weight: bold;
            margin-top: 10px;
        }

        .product-header {
            font-size: 18px;
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .total-row td {
            font-weight: bold;
            text-align: left;
            border-top: 2px solid black;
        }
    </style>
</head>
<body>

<header class="header-container">
    <div>
        <img src="assets/img/report_images/img.png" alt="Company Logo" height="50px" width="200px">
    </div>
    <div class="company-info">
        <b>
            XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324
        </b>
    </div>
</header>

<h2 class="section-title">Product Supplier Mappings</h2>
<?php $__currentLoopData = $product_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<h2 class="supplier-name"><?php echo e($item['supplier_name']); ?></h2>

<section style="margin-top: 25px;">
    <table>
        <tr>
            <th>Roll No</th>
            <th>Design No / Name</th>
            <th>Place</th>
            <th>Available Qty</th>
            <th>Supplier Name</th>
        </tr>
        <?php
        $total = 0;
        ?>
        <?php $__currentLoopData = $item['rolls']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        $total += $value->availability;
        ?>
        <tr>
            <td><?php echo e($value->id); ?></td>
            <td><?php echo e($value->varient_code); ?>-<?php echo e($value->varient_name); ?></td>
            <td><?php echo e($item['warehouse']); ?></td>
            <td><?php echo e($value->availability); ?></td>
            <td><?php echo e($item['supplier_name']); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr class="total-row">
            <td colspan="3" style="text-align: right;">Total Availability</td>
            <td><?php echo e($total); ?></td>
            <td></td>
        </tr>

       
    </table>
</section>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/productsuppliermapping.blade.php ENDPATH**/ ?>