<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Sales Report</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 8px;
            font-size: 16px;
            border: 1px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .total-row td {
            font-weight: bold;
            border-top: 2px solid black;
        }

        .double-border {
            border-top: 3px double black;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 15px;
        }
    </style>
</head>
<body>

<header style="padding-left:20px; padding-right:20px;">
    <div style="width: 30%; float: left;">
        <img src="assets/img/report_images/img.png" alt="Logo" height="50px" width="200px">
    </div>
    <div style="width: 70%; float: right; text-align:right;">
        <b>
            XYZ Trading Pvt Ltd. <br>
            33/2 Rayna Building, Balewadi <br>
            GST NO: 98751324680881324
        </b>
    </div>
</header>

<h2 style="text-align: center;">Invoice Sales Report</h2>
<b>16-Aug-2024</b>

<section>
    <table>
        <tr>
            <th>InvDate</th>
            <th>InvNo</th>
            <th>Customer Name</th>
            <th>GST Rate</th>
            <th>Base Amount</th>
            <th>SGST Sum</th>
            <th>CGST Sum</th>
            <th>IGST Sum</th>
            <th>Customer GST No</th>
        </tr>

        <?php
            // Initialize grand total values
            $final_base_amount = 0;
            $final_sgst = 0;
            $final_cgst = 0;
            $final_igst = 0;
        ?>

        <?php $__currentLoopData = $salesdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr class="section-title">
            <td colspan="9"><?php echo e($data['percentage']); ?>% GST</td>
        </tr>

        <?php
            // Initialize subtotal for each GST section
            $base_amount = 0;
            $sgst = 0;
            $cgst = 0;
            $igst = 0;
        ?>

        <?php $__currentLoopData = $data['sales_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            // Accumulate subtotal amounts
            $base_amount += $item->grand_total;
            $sgst += $item->sgst_amount;
            $cgst += $item->cgst_amount;
            $igst += $item->igst_amount;
        ?>
        <tr>
            <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('Y-m-d')); ?></td>
            <td><?php echo e($item->invoice_id); ?></td>
            <td><?php echo e($item->supplier_name); ?></td>
            <td><?php echo e($item->gst_rate); ?></td>
            <td><?php echo e($item->grand_total); ?></td>
            <td><?php echo e($item->sgst_amount); ?></td>
            <td><?php echo e($item->cgst_amount); ?></td>
            <td><?php echo e($item->igst_amount); ?></td>
            <td><?php echo e($item->gst_number); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Display subtotal for the GST section -->
        <tr class="total-row">
            <td colspan="4">Subtotal</td>
            <td><?php echo e($base_amount); ?></td>
            <td><?php echo e($sgst); ?></td>
            <td><?php echo e($cgst); ?></td>
            <td><?php echo e($igst); ?></td>
            <td></td>
        </tr>

        <?php
            // Accumulate final grand totals after processing all items in this section
            $final_base_amount += $base_amount;
            $final_sgst += $sgst;
            $final_cgst += $cgst;
            $final_igst += $igst;

            // Store GST Summary Data
            if (!isset($gst_summary[$data['percentage']])) {
                $gst_summary[$data['percentage']] = [
                    'base' => 0, 'sgst' => 0, 'cgst' => 0, 'igst' => 0
                ];
            }
            $gst_summary[$data['percentage']]['base'] += $base_amount;
            $gst_summary[$data['percentage']]['sgst'] += $sgst;
            $gst_summary[$data['percentage']]['cgst'] += $cgst;
            $gst_summary[$data['percentage']]['igst'] += $igst;
        ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Display final Grand Total -->
        <tr class="total-row double-border">
            <td>Grand Total</td>
            <td colspan="3"></td>
            <td><?php echo e($final_base_amount); ?></td>
            <td><?php echo e($final_sgst); ?></td>
            <td><?php echo e($final_cgst); ?></td>
            <td><?php echo e($final_igst); ?></td>
            <td></td>
        </tr>
    </table>

    <div style="margin-top:5%; border: 1px solid black; padding: 20px;">
        <h3>GST Summary</h3>
        <table>
            <tr>
                <th>GST Rate</th>
                <th>Base Amount</th>
                <th>SGST Sum</th>
                <th>CGST Sum</th>
                <th>IGST Sum</th>
            </tr>
            <?php
                // Grand total initialization for GST Summary
                $summary_base_total = 0;
                $summary_sgst_total = 0;
                $summary_cgst_total = 0;
                $summary_igst_total = 0;
            ?>
            <?php $__currentLoopData = $gst_summary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate => $values): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($rate); ?>%</td>
                <td><?php echo e($values['base']); ?></td>
                <td><?php echo e($values['sgst']); ?></td>
                <td><?php echo e($values['cgst']); ?></td>
                <td><?php echo e($values['igst']); ?></td>
            </tr>

            <?php
                $summary_base_total += $values['base'];
                $summary_sgst_total += $values['sgst'];
                $summary_cgst_total += $values['cgst'];
                $summary_igst_total += $values['igst'];
            ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <!-- Grand Total Row for GST Summary -->
            <tr class="double-border">
                <td>Grand Total</td>
                <td><?php echo e($summary_base_total); ?></td>
                <td><?php echo e($summary_sgst_total); ?></td>
                <td><?php echo e($summary_cgst_total); ?></td>
                <td><?php echo e($summary_igst_total); ?></td>
            </tr>
        </table>
    </div>
</section>


</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/invsales.blade.php ENDPATH**/ ?>