<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			<!-- /Header -->
			<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<div class="page-wrapper">
				<div class="content">
					<div class="page-header">
						<div class="add-item d-flex">
							<div class="page-title">
								<h4>Purchase Orders</h4>
								<h6>Manage your Purchase orders</h6>
							</div>
						</div>
						
						<div class="page-btn">
							<a href="<?php echo e(route('add_purchase_order')); ?>" class="btn btn-added" ><i data-feather="plus-circle" class="me-2"></i>Add New Purchase</a>
						</div>
					</div>
					<?php if(session()->has('success')): ?>
					<div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
				<?php endif; ?>
				<?php if(session()->has('error')): ?>
					<div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
				<?php endif; ?>
					<!-- /product list -->
					<div class="card table-list-card">
						<div class="card-body">
							<div class="table-top">
								<div class="search-set">
									<div class="search-input">
										<a href="" class="btn btn-searchset"><i data-feather="search" class="feather-search"></i></a>
									</div>
								</div>
								
							</div>
							<!-- /Filter -->
							<div class="card" id="filter_inputs">
								<div class="card-body pb-0">
									<div class="row">
										<div class="col-lg-3 col-sm-6 col-12">
											<div class="input-blocks">
												<i data-feather="zap" class="info-img"></i>
												<select class="select">
													<option>Choose Category</option>
													<option>Laptop</option>
													<option>Electronics</option>
													<option>Shoe</option>
												</select>
											</div>
										</div>
										
										<div class="col-lg-3 col-sm-6 col-12 ms-auto">
											<div class="input-blocks">
												<a class="btn btn-filters ms-auto"> <i data-feather="search" class="feather-search"></i> Search </a>
											</div>
										</div>
									</div>
								</div>
							</div>	
							<!-- /Filter -->
							<div class="table-responsive product-list">
							

								<table class="table  datanew">
									<thead>
										<tr>
									            <th class="no-sort">Action</th>
										    <th>PO Number</th>
										    <th>Company</th>
										    <th>Supplier</th>
										    <th>Grand Total</th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $purchase_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
										
										<tr>
										<td class="action-table-data">
												<div class="edit-delete-action">
													 <a class="me-2 p-2" href="<?php echo e(url('view-purchase-orders/'.$row->id)); ?>">
														<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye action-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
													</a>
													<a class="me-2 p-2" href="<?php echo e(url('edit-purchase-order/'.$row->id)); ?>" >
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													 <a class="confirm-text p-2 delete-action" data-id="<?php echo e($row->id); ?>" href="javascript:void(0);">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a> 
												</div>
												
											</td>
                                                                                        <td><?php echo e($row->po_number); ?></td>
											<td><?php echo e($row->company_name); ?></td>
											<td><?php echo e($row->supplier_name); ?></td>
											<td>₹ <?php echo e($row->grand_total); ?></td>
											
											
										</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>				
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<!-- /product list -->
				</div>
			</div>
        </div>
		<!-- /Main Wrapper -->

	

	

		
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
		
        <script>
           function editCategory(id, name, status) {
    // Set the values in the modal form
    document.getElementById('edit-id').value = id;
    document.getElementById('edit-name').value = name;
    
     // Convert status to a string and set the selected status
	 var statusSelect = document.getElementById('edit-status');
    status = String(status);  // Ensure status is a string

    // Set the value of the select box
    statusSelect.value = status;

    // Handle showing which option is selected
    if (status === "0") {
        // Show selected "Inactive" option
        statusSelect.value = "0";  // Ensure the inactive option is selected
        console.log("Inactive status selected");
    } else if (status === "1") {
        // Show selected "Active" option
        statusSelect.value = "1";  // Ensure the active option is selected
        console.log("Active status selected");
    }
    
    
}

function viewCategory(id, name){
	document.getElementById('id').value = id;
    document.getElementById('name').value = name;
}

        

			$('#edit-category').on('hidden.bs.modal', function () {
    $(this).find('form')[0].reset();  // Clear the form
});


	$(document).ready(function () {

		$.ajaxSetup({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			}
        });

		$(document).on('click', '.delete-action', function (e) {
			
            e.preventDefault();
            var userId = $(this).data('id');
			
            var deleteUrl = "<?php echo e(url('delete-purchase-order')); ?>/" + userId;

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({

						
                        url: deleteUrl,
                        method: 'DELETE',
                        success: function (response) {
                            Swal.fire(
                                'Deleted!',
                                'Purchase Order has been deleted.',
                                'success'
                            ).then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr, status, error) {
                            Swal.fire(
                                'Error!',
                                'There was a problem deleting the user.',
                                'error'
                            );
                        }
                    });
                }
            });
        });

    });
    
    
        // Function to fetch filtered data
				    function fetchFilteredData() {
                      var supplierId = $('.select[name="supplier_id"]').val();
                      var startDate = $('input[name="start_date"]').val();
                      var endDate = $('input[name="end_date"]').val();

						$.ajax({
							url: "<?php echo e(route('purchase_orders')); ?>",
							method: "GET",
							data: {
								supplier_id: supplierId,
								start_date: startDate,
								end_date: endDate
							},
							success: function (response) {
								var tbody = $(".product-list tbody");
								tbody.empty(); // Clear existing data

								if (response.inwards.length > 0) {
									$.each(response.purchase_orders, function (index, purchase_order) {
										

										var row = `<tr>
											<td class="action-table-data">
												<div class="edit-delete-action">
													
													<a class="me-2 p-2" href="view-purchase-orders/${purchase_order.id}" title="View">
														<i data-feather="eye" class="feather-eye"></i>
													</a>
													<a class="me-2 p-2" href="edit-purchase-order/${purchase_order.id}">
														<i data-feather="edit" class="feather-edit"></i>
													</a>
													<a class="confirm-text p-2 delete-action" href="javascript:void(0);" data-id="${purchase_order.id}">
														<i data-feather="trash-2" class="feather-trash-2"></i>
													</a>
												</div>
											</td>
											<td>${purchase_order.po_number}</td>
											<td>${purchase_order.company_name}</td>
											<td>${purchase_order.supplier_name}</td>
											<td>${purchase_order.grand_total}</td>
											
										</tr>`;

										tbody.append(row);
									});

									// Reinitialize Feather icons after AJAX
									feather.replace();
								} else {
									tbody.append('<tr><td colspan="7" class="text-center">No records found.</td></tr>');
								}
							}
						});
                    }

					$('.select[name="supplier_id"], input[name="start_date"], input[name="end_date"]').on('change', function () {
						fetchFilteredData();
					});
					
</script>
		
<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/purchaselist.blade.php ENDPATH**/ ?>