<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Credit Report</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 5px;
            font-size: 16px;
            border: 1px solid black; /* Add borders for better alignment */
        }

        th {
            background-color: #f2f2f2;
        }

        .text-right {
            text-align: right;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <header class="header">
        <div><img src="assets/img/report_images/img.png" alt="Company Logo"></div>
        <div>
            <b>XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324</b>
        </div>
    </header>

    <section style="margin-top: 30px;">
        <div class="title">CREDIT REPORT</div>
        <table>
            <tr>
                <th>OrdNo</th>
                <th>Date</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>Balance Amount</th>
            </tr>
            <?php $totalBalance = 0; ?>
            <?php if(isset($order_data) && count($order_data) > 0): ?>
                <?php $__currentLoopData = $order_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="5"><b><?php echo e($key); ?></b></td> <!-- Customer Name in Full Row -->
                    </tr>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->order_date); ?></td>
                            <td><?php echo e($key); ?></td>
                            <td><?php echo e($item->mobile); ?></td>
                            <td class="text-right"><?php echo e(number_format($item->grandtotal, 2)); ?></td>
                        </tr>
                        <?php $totalBalance += $item->grandtotal; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <tr>
                <td colspan="4" class="text-right"><b>Total Balance:</b></td>
                <td class="text-right"><b><?php echo e(number_format($totalBalance, 2)); ?></b></td>
            </tr>
        </table>
    </section>
</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/creditreport.blade.php ENDPATH**/ ?>