<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /Header -->
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .select2-container--default .select2-selection--single {
        
        border: 1px solid #e9edf6 !important;
        height:40px !important; 
       
    }
    .select2-container .select2-selection--single .select2-selection__arrow {
        height: 100% !important;
        position: absolute !important;
        top: 0 !important;
        right: 0 !important;
        width: 20px !important; 
        background-color: transparent !important;
        border-left: 1px solid #aaa !important; 
    }
    
    .select2-container .select2-selection__arrow b {
      
        border-width: 5px 5px 0 5px !important; 
        border-style: solid !important;
        display: inline-block !important;
        margin-top: 5px !important;
        vertical-align: middle !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow 
    {
        display: none !important;
    }
    .select2-selection__clear{
        display: none !important;
        /* color:#aaa; */
    }
    
    </style>
    
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Add New Order</h4>
                    <h6>Create new  order</h6>
                </div>
            </div>
            <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="<?php echo e(route('orders')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Orders</a>
                    </div>
                </li>
            </ul>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
        <?php endif; ?>

        <form id="myForm" action="<?php echo e(route('save_new_order')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-body add-product pb-0">
                    <div class="accordion-card-one accordion" id="accordionExample">
                        <div class="accordion-item">
                            <div class="accordion-header" id="headingOne">
                                <div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-controls="collapseOne">
                                    
                                </div>
                            </div>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Order Number</label>
                                                <input type="text" name="order_code" class="form-control" value="<?php echo e($newId); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Order Date</label>
                                                <input type="date" name="order_date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Company</label>
                                                <select class="form-control" name="company_id" id="company_id" required>
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>"><?php echo e($row->company_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <div class="add-newplus">
                                                <label class="form-label">Customer</label>
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-customer"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
                                                </div>  
                                                <select class="form-control" name="customer_id" id="customer_id" required>
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>"><?php echo e($row->customer_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                              <div class="add-newplus">
                                                <label class="form-label">Staff</label>
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-staff"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
                                                </div> 
                                                <select class="form-control" name="staff_id" id="staff_id" required >
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" ><?php echo e($row->full_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                          <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <div class="add-newplus">
                                                <label class="form-label">Transporter</label>
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add-transporter"><i data-feather="plus-circle" class="plus-down-add"></i><span>Add New</span></a>
                                                </div> 
                                                <select class="form-control" name="transporter_id" id="transporter_id" required >
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $transporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" ><?php echo e($row->transporter_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <h5>Order Items</h5>
                                            <div class="table-responsive">
                                                <table class="table table-bordered" id="order-items">
                                                    <thead>
                                                        <tr>
                                                            <th>Action</th>
                                                            <th>Product Name</th>
                                                            <th>Design/Varient No</th>
                                                             <th>Warehouse</th>
                                                            <th>Availability</th>
                                                             <th>Roll No</th>
                                                            <th>Unit </th>
                                                            <th>Rate</th>
                                                            <th>Quantity</th>
                                                            <th>Amount</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="order-row">
                                                           <td>
                                                            <a href="#" class="btn btn-danger remove-item" style="color:white;background:red"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>
                                                           </td>
                                                               
                                                            <td>
                                                                <select name="product_id[]" class="form-control product-select" id="product_select"  required>
                                                                <option value="">Select product</option>
                                                                </select>
                                                            </td>

                                                            <td>
                                                                <select name="varient_id[]" class="form-control variant-select varient_id"  required>
                                                                <option value="">Select Varient</option>
                                                                </select>
                                                            </td>
                                                             <td>
                                                                <select name="warehouse_id[]" class="form-control warehouse-select warehouse_id"  required>
                                                                <option value="">Select Warehouse</option>
                                                                </select>
                                                            </td>
                                                             <td>
                                                                <input type="text" name="availability[]" class="form-control availability" readonly>
                                                            </td>
                                                              <td>
                                                                <input type="text" name="roll_no[]" class="form-control rollno" readonly>
                                                            </td>

                                                            <td> <select name="uom[]" class="form-control uom">
                                                                    <option value="">Select Units</option>
                                                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->unit_name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                                                    </select></td>


                                                            <td><input type="text" name="rate[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"  class="form-control rate" required></td>
                                                            <td><input type="text" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')" class="form-control quantity" required></td>
                                                             
                                                            <td><input type="text" name="total[]" class="form-control total" readonly></td>

                                                        </tr>
                                                        <tr>
                                                        <td>     
                                                            <a href="#" class="btn btn-success add-item" style="color:white;background:green"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                                <circle cx="12" cy="12" r="10"></circle>
                                                                <line x1="12" y1="8" x2="12" y2="16"></line>
                                                                <line x1="8" y1="12" x2="16" y2="12"></line>
                                                            </svg></a>
                                                        </td></tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <!-- Gross Total -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Gross Total:</label>
                                                <input type="number" name="subtotal" class="form-control grosstotal" readonly>
                                            </div>
                                        </div>
                                        
                                        <!-- Forwarding Percentage and Amount -->
                                        <!--<div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Tax:</label>
                                                <div class="input-group" style="width: 50%;">
                                                    <input type="text" class="form-control tax_percent"  name="t_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="text" name="t_amount" class="form-control ms-3 t_amount"  style="width: 50%;background:var(--bs-tertiary-bg);" readonly>
                                            </div>
                                        </div>-->
                                        
                                       <div class="col-lg-5 offset-lg-7" id="special_discount" style="display:none;">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Special Discount:</label>
                                                <div class="input-group" style="width: 50%;">
                                                    <input type="text" class="form-control disc_percent"  name="disc_percent" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="text" name="discount_amount" class="form-control ms-3 discount_amount"  style="width: 50%;background:var(--bs-tertiary-bg);" readonly>
                                            </div>
                                        </div>
                                       

                                        <!-- Final Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left:-12px">Final Amount:</label>
                                                <input type="number" name="grand_total" class="form-control grandtotal" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    
                               

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="btn-addproduct mb-4">
                        <button type="button" class="btn btn-cancel me-2">Cancel</button>
                        <button type="submit" id="submitBtn" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </div>

            
        </form>
    </div>
</div>

<!--add customer modal -->
<div class="modal fade" id="add-customer">
    <div class="modal-dialog modal-dialog-centered custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add New Customer</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form id="addCustomerForm">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="form-label">Customer Name</label>
                            <input type="text" name="name" id="customer_name" class="form-control" required> 
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Customer type </label>
                        <select class="form-control" name="customer_type" id="customer_type" required>
                            <option value="">select</option>
                            <option value="Retail">Retail</option>
                            <option value="Wholesale">Wholesale</option>
                        </select>
                    </div>
                    <div class="mb-3" style="display:none;" id="customer_disc">
                        <div class="mb-3 add-product">
                            <label class="form-label">Customer Discount</label>
                            <input type="text" name="customer_discount" id="customer_discount" class="form-control" placeholder="Enter Customer Discount in %" >
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Mobile No</label>
                            <input type="text" name="mobile_no" id="mobile_no" class="form-control list" placeholder="Enter Mobile No" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">

                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Phone No</label>
                            <input type="text" name="phone1" id="phone1" class="form-control list" placeholder="Enter Phone No" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">

                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" id="email" class="form-control list" placeholder="Enter Email">

                        </div>
                    </div>
                     <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">GST Number</label>
                            <input type="text" name="gst_no" id="gst_no" class="form-control list" maxlength="15" required oninput="validateGST(this)" placeholder="Enter GST Number">
                              <small id="gst-error" style="color:red; display:none;">Invalid GSTIN format</small>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">MSME Number</label>
                            <input type="text" name="msme" id="msme" class="form-control list" maxlength="15" oninput="validateMSME(this)" placeholder="Enter GST Number">
                              <small id="msme-error" class="text-danger"></small>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="input-blocks summer-description-box transfer mb-3">
                            <label>Address</label>
                            <textarea class="form-control h-100" rows="5" id="address" name="address" placeholder="Enter Address"></textarea>
                            
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">PIN Code</label>
                            <input type="text" name="pincode" id="pincode" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control list" placeholder="Enter GST Number">

                        </div>
                    </div>
                        <div class="modal-footer-btn">
                            <a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
                            <input type="submit" class="btn btn-submit" name="submit" value="Submit">
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--add transporter modal -->
<div class="modal fade" id="add-transporter">
    <div class="modal-dialog modal-dialog-centered custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add New Transporter</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                     <form id="addTransporterForm">
                            <?php echo csrf_field(); ?>
                            <!-- Transporter Name -->
                            <div class="mb-3">
                                <label class="form-label">Transporter Name</label>
                                <input type="text" name="transporter_name" id="transporter_name" class="form-control" required>
                            </div>

                            <!-- Contact Person & Email -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Contact Person</label>
                                    <input type="text" name="tcontact_person" class="form-control" id="tcontact_person" placeholder="Enter Contact Person">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="text" name="temail" class="form-control" id="temail" placeholder="Enter Email">
                                </div>
                            </div>

                            <!-- GST No & MSME -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">GST No</label>
                                    <input type="text" name="tgst_no" class="form-control" id="tgst_no" oninput="validateGSTtrans(this)" placeholder="Enter GST No">
                                    <small id="gsttrans-error" class="text-danger"></small>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">MSME</label>
                                    <input type="text" name="tmsme" class="form-control" id="tmsme" oninput="validateMSMEtrans(this)" placeholder="Enter MSME">
                                    <small id="msmetrans-error" class="text-danger"></small>
                                </div>
                            </div>

                            <!-- Phone1 & Phone2 -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Phone1</label>
                                    <input type="text" name="tphone1" class="form-control" id="tphone1" placeholder="Enter Phone">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Phone2</label>
                                    <input type="text" name="tphone2" id="tphone2" class="form-control" placeholder="Enter Phone2">
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="mb-3">
                                <label>Address</label>
                                <textarea class="form-control h-100" rows="3" id="taddress" name="taddress" placeholder="Enter Address"></textarea>
                            </div>

                            <!-- City, State, PIN Code -->
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label">City</label>
                                    <input type="text" name="tcity" id="tcity" class="form-control" placeholder="Enter City">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">State</label>
                                    <input type="text" name="tstate" id="tstate" class="form-control" placeholder="Enter State">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">PIN Code</label>
                                    <input type="text" name="tpincode" id="tpincode" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control" placeholder="Enter PIN Code">
                                </div>
                            </div>

                            <!-- Footer Buttons -->
                            <div class="modal-footer-btn">
                                <a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
                                <input type="submit" class="btn btn-submit" name="submit" value="Submit">
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--add staff modal -->
<div class="modal fade" id="add-staff">
    <div class="modal-dialog modal-dialog-centered custom-modal-two">
        <div class="modal-content">
            <div class="page-wrapper-new p-0">
                <div class="content">
                    <div class="modal-header border-0 custom-modal-header">
                        <div class="page-title">
                            <h4>Add New Staff</h4>
                        </div>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body custom-modal-body">
                        <form id="addStaffForm">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="form-label">Staff Name</label>
                            <input type="text" name="sstaff_name" id="sstaff_name" class="form-control" required> 
                        </div>
                       
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Phone1</label>
                            <input type="text" name="sphone1"  class="form-control" id="sphone1" placeholder="Enter Phone" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Phone2</label>
                            <input type="text" name="sphone2" class="form-control" id="sphone2" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">

                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Payment</label>
                            <input type="text" name="spayment" class="form-control"  id="spayment" placeholder="Enter Payment" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">

                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">Payment Date</label>
                            <input type="date" name="spayment_date" id="spayment_date" class="form-control" placeholder="Enter Payment Date">

                        </div>
                    </div>
      
                    <div class="mb-3">
                        <div class="input-blocks summer-description-box transfer mb-3">
                            <label>Address</label>
                            <textarea class="form-control h-100" rows="5" id="saddress" name="saddress" placeholder="Enter Address"></textarea>
                            
                        </div>
                    </div>
                 
                     <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">City</label>
                            <input type="text" name="scity" id="scity"  class="form-control" placeholder="Enter City">

                        </div>
                    </div>
                     <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">State</label>
                            <input type="text" name="sstate" id="sstate"  class="form-control" placeholder="Enter State">

                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="mb-3 add-product">
                            <label class="form-label">PIN Code</label>
                            <input type="text" name="spincode" id="spincode" onkeypress="return event.charCode >= 48 && event.charCode <= 57" class="form-control" placeholder="Enter PIN Code">

                        </div>
                    </div>
                        <div class="modal-footer-btn">
                            <a href="javascript:void(0);" class="btn btn-cancel me-2" data-bs-dismiss="modal">Cancel</a>
                            <input type="submit" class="btn btn-submit" name="submit" value="Submit">
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Warehouse Info Modal -->
<div class="modal fade" id="warehouseModal" tabindex="-1" aria-labelledby="warehouseModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="warehouseModalLabel">Roll Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="warehouseModalBody">
        <!-- Content dynamically inserted here -->
      </div>
    </div>
  </div>
</div>


<!-- Roll Selection Modal -->
<div class="modal fade" id="rollModal" tabindex="-1" role="dialog" aria-labelledby="rollModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document"> <!-- modal-lg for wide table -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="rollModalLabel">Select Roll</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body" id="rollData">
        <!-- Dynamic table of rolls will be injected here -->
      </div>
    </div>
  </div>
</div>



<!--end modal-->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>




<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
$(document).ready(function () {

    $('#order-status').on('change', function() {
        var status=$('#order-status').val();
        if(status == 'Measurement'){
            $('#installers').show();
        }else{
            $('#installers').hide();
        }
    });

    $('#customer_type').on('change', function() {
		var type = $('#customer_type').val();
		    if(type == 'Wholesale'){
				$('#customer_disc').show();
			}else{
				$('#customer_disc').hide();
			}
	});



    document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    

    $(document).on('click', '.add-item', function (e) {
        e.preventDefault();

        let lastFilledRow = $('#order-items tbody tr').filter(function() {
            return $(this).find('input').filter(function() {
                return $(this).val().trim() !== ''; // Check if any input has value
            }).length > 0; // If there is at least one non-empty input, it's filled
        }).last(); // Get the last filled row

        let newRow = lastFilledRow.length ? lastFilledRow.clone() : $('#order-items tbody tr:first').clone();
        newRow.find('input').val(''); // Clear input fields
  

        // Append the new row **after the last filled row**
        lastFilledRow.length ? lastFilledRow.after(newRow) : $('#order-items tbody').prepend(newRow);
       
    });

    // Remove Item Event
    // $(document).on('click', '.remove-item', function (e) {
    //     e.preventDefault();
    //     $(this).closest('tr').remove();
    //      calculateTotal();
    // });

    $(document).on('click', '.remove-item', function (e) {
     e.preventDefault();

     const $row = $(this).closest('tr');
     const rollId = parseFloat($row.find('.rollno').val());
     const qty = parseFloat($row.find('.quantity').val()) || 0;

      // Update usedRollQuantities
     if (rollId && usedRollQuantities[rollId]) {
        usedRollQuantities[rollId] -= qty;

        // Prevent going negative
        if (usedRollQuantities[rollId] < 0) {
            usedRollQuantities[rollId] = 0;
        }
     }

     $row.remove();
     calculateTotal();
   });




    // -----------------------------------------------------------------------------------------
    // Written by sachin darkunde on 10 june 2025
    // following functions for fetch product on company select and fetch varients on product selection

    // On company change → update products in each row
    $(document).on('change', '#company_id', function () {
        let companyId = $(this).val();

        if (companyId) {
            $.ajax({
                url: '/get-products-by-company',
                method: 'GET',
                data: { companyid: companyId },
                success: function (response) {
                    $('.product-select').each(function () {
                        let productSelect = $(this);
                        productSelect.empty().append('<option value="">Select Product</option>');
                        response.forEach(product => {
                            productSelect.append(`<option value="${product.product_id}">${product.product_name}</option>`);
                        });
                        productSelect.prop('disabled', false);
                    });

                    // Clear all variant dropdowns
                    $('.variant-select').each(function () {
                        $(this).empty().append('<option value="">Select Variant</option>').prop('disabled', true);
                    });
                },
                error: function () {
                    alert('Failed to fetch products. Please try again.');
                }
            });
        }
    });

    // On product change in a row → fetch variants only for that row
    $(document).on('change', '.product-select', function () {
        const productId     = $(this).val();
        const currentRow    = $(this).closest('tr');
        const variantSelect = currentRow.find('.variant-select');

        variantSelect.empty().append('<option value="">Select Variant</option>');

        if (productId) {
            $.ajax({
                url: '/get-variants-by-product',
                method: 'GET',
                data: { product_id: productId },
                success: function (response) {
                    if (response.length > 0) {
                        response.forEach(variant => {
                            variantSelect.append(`<option value="${variant.id}">${variant.varient_name} - ${variant.varient_code}</option>`);
                        });
                        variantSelect.prop('disabled', false);
                    } else {
                        variantSelect.prop('disabled', true);
                        Swal.fire({
                            icon: 'info',
                            title: 'No Variants',
                            text: 'No variants found for selected product.',
                            confirmButtonColor: '#3085d6'
                        });
                    }
                },
                error: function () {
                    alert('Failed to fetch variants.');
                }
            });
        } else {
            variantSelect.prop('disabled', true);
        }
    });

    // -----------------------------------------------------------------------------------------


    const customerSelect = $('#customer_id');
    customerSelect.on('change', function () {

        customerid = $(this).val();


        if (customerid) {
            $.ajax({
                url: `/get-customerdetails/${customerid}`,
                method: 'GET',
                data: { customerid: customerid },
                success: function (response) {

                    $('#special_discount').show();
                    $('.disc_percent').val(response.customer_discount);
                   
                },
                error: function () {
                    $('.disc_percent').val('0');  
                    $('.discount_amount').val('0');
                    $('#special_discount').hide();
                        
                    // alert('Failed to fetch customer. Please try again.');
                }
            });
        }else{
         
            $('.disc_percent').val('0');  
            $('.discount_amount').val('0');
            $('#special_discount').hide();
        }
    });




    $(document).on('change', '.variant-select', function () {
    var variantId = $(this).val(); 
    var row = $(this).closest('tr'); 

    if (variantId) {
        // First AJAX: Get Variant Details
        $.ajax({
            url: '<?php echo e(route("getVariantDetailsorder")); ?>', 
            type: 'GET',
            data: { id: variantId },
            success: function (response) {
                console.log(response);
                row.find('.rate').val(response.rate);
             //   row.find('.availability').val(response.availability);
                row.find('.uom').val(response.uom_id);

                // Second AJAX: Get Warehouse Data (based on variant ID)
                $.ajax({
                    url: '<?php echo e(route("getVariantWarehouses")); ?>',
                    type: 'GET',
                    data: { variant_id: variantId },
                    success: function (warehouseData) {
                        console.log(warehouseData);
                        // Assuming you're displaying warehouses in a dropdown
                        var warehouseSelect = row.find('.warehouse-select');
                        warehouseSelect.empty(); // clear existing options
                        warehouseSelect.empty().append(
                            $('<option>', {
                                value: '',
                                text: 'Select Warehouse'
                            })
                        );
                        $.each(warehouseData, function (key, warehouse) {
                          
                            warehouseSelect.append(
                                $('<option>', {
                                    value: warehouse.id,
                                    text: warehouse.warehouse_name
                                })
                            );
                        });

                 warehouseSelect.off('change').on('change', function () {

                        $('#rollModal').data('activeRow', row); // store row reference
                       // $('#rollModal').modal('show');


                        var selectedOption = $(this).find('option:selected');
                        var warehouseId = selectedOption.val();
                        var warehouseName = selectedOption.text();
                       

                        $.ajax({
                            url: '<?php echo e(route("getRollsByVariantWarehouse")); ?>',
                            type: 'GET',
                            data: {
                                variant_id: variantId,
                                warehouse_id: warehouseId
                            },
                            success: function (rolls) {
                                var html = `<p><strong>Warehouse:</strong> ${warehouseName}</p>`;

                                if (rolls.length > 0) {
                                    
                                    html += `
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Action</th>
                                                    <th>Quantity</th>
                                                    <th>Roll No</th>
                                                </tr>
                                            </thead>
                                            <tbody>`;

                                    rolls.forEach(function (roll, index) {
                                         const rollId = roll.id;
                                        const used = usedRollQuantities[rollId] || 0;
                                        const remaining = parseInt(roll.availability) - used;
                                          if (remaining <= 0) return;
                                        html += `
                                            <tr>
                                                <td>
                                                    <button type="button" class="btn btn-primary select-roll"
                                                        data-roll-id="${roll.id}"
                                                        data-retail-price="${roll.retail_price}"
                                                        data-availability="${remaining}"
                                                        data-varient-code="${roll.varient_code}"
                                                        data-thickness="${roll.thickness}"
                                                        data-roll-no="${roll.id}">
                                                        <i class="fa fa-check"></i>
                                                    </button>
                                                </td>
                                                <td>${roll.varient_code}/${roll.thickness}/-${remaining}-${roll.retail_price}</td>
                                                <td>${roll.id}</td>
                                            </tr>`;
                                    });

                                    html += `</tbody></table>`;
                                } else {
                                    html += `<p>No rolls found for this variant and warehouse.</p>`;
                                }

                                $('#warehouseModalBody').html(html);
                                $('#warehouseModal').modal('show');
                            },

                            error: function (xhr) {
                                console.error("Error fetching rolls: ", xhr.responseText);
                            }
                        });
                    });


                    },
                    error: function (xhr) {
                        console.error("Error fetching warehouse data: ", xhr.responseText);
                    }
                });
            },
            error: function (xhr) {
                console.error("Error fetching variant details: ", xhr.responseText);
            }
        });
    }
});



$(document).on('change', '.warehouse-select', function () {
    var warehouseId = $(this).val();
    var row = $(this).closest('tr');
    var variantId = row.find('.variant-select').val();

    if (warehouseId && variantId) {
        $.ajax({
            url: '<?php echo e(route("getVariantWarehouseAvailability")); ?>',
            type: 'GET',
            data: {
                warehouse_id: warehouseId,
                variant_id: variantId
            },
            success: function (response) {
                //row.find('.availability').val(response.availability);
            },
            error: function (xhr) {
                console.error("Error fetching availability: ", xhr.responseText);
            }
        });
    }
});



    // Rate and Quantity Input Event
    $(document).on('input', '.rate, .quantity', function () {
       let row = $(this).closest('tr');
       let rate = parseFloat(row.find('.rate').val()) || 0;
       let quantity = parseFloat(row.find('.quantity').val()) || 0;
      
       let variantId = row.find('.varient_id').val();
       //alert(variantId);

        if (quantity > 0 && variantId) {
            $.ajax({
              url: '/check-availability/' + variantId,
              method: 'GET',
              success: function (response) {
                let availableQty = parseFloat(response.available);

                if (quantity > availableQty) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Quantity exceeds stock!',
                        text: 'Available stock: ' + availableQty,
                        confirmButtonColor: '#d33'
                    });

                    row.find('.quantity').val('');
                    row.find('.rate').val('');
                    row.find('.varient_id').val('');
                    row.find('.total').val('0.00');
                     $('input[name="subtotal"]').val(0.00);
                     $('input[name="grand_total"]').val(0.00);
                } else {
                    let total = rate * quantity;
                    row.find('.total').val(total.toFixed(2));
                    calculateTotal();
                }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        text: 'Error checking availability.',
                        confirmButtonColor: '#d33'
                    });
                }
            });
        }
        
      //let total = rate * quantity;
     // row.find('.total').val(total.toFixed(2));
     // calculateTotal();
    });
  
  
   


    $('input[name="t_percent"]').on('input', calculateTax);


    function calculateTax() {

        var tax_percent = parseFloat($('input[name="t_percent"]').val()) || 0; 
        var grosstotal = parseFloat($('input[name="subtotal"]').val()) || 0; 
        var t_amount = parseFloat($('input[name="t_amount"]').val()) || 0;
        var taxdata = grosstotal * tax_percent / 100;
        $('input[name="t_amount"]').val(taxdata.toFixed(2)); 
        calculateTotal();
    }


    function calculatediscount() {

        var disc_percent = parseFloat($('input[name="disc_percent"]').val()) || 0; 
        var grosstotal = parseFloat($('input[name="subtotal"]').val()) || 0; 
        var d_amount = parseFloat($('input[name="discount_amount"]').val()) || 0;
        var discdata = grosstotal * disc_percent / 100;
        $('input[name="discount_amount"]').val(discdata.toFixed(2)); 

    }
  

    function calculateTotal() {
        let subtotal = 0;
       
        $('#order-items tbody tr').each(function () {
            let total = parseFloat($(this).find('.total').val()) || 0;
            subtotal += total;
        });

        // Update subtotal
        $('input[name="subtotal"]').val(subtotal.toFixed(2));
            let discpercent = parseFloat($('input[name="disc_percent"]').val());
            if(discpercent >0){
            calculatediscount();
         }
        let tamount = parseFloat($('input[name="t_amount"]').val()) || 0;
        let damount = parseFloat($('input[name="discount_amount"]').val()) || 0;
        let grandTotal = subtotal + tamount-damount;
        grandTotal = parseFloat(grandTotal).toFixed(2);
        $('input[name="grand_total"]').val(grandTotal);
    }


    $('#company_id').select2({
        placeholder: "Select Company",   
        allowClear: true,
		search:true,
		          
    });

    $('#customer_id').select2({
        placeholder: "Select Customer",   
        allowClear: true,
		search:true,
		          
    });

    $('#transporter_id').select2({
        placeholder: "Select Transporter",   
        allowClear: true,
		search:true,
		          
    });

    //end
    $('#addCustomerForm').submit(function(e) {
			e.preventDefault(); 
			    var customerName = $('#customer_name').val();
			    var customer_type = $('#customer_type').val();
			    var email = $('#email').val();
			    var mobile_no = $('#mobile_no').val();
			    var phone = $('#phone1').val();
			    var pincode = $('#pincode').val();
			    var address = $('#address').val();
			    var gst_no = $('#gst_no').val();
                 var msme = $('#msme').val();
			    var customer_discount=$('#customer_discount').val();
			$.ajax({
				url: "<?php echo e(route('add_customer_dynamic')); ?>", 
				method: 'POST',
				data: {
					    _token: '<?php echo e(csrf_token()); ?>',
					    name: customerName,
                        customer_type:customer_type,
                        email:email,
					    mobile_no:mobile_no,
					    phone:phone,
					    pincode:pincode,
					    address:address,
					    gst_no:gst_no,
                         msme:msme,
					    customer_discount:customer_discount
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-customer').modal('hide');

						$('#addCustomerForm')[0].reset();

						$('select[name="customer_id"]').append('<option value="' + response.customer.id + '" selected>' + response.customer.customer_name + '</option>');

						//alert('Customer added successfully!');
						Swal.fire({
						    icon: 'success',
						    title: 'Customer added successfully!',
						    showConfirmButton: false,
						    timer: 2000
						});
						
					} else {
						alert('Failed to add customer!');
					}
				},
				error: function() {
					alert('An error occurred while adding the brand.');
				}
			});
	});

      $('#addTransporterForm').submit(function(e) {
    e.preventDefault(); 

    var transporterName = $('#transporter_name').val();
    var contact_person = $('#tcontact_person').val();
    var email = $('#temail').val();
    var phone1 = $('#tphone1').val();
    var phone2 = $('#tphone2').val();
    var pincode = $('#tpincode').val();
    var city = $('#tcity').val();
    var state = $('#tstate').val();
    var address = $('#taddress').val();
    var gst_no = $('#tgst_no').val();
    var msme = $('#tmsme').val();

    $.ajax({
        url: "<?php echo e(route('add_transporter_dynamic')); ?>",
        method: 'POST',
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            transporter_name: transporterName,
            contact_person: contact_person,
            email: email,
            phone1: phone1,
            phone2: phone2,
            city: city,
            state: state,
            pincode: pincode,
            address: address,
            gst_no: gst_no,
            msme: msme
        },
        success: function(response) {
            if (response.success) {
                $('#add-transporter').modal('hide');
                $('#addTransporterForm')[0].reset();
                $('select[name="transporter_id"]').append('<option value="' + response.transporter.id + '" selected>' + response.transporter.transporter_name + '</option>');

                Swal.fire({
                    icon: 'success',
                    title: 'Transporter added successfully!',
                    showConfirmButton: false,
                    timer: 2000
                });
            } else {
                alert('Failed to add transporter!');
            }
        },
        error: function(err) {
            console.log(err);
            alert('An error occurred while adding the transporter.');
        }
    });
});

     $('#addStaffForm').submit(function(e) {
			e.preventDefault(); 
			    var name = $('#sstaff_name').val();
			    var payment = $('#spayment').val();
			    var paymentdate = $('#spayment_date').val();
			    var address = $('#saddress').val();
			    var city = $('#scity').val();
			    var state = $('#sstate').val();
			    var pincode = $('#spincode').val();
			    var phone1 = $('#sphone1').val();
			    var phone2=$('#sphone2').val();
             
			$.ajax({
				url: "<?php echo e(route('add_staff_dynamic')); ?>", 
				method: 'POST',
				data: {
					    _token: '<?php echo e(csrf_token()); ?>',
					    name: name,
                        payment:payment,
                        paymentdate:paymentdate,
					    address:address,
					    city:city,
					    state:state,
					    phone1:phone1,
					    phone2:phone2,
					    pincode:pincode
				},
				success: function(response) {
					if (response.success) {
						
						$('#add-staff').modal('hide');

						$('#addStaffForm')[0].reset();

						$('select[name="staff_id"]').append('<option value="' + response.staff.id + '" selected>' + response.staff.full_name + '</option>');

						//alert('Customer added successfully!');
						Swal.fire({
						    icon: 'success',
						    title: 'Staff added successfully!',
						    showConfirmButton: false,
						    timer: 2000
						});
						
					} else {
						alert('Failed to add staff!');
					}
				},
				error: function() {
					alert('An error occurred while adding the staff.');
				}
			});
	});


    
        
});









     let usedRollQuantities = {}; // ✅ define only once at top

   $(document).on('input', '.quantity', function () {
    const $row = $(this).closest('tr');
    const quantity = parseFloat($(this).val()) || 0;
    const rollId = parseFloat($row.find('.rollno').val());
    const originalAvailability = $row.data('original-availability');

    if (!rollId || !originalAvailability) return;

    let totalUsed = 0;

    $('.rollno').each(function () {
        const currentRow = $(this).closest('tr');
        const currentRollId = parseFloat($(this).val());

        if (currentRollId === rollId) {
            if (currentRow[0] === $row[0]) return;

            const rowQty = parseFloat(currentRow.find('.quantity').val()) || 0;
            totalUsed += rowQty;
        }
    });

    const finalUsed = totalUsed + quantity;

    if (finalUsed > originalAvailability) {
        alert('Total quantity used from this roll exceeds original availability.');
        $(this).val('');
        usedRollQuantities[rollId] = totalUsed;
        return;
    }

    usedRollQuantities[rollId] = finalUsed;

    const rate = parseFloat($row.find('.rate').val()) || 0;
    $row.find('.total').val((quantity * rate).toFixed(2));
});






    
$(document).on('click', '.select-roll', function () {
    var row = $('#rollModal').data('activeRow'); // get the current row

    // Get data from selected roll
    var availability = $(this).data('availability');
    
    //var retailPrice = $(this).data('retail-price');
    var rollNo = $(this).data('roll-no');

    // Update the row fields
    row.find('.availability').val(availability);
     row.find('.rollno').val(rollNo);
       var originalAvailability = availability + (usedRollQuantities[rollNo] || 0); // get true original


    // // If you want to store roll_no in a hidden field, create it first:
    // if (!row.find('.roll-no').length) {
    //     row.append(`<input type="hidden" name="roll_no[]" class="roll-no" value="${rollNo}">`);
    // } else {
    //     row.find('.roll-no').val(rollNo);
    // }
 row.data('original-availability', originalAvailability);
    // Close modal
    $('#rollModal').modal('hide');
});



</script>

<script>
function validateGST(input) {
    const gstRegex = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[0-9]{1}[A-Z]{2}$/;
    const gstValue = input.value;

    if (gstValue.length < 15) {
        // Show error if user typed something but less than 15 chars
        if (gstValue.length > 0) {
            document.getElementById("gst-error").style.display = "block";
            document.getElementById("gst-error").textContent = "GSTIN must be 15 characters.";
            input.style.borderColor = "red";
        } else {
            document.getElementById("gst-error").style.display = "none";
            input.style.borderColor = "";
        }
        return;
    }

    if (gstRegex.test(gstValue)) {
        // Valid GST
        document.getElementById("gst-error").style.display = "none";
        input.style.borderColor = "#28a745";
    } else {
        // Invalid GST
        document.getElementById("gst-error").style.display = "block";
        input.style.borderColor = "red";
        input.value = ""; // Clear input

        // Force focus back
        setTimeout(() => {
            input.focus();
        }, 0);
    }
}
function validateMSME(input) {
    const msmeRegex = /^UDYAM-[A-Z]{2}-\d{2}-\d{7}$/;
    let msmeValue = input.value.trim().toUpperCase();
    input.value = msmeValue; // Always uppercase

    if (msmeValue.length === 0) {
        document.getElementById("msme-error").style.display = "none";
        input.style.borderColor = "";
        return;
    }

    if (msmeRegex.test(msmeValue)) {
        document.getElementById("msme-error").style.display = "none";
        input.style.borderColor = "#28a745";

        // Optional: Check uniqueness via AJAX
       
    } else {
        document.getElementById("msme-error").style.display = "block";
        document.getElementById("msme-error").textContent = "Invalid format. Use UDYAM-XX-00-0000000";
        input.style.borderColor = "red";
    }
}
</script>

<script>
function validateGSTtrans(input) {
    const gstRegex = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[0-9]{1}[A-Z]{2}$/;
    const gstValue = input.value;

    if (gstValue.length < 15) {
        // Show error if user typed something but less than 15 chars
        if (gstValue.length > 0) {
            document.getElementById("gsttrans-error").style.display = "block";
            document.getElementById("gsttrans-error").textContent = "GSTIN must be 15 characters.";
            input.style.borderColor = "red";
        } else {
            document.getElementById("gsttrans-error").style.display = "none";
            input.style.borderColor = "";
        }
        return;
    }

    if (gstRegex.test(gstValue)) {
        // Valid GST
        document.getElementById("gsttrans-error").style.display = "none";
        input.style.borderColor = "#28a745";
    } else {
        // Invalid GST
        document.getElementById("gsttrans-error").style.display = "block";
        input.style.borderColor = "red";
        input.value = ""; // Clear input

        // Force focus back
        setTimeout(() => {
            input.focus();
        }, 0);
    }
}
function validateMSMEtrans(input) {
    const msmeRegex = /^UDYAM-[A-Z]{2}-\d{2}-\d{7}$/;
    let msmeValue = input.value.trim().toUpperCase();
    input.value = msmeValue; // Always uppercase

    if (msmeValue.length === 0) {
        document.getElementById("msmetrans-error").style.display = "none";
        input.style.borderColor = "";
        return;
    }

    if (msmeRegex.test(msmeValue)) {
        document.getElementById("msmetrans-error").style.display = "none";
        input.style.borderColor = "#28a745";

       
      
    } else {
        document.getElementById("msmetrans-error").style.display = "block";
        document.getElementById("msmetrans-error").textContent = "Invalid format. Use UDYAM-XX-00-0000000";
        input.style.borderColor = "red";
    }
}
</script><?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/admin/add-new-order.blade.php ENDPATH**/ ?>