<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<style>
			.form-check-input{
				height: 15px!important;
				width: 15px!important;
			}
			</style>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Company</h4>
							<h6>Create new company</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('company_list')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Company</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
				<!-- /add -->
				<form action="<?php echo e(route('save_company')); ?>" method="post" id="myForm">
					<?php echo csrf_field(); ?>
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Company Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Company Id</label>
													<input type="text" name="company_id" class="form-control" value="<?php echo e($newCompanyId); ?>" readonly>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Company Name</label>
													<input type="text" name="company_name" id="company_name" class="form-control" placeholder="Enter Company Name"><small id="company-error" style="color: red; display: none;">This company is already registered!</small>
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Warehouse  (Can select multiple )</label>
													<select class="select" name="warehouse_id[]" required multiple>
													
														<option value="" disabled>Select Multiple</option>
													<?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($row->id); ?>"><?php echo e($row->warehouse_name); ?></option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
												</div>
											</div>
											<div class="row">
												<div class="col-lg-4 col-sm-6 col-12">
													<div class="mb-3 add-product">
														<label class="form-label">GST</label>
														<div class="d-flex align-items-center">
															<div class="form-check me-4">
																<input type="radio" name="gst" id="gst-yes" value="Yes" class="form-check-input">
																<label for="gst-yes" class="form-check-label">Yes</label>
															</div>
															<div class="form-check">
																<input type="radio" name="gst" id="gst-no" value="No" class="form-check-input">
																<label for="gst-no" class="form-check-label">No</label>
															</div>
														</div>
													</div>
												</div>

											<div class="col-lg-4 col-sm-6 col-12" id="gst_no" style="display: none">
												<div class="mb-3 add-product">
													<label class="form-label">GST No</label>
													<input type="text" name="gst_no" class="form-control" placeholder="Enter GST No" id="myTextbox" >
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">MSME</label>
													<input type="text" name="msme" class="form-control" placeholder="Enter MSME">
												</div>
											</div>
										</div>
											
										</div>

										<div class="row">
											<div class="col-lg-2 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Telephone code</label>
													<input type="text" class="form-control list" name="code"  placeholder="Enter Code" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Phone1</label>
													<input type="text" name="phone1" class="form-control" placeholder="Enter Phone1" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">
												</div>
											</div>
											<div class="col-lg-3 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label class="form-label">Phone2</label>
													<input type="text" name="phone2" class="form-control list" placeholder="Enter Phone2" onkeypress="return event.charCode >= 48 && event.charCode <= 57 && this.value.length < 10">
													
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Fax No</label>
													<input type="text" name="fax" class="form-control list" placeholder="Enter Fax No" onkeypress="return event.charCode >= 48 && event.charCode <= 57">

												</div>
											</div>
										</div>

										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">City</label>
													<input type="text" name="city" class="form-control" placeholder="Enter City">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label>State</label>
													<input type="text" name="state" class="form-control list" placeholder="Enter State">
													
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="input-blocks add-product list">
													<label>Pincode</label>
													<input type="text" name="pincode" class="form-control list" placeholder="Enter Pincode" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
													
												</div>
											</div>
											
										</div>

										<!-- Editor -->
                                        <div class="col-lg-12">
                                            <div class="input-blocks summer-description-box transfer mb-3">
                                                <label>Address</label>
                                                <textarea class="form-control h-100" rows="5" name="address" placeholder="Enter Address"></textarea>
                                                
                                            </div>
                                        </div>
                                        <!-- /Editor -->
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="<?php echo e(url('company-list')); ?>" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit"  id="submitBtn" class="btn btn-submit">Save Company</button><p id="message" style="color: red;">
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->

	
	<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<script>
		$('input[name="gst"]').on('change', function () {
            if ($(this).val() === 'Yes') {
                $('#gst_no').show(); 
            } else {
                $('#gst_no').hide(); 
            }
        });
	</script>
	<script>
document.getElementById("myTextbox").addEventListener("input", function() {
    if (this.value.length > 15) {
        alert("GST No length is 15.");
        this.value = this.value.substring(0, 15);
       
    }
});

document.getElementById("myTextbox").addEventListener("blur", function() {
    if (this.value.length !== 15) {
        if (!this.dataset.alertShown) { 
            alert("GST number must be exactly 15 characters.");
            this.dataset.alertShown = "true"; 
        }
        this.focus();
    } else {
        this.dataset.alertShown = ""; 
    }
});

document.getElementById("myTextbox").addEventListener("input", function() {
    this.dataset.alertShown = "";
});
 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
     $("#company_name").on("keyup blur", function (e) { 
        let company_name = $(this).val();
       
            $.ajax({
                url: "<?php echo e(route('check_company_exists')); ?>",
                type: "POST",
                data: {
                    company_name: company_name,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#company-error").show(); 
                        $("#company_name").addClass("error-field"); 
                        $("#company_name").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This company name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#company-error").hide(); 
                        $("#company_name").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#company_name").on("keydown", function (e) {
        if (e.key === "Tab" && $("#company-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
</script>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add-company.blade.php ENDPATH**/ ?>