<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Today's Cutting</title>
</head>
<style>
    @page  {
        size: A4 landscape;
        margin: 45px 40px 20px 40px;
    }

    body {
        font-family: Arial, sans-serif;
    }

    /* Table Styling */
    table {
        width: 100%;
        border-collapse: collapse;
        border: 1px solid black;
    }

    th, td {
        border: 1px solid black;
        text-align: left;
        padding: 8px;
        font-size: 16px;
    }

    th {
        background-color: #f2f2f2;
        font-weight: bold;
        text-align: center;
    }

    /* Header Styling */
    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 20px;
        border-bottom: 2px solid black;
    }

    .header img {
        height: 50px;
        width: 200px;
    }

    .header .company-details {
        text-align: right;
    }

    .report-title {
        text-align: center;
        margin-top: 20px;
        font-size: 24px;
        font-weight: bold;
    }

    .report-date {
        margin-top: 10px;
        font-size: 18px;
        font-weight: bold;
    }
</style>
<body>

    <header class="header">
        <div>
            <img src="assets/img/report_images/img.png" alt="Company Logo">
        </div>
        <div class="company-details">
            <b>XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324</b>
        </div>
    </header>

    <div class="report-title">Today's Cutting</div>

    <div class="report-date"><?php echo e(date('d-m-Y')); ?></div>

    <section>
        <table>
            <thead>
                <tr>
                    <th>OrdNo</th>
                    <th>Customer Name</th>
                    <th>Roll No</th>
                    <th>Design Name</th>
                    <th>From <br> Quality</th>
                    <th>Quantity</th>
                    <th>Balance</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                
                <?php $__currentLoopData = $order_receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($order->customer_name != ''): ?>
                    <tr>
                        <td><b><?php echo e($order->id); ?></b></td>
                        <td colspan="7"></td>
                    </tr>
                    <?php $__currentLoopData = $order->order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td></td>
                        <td><?php echo e($order->customer_name); ?></td>
                        <td><?php echo e($item->roll_id); ?></td>
                        <td><?php echo e($item->varient_id); ?></td>
                        <td><?php echo e(number_format($item->price, 2)); ?></td>
                        <td><?php echo e(number_format($item->quantity, 2)); ?></td>
                        <td><?php echo e(number_format($item->available_quantity, 2)); ?></td>
                        <td><?php echo e($item->installer_status); ?></td>
                    </tr>
                  
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <!-- Total for each order -->
                    <tr>
                        <td colspan="4" style="border-top: 1px solid black; font-weight: bold; text-align: right;">TOTAL</td>
                        <td style="border-top: 1px solid black; font-weight: bold; text-align: right;">
                            <?php echo e(number_format(collect($order->order_items)->sum('price'), 2)); ?>

                        </td>
                        <td colspan="3"></td>
                    </tr>
                <?php endif; ?>    
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $grandTotal = collect($order_receipts)->sum(fn($order) => collect($order->order_items)->sum('price'));
                ?>

                <!-- Grand Total -->
                <tr>
                    <td colspan="4" style="border-bottom: double; font-weight: bold; text-align: right;">Grand Total</td>
                    <td style="border-bottom: double; font-weight: bold; text-align: right;">
                        <?php echo e(number_format($grandTotal, 2)); ?>

                    </td>
                    <td colspan="3"></td>
                </tr>
            </tbody>
        </table>
    </section>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/todayscutting.blade.php ENDPATH**/ ?>