<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bill NOT UPDATED</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 5px;
            font-size: 14px;
            border: 1px solid black;
        }

        th {
            /*background-color: #f2f2f2;*/
            vertical-align: middle;
        }

        .text-right {
            text-align: right;
        }

       .header {
                display: flex;
                justify-content: space-between;
                align-items: flex-start;
                margin-bottom: 20px;
            }

            .logo-section {
                display: flex;
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }


        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 20px;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }
    </style>
      <style>
    .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

      .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}
.back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

   

  </style>

  <style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
  
</head>
<body>
  <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('orders')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header>
<hr>

    <section style="margin-top: 30px;">
        <div class="title">BILL NOT UPDATED</div>

        <?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('bill_report')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="<?php echo e(request('start_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="<?php echo e(request('end_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
     <label for="payment_mode" style="margin-bottom: 0; font-size:15px"><b>Payment Mode:</b></label>
    <select name="payment_mode"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">All</option>
        <option value="Cash" <?php echo e(request('payment_mode') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
        <option value="Online" <?php echo e(request('payment_mode') == 'Online' ? 'selected' : ''); ?>>Online</option>
        <option value="Cheque" <?php echo e(request('payment_mode') == 'Cheque' ? 'selected' : ''); ?>>Cheque</option>
         <option value="Bank Transfer" <?php echo e(request('payment_mode') == 'Bank Transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
        
        <!-- Add more modes if needed -->
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('bill_report')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>


<!--UPDATED CODE-->
<table class="table table-bordered" style="width: 100%; font-size: 14px; border-collapse: collapse;" border="1">
    <thead>
        <tr class="text-center" style="background-color: #f8f9fa;">
            <th>Order No</th>
            <th>Rec No</th>
            <th>Customer Name</th>
            <th>Total </th>
            <th>Paid </th>
            <th>Balance</th>
            <th>Transaction Date</th>
            <th>Payment Method</th>
            <th>Receipt Type</th>
            <th>Remark</th>
        </tr>
    </thead>
    <tbody>
        <?php 
            $grandBalance = 0; 
        ?>

        <?php $__currentLoopData = $groupedOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_id => $transactions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $first = $transactions->first();
                if ($first->payment_status !== 'Partially Paid') continue;

                $dynamicTotal = $first->order_amount;
                $rowCount = $transactions->count();

                // Get the last transaction of this order group
                $lastTxn = $transactions->last();

                // Add last transaction's remaining amount to grand total
                $grandBalance += $lastTxn->remaining_amount;
            ?>

            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $txn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    
                    <?php if($loop->first): ?>
                        <td rowspan="<?php echo e($rowCount); ?>"><?php echo e($txn->order_code ?? '-'); ?></td>
                        <td rowspan="<?php echo e($rowCount); ?>">
                            <?php echo e($txn->rec_no); ?>

                        </td>
                        <td rowspan="<?php echo e($rowCount); ?>"><?php echo e($txn->customer_name ?? '-'); ?></td>
                    <?php endif; ?>

                    <td> <?php echo e(number_format($dynamicTotal, 2)); ?></td>
                    <td> <?php echo e(number_format($txn->pay_amount, 2)); ?></td>

                    
                    <td class="text-end">
                        <?php if($loop->last): ?>
                            <?php echo e(number_format($txn->remaining_amount, 2)); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>

                    <td><?php echo e(\Carbon\Carbon::parse($txn->transaction_date)->format('d-m-Y')); ?></td>

                    
                    <td>
                        <?php if($txn->payment_mode === 'Bank Transfer'): ?>
                            Bank Transfer<br>
                            <strong>Bank Name:</strong> <?php echo e($txn->bank_name ?? '-'); ?><br>
                            <strong>Ac No:</strong> <?php echo e($txn->account_number ?? '-'); ?><br>
                            <strong>IFSC Code:</strong> <?php echo e($txn->ifsc_code ?? '-'); ?>

                        <?php elseif($txn->payment_mode === 'Cheque'): ?>
                            Cheque<br>
                            <strong>Cheque No:</strong> <?php echo e($txn->cheque_number ?? '-'); ?>

                        <?php elseif($txn->payment_mode === 'Online'): ?>
                            Online<br>
                            <strong>Txn ID:</strong> <?php echo e($txn->reference_id ?? '-'); ?>

                        <?php else: ?>
                            <?php echo e($txn->payment_mode ?? '-'); ?>

                        <?php endif; ?>
                    </td>

                    <td><?php echo e($txn->receipt_type ?? '-'); ?></td>
                    <td><?php echo e($txn->remark ?? '-'); ?></td>
                </tr>

                <?php
                    $dynamicTotal = $txn->remaining_amount;
                ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <tr style="background-color: #f1f1f1;">
            <td colspan="5" class="text-end"><strong>Total Balance:</strong></td>
            <td class="text-end" style="border-bottom: double; font-size: 16px;">
                <strong><?php echo e(number_format($grandBalance, 2)); ?></strong>
            </td>
            <td colspan="4"></td>
        </tr>
    </tbody>
</table>



<br><br>





        <?php if(!$is_pdf): ?>
          
         <a class="custom-button"  href="<?php echo e(route('bill_report_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'payment_mode' => request('payment_mode')])); ?>">Download</a>
           <button type="button" class="custom-button" onclick="window.print()">Print</button>
         <?php endif; ?>
    </section>
</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/billnotupdated.blade.php ENDPATH**/ ?>